/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.persist.world.GlobalCounters;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityEntangledChalice;
import org.cyclops.evilcraft.core.fluid.FluidContainerItemWrapperWithSimulation;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;

public class ItemEntangledChalice
extends ItemBlockFluidContainer {
    public static String[] namePartsArray = "the elder scrolls klaatu berata niktu xyzzy bless curse light darkness fire air earth water hot dry cold wet ignite snuff embiggen twist shorten stretch fiddle destroy imbue galvanize enchant free limited range of towards inside sphere cube self other ball mental physical grow shrink demon elemental spirit animal creature beast humanoid undead fresh stale phnglui mglwnafh cthulhu rlyeh wgahnagl fhtagnbaguette".split(" ");

    public ItemEntangledChalice(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public boolean isFoil(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @Override
    protected void autofill(@Nullable EquipmentSlot itemSlot, IFluidHandlerItem source, Level world, Entity entity) {
        if (entity instanceof Player && !world.isClientSide()) {
            FluidStack tickFluid;
            Player player = (Player)entity;
            PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
            do {
                ItemStack filled;
                tickFluid = IModHelpersNeoForge.get().getFluidHelpers().getFluid((IFluidHandler)source);
                ItemStack toFill = it.next();
                if (tickFluid == null || toFill.isEmpty() || toFill.getCount() != 1 || (filled = ItemHelpers.tryFillContainerForPlayer(source, toFill, tickFluid, player)).isEmpty()) continue;
                it.replace(filled);
            } while (tickFluid != null && tickFluid.getAmount() > 0 && it.hasNext());
        }
    }

    @Override
    protected boolean itemStackDataToTile(ItemStack itemStack, BlockEntity tile) {
        super.itemStackDataToTile(itemStack, tile);
        FluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        String tankId = fluidHandler.getTankID();
        ((BlockEntityEntangledChalice)tile).setWorldTankId(tankId);
        return true;
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
        FluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        String tankId = fluidHandler == null ? "null" : fluidHandler.getTankID();
        tooltipAdder.accept((Component)Component.translatable((String)"block.evilcraft.entangled_chalice.info.id", (Object[])new Object[]{ItemEntangledChalice.tankIdToNameParts(tankId)}));
    }

    public static String tankIdToNameParts(String tankId) {
        try {
            int i = Integer.parseInt(tankId);
            String a = namePartsArray[(i + 3) % namePartsArray.length];
            String b = namePartsArray[(i * 3 + 5) % namePartsArray.length];
            String c = namePartsArray[(i * 13 + 7) % namePartsArray.length];
            return String.format("%s %s %s", a, b, c);
        }
        catch (NumberFormatException e) {
            return tankId;
        }
    }

    public static class FluidHandler
    extends FluidContainerItemWrapperWithSimulation {
        public FluidHandler(ItemStack container, int capacity) {
            super(container, capacity);
        }

        public FluidStack getFluid() {
            return WorldSharedTankCache.getInstance().getTankContent(this.getTankID());
        }

        protected void setFluid(FluidStack fluidStack) {
            WorldSharedTankCache.getInstance().setTankContent(this.getTankID(), fluidStack);
        }

        protected void setContainerToEmpty() {
            this.setFluid(FluidStack.EMPTY);
        }

        public String getTankID() {
            return (String)this.getContainer().getOrDefault(RegistryEntries.COMPONENT_WORLD_SHARED_TANK_ID, (Object)"");
        }

        public void setTankID(String tankID) {
            this.getContainer().set(RegistryEntries.COMPONENT_WORLD_SHARED_TANK_ID, (Object)tankID);
        }

        public void setNextTankID() {
            this.setTankID(Integer.toString(((GlobalCounters)EvilCraft.globalCounters.get()).getNext("EntangledChalice")));
        }
    }
}

