/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.cyclops.evilcraft.blockentity.BlockEntityEntangledChalice;
import org.cyclops.evilcraft.item.ItemEntangledChalice;

public class LootFunctionCopyEntangledChaliceData
extends LootItemConditionalFunction {
    public static final MapCodec<LootFunctionCopyEntangledChaliceData> CODEC = RecordCodecBuilder.mapCodec(builder -> LootFunctionCopyEntangledChaliceData.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootFunctionCopyEntangledChaliceData::new));
    public static final LootItemFunctionType TYPE = new LootItemFunctionType(CODEC);

    protected LootFunctionCopyEntangledChaliceData(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        BlockEntity tile = (BlockEntity)lootContext.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof BlockEntityEntangledChalice) {
            String tankId = ((BlockEntityEntangledChalice)tile).getWorldTankId();
            ItemEntangledChalice.FluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
            fluidHandler.setTankID(tankId);
        }
        return itemStack;
    }

    public LootItemFunctionType getType() {
        return TYPE;
    }
}

