/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerMutable;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;

public class LootFunctionCopyTankData
extends LootItemConditionalFunction {
    public static final MapCodec<LootFunctionCopyTankData> CODEC = RecordCodecBuilder.mapCodec(builder -> LootFunctionCopyTankData.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootFunctionCopyTankData::new));
    public static final LootItemFunctionType TYPE = new LootItemFunctionType(CODEC);

    protected LootFunctionCopyTankData(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        Object object = lootContext.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof BlockEntityTankInventory) {
            BlockEntityTankInventory tile = (BlockEntityTankInventory)((Object)object);
            SingleUseTank fluidHandlerTile = tile.getTank();
            Optional.ofNullable((IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM)).ifPresent(fluidHandlerItem -> {
                if (fluidHandlerItem instanceof IFluidHandlerMutable) {
                    ((IFluidHandlerMutable)fluidHandlerItem).setFluidInTank(0, fluidHandlerTile.getFluidInTank(0));
                }
                if (fluidHandlerItem instanceof IFluidHandlerItemCapacity) {
                    ((IFluidHandlerItemCapacity)fluidHandlerItem).setCapacity(fluidHandlerTile.getTankCapacity(0));
                }
            });
        }
        return itemStack;
    }

    public LootItemFunctionType getType() {
        return TYPE;
    }
}

