/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.bloodinfuser;

import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeHolderType;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.BlockEntityBloodInfuser;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.recipe.type.RecipeBloodInfuser;
import org.cyclops.evilcraft.item.ItemPromise;
import org.cyclops.evilcraftcompat.modcompat.jei.JEIEvilCraftConfig;

public class BloodInfuserRecipeCategory
implements IRecipeCategory<RecipeHolder<RecipeBloodInfuser>> {
    public static final IRecipeHolderType<RecipeBloodInfuser> TYPE = IRecipeHolderType.create((RecipeType)((RecipeType)RegistryEntries.RECIPETYPE_BLOOD_INFUSER.get()));
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;

    public BloodInfuserRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"evilcraftcompat", (String)"textures/gui/blood_infuser_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 130, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_BLOOD_INFUSER.get()));
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 146, 0, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(resourceLocation, 130, 0, 16, 58);
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public IRecipeType<RecipeHolder<RecipeBloodInfuser>> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)((Block)RegistryEntries.BLOCK_BLOOD_INFUSER.get()).getDescriptionId());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    protected int getMaxTankSize(RecipeBloodInfuser bloodInfuserRecipe) {
        return BlockEntityBloodInfuser.LIQUID_PER_SLOT * BlockEntityWorking.getTankTierMultiplier(bloodInfuserRecipe.getInputTier().orElse(0));
    }

    protected ItemStack getPromise(RecipeBloodInfuser bloodInfuserRecipe) {
        if (bloodInfuserRecipe.getInputTier().orElse(0) == 0) {
            return null;
        }
        return new ItemStack((ItemLike)ItemPromise.getItem(bloodInfuserRecipe.getInputTier().orElseThrow()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<RecipeBloodInfuser> recipeHolder, IFocusGroup focuses) {
        RecipeBloodInfuser recipe = (RecipeBloodInfuser)recipeHolder.value();
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 42, 28);
        recipe.getInputIngredient().ifPresent(arg_0 -> ((IRecipeSlotBuilder)inputSlot).add(arg_0));
        IRecipeSlotBuilder inputSlotFluid = builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 6, 6).setOverlay(this.tankOverlay, 0, 0).setFluidRenderer((long)this.getMaxTankSize(recipe), true, 16, 58);
        recipe.getInputFluid().ifPresent(fluidStack -> inputSlotFluid.add((IIngredientType)NeoForgeTypes.FLUID_STACK, fluidStack));
        ItemStack promise = this.getPromise(recipe);
        if (promise != null) {
            builder.addSlot(RecipeIngredientRole.CRAFTING_STATION, 42, 8).add(promise);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 28).add((Ingredient)recipe.getOutputItem().map(l -> Ingredient.of((ItemLike)l.getItem()), ItemStackFromIngredient::getIngredient));
    }

    public void draw(RecipeHolder<RecipeBloodInfuser> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        this.arrow.draw(guiGraphics, 65, 28);
        Font fontRenderer = Minecraft.getInstance().font;
        MutableComponent duration = JEIEvilCraftConfig.getDurationSecondsTextComponent(((RecipeBloodInfuser)recipe.value()).getDuration());
        guiGraphics.drawString(fontRenderer, (Component)duration, (this.background.getWidth() - fontRenderer.width((FormattedText)duration)) / 2 + 12, 50, ARGB.opaque((int)-8355712), false);
    }
}

