/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.jei.sanguinaryenvironmentalaccumulator;

import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.types.IRecipeHolderType;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.blockentity.tickaction.sanguinaryenvironmentalaccumulator.AccumulateItemTickAction;
import org.cyclops.evilcraft.core.recipe.type.RecipeEnvironmentalAccumulator;
import org.cyclops.evilcraftcompat.modcompat.jei.JEIEvilCraftConfig;
import org.cyclops.evilcraftcompat.modcompat.jei.environmentalaccumulator.CommonEnvironmentalAccumulatorRecipeCategory;

public class SanguinaryEnvironmentalAccumulatorRecipeCategory
extends CommonEnvironmentalAccumulatorRecipeCategory {
    public static final IRecipeHolderType<RecipeEnvironmentalAccumulator> TYPE = IRecipeHolderType.create((ResourceLocation)ResourceLocation.parse((String)"evilcraft:sanguinary_environmental_accumulator"));
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int FLUID_SLOT = 2;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;

    public SanguinaryEnvironmentalAccumulatorRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, (Pair<Integer, Integer>)Pair.of((Object)42, (Object)8), (Pair<Integer, Integer>)Pair.of((Object)96, (Object)8));
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"evilcraftcompat", (String)"textures/gui/sanguinary_environmental_accumulator_gui_jei.png");
        this.background = guiHelper.createDrawable(resourceLocation, 0, 0, 130, 70);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.get()));
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(resourceLocation, 146, 0, 24, 16);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(resourceLocation, 130, 0, 16, 58);
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public IRecipeType<RecipeHolder<RecipeEnvironmentalAccumulator>> getRecipeType() {
        return TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return Component.translatable((String)((Block)RegistryEntries.BLOCK_SANGUINARY_ENVIRONMENTAL_ACCUMULATOR.get()).getDescriptionId());
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<RecipeEnvironmentalAccumulator> recipeHolder, IFocusGroup focuses) {
        RecipeEnvironmentalAccumulator recipe = (RecipeEnvironmentalAccumulator)recipeHolder.value();
        builder.addSlot(RecipeIngredientRole.INPUT, 42, 28).add(recipe.getInputIngredient());
        FluidStack fluidStack = new FluidStack(RegistryEntries.FLUID_BLOOD, AccumulateItemTickAction.getUsage(recipe.getCooldownTime()));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 6, 6).setOverlay(this.tankOverlay, 0, 0).setFluidRenderer((long)fluidStack.getAmount(), true, 16, 58).add((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)fluidStack);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 28).add((Ingredient)recipe.getOutputItem().map(l -> Ingredient.of((ItemLike)l.getItem()), ItemStackFromIngredient::getIngredient));
    }

    @Override
    public void draw(RecipeHolder<RecipeEnvironmentalAccumulator> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        this.background.draw(guiGraphics);
        this.arrow.draw(guiGraphics, 65, 28);
        Font fontRenderer = Minecraft.getInstance().font;
        MutableComponent duration = JEIEvilCraftConfig.getDurationSecondsTextComponent(((RecipeEnvironmentalAccumulator)recipe.value()).getDuration());
        guiGraphics.drawString(fontRenderer, (Component)duration, (this.background.getWidth() - fontRenderer.width((FormattedText)duration)) / 2 + 12, 50, ARGB.opaque((int)-8355712), false);
    }
}

