/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public interface IMinecraftHelpers {
    public int getDayLength();

    public int getComparatorMultiplier();

    public int getSecondInTicks();

    public int getBlockNotify();

    public int getBlockNotifyClient();

    public int getBlockNotifyNoRerender();

    public void setDay(ServerLevel var1, boolean var2);

    public boolean isPlayerInventoryFull(Player var1);

    public String getMinecraftVersion();

    public String getMinecraftVersionMajorMinor();

    public int compareBlockPos(BlockPos var1, BlockPos var2);

    public boolean isDevEnvironment();

    public boolean isMinecraftInitialized();

    public boolean isModdedEnvironment();

    public boolean isClientSide();

    public boolean isClientSideThread();

    public boolean isModLoaded(String var1);

    public void openMenu(ServerPlayer var1, MenuProvider var2, Consumer<FriendlyByteBuf> var3);

    public MinecraftServer getCurrentServer();

    public boolean isFakePlayer(Player var1);

    public ItemStack getRecipeOutput(RecipeHolder<?> var1, Level var2);

    public ItemStack getRecipeOutput(Recipe<?> var1, Level var2);

    default public CompoundTag valueOutputToNbt(Consumer<ValueOutput> valueOutputConsumer) {
        return this.valueOutputToNbt(valueOutputConsumer, null);
    }

    public CompoundTag valueOutputToNbt(Consumer<ValueOutput> var1, @Nullable HolderLookup.Provider var2);

    @Deprecated
    default public void valueInputFromNbt(CompoundTag tag, HolderLookup.Provider lookupProvider, Consumer<ValueInput> valueInputConsumer) {
        this.valueInputFromNbt(tag, lookupProvider, (ValueInput i) -> {
            valueInputConsumer.accept((ValueInput)i);
            return null;
        });
    }

    default public void valueInputFromNbtVoid(CompoundTag tag, HolderLookup.Provider lookupProvider, Consumer<ValueInput> valueInputConsumer) {
        this.valueInputFromNbt(tag, lookupProvider, (ValueInput i) -> {
            valueInputConsumer.accept((ValueInput)i);
            return null;
        });
    }

    public <T> T valueInputFromNbt(CompoundTag var1, HolderLookup.Provider var2, Function<ValueInput, T> var3);

    public void sendRecipesToClients(Supplier<Collection<RecipeType<?>>> var1);
}

