/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCoreNeoForge;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.HyperLink;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.packet.RequestPlayerNbtPacket;

public abstract class ScreenInfoBook<T extends ContainerExtended>
extends AbstractContainerScreen<T> {
    private static final int HR_WIDTH = 88;
    private static final int HR_HEIGHT = 10;
    private static final int BANNER_WIDTH = 91;
    private static final int BANNER_HEIGHT = 12;
    private static final int ARROW_WIDTH = 22;
    private static final int ARROW_HEIGHT = 13;
    private static final int BORDER_CORNER = 4;
    private static final int BORDER_WIDTH = 2;
    private static final int BORDER_X = 0;
    private static final int BORDER_Y = 206;
    protected final IInfoBook infoBook;
    protected final ResourceLocation texture;
    protected NextPageButton buttonNextPage;
    protected NextPageButton buttonPreviousPage;
    protected NextPageButton buttonParent;
    protected NextPageButton buttonBack;
    protected NextPageButton buttonExternal;
    private InfoSection nextSection;
    private int nextPage;
    private boolean goToLastPage;
    private int left;
    private int top;

    public ScreenInfoBook(T container, Inventory playerInventory, Component title, IInfoBook infoBook) {
        super(container, playerInventory, title);
        this.infoBook = infoBook;
        this.texture = this.constructGuiTexture();
        if (infoBook.getCurrentSection() == null) {
            InfoSection root = infoBook.getMod().getRegistryManager().getRegistry(IInfoBookRegistry.class).getRoot(infoBook);
            if (root == null) {
                throw new IllegalStateException("Could not find the root of infobook " + String.valueOf(infoBook));
            }
            infoBook.setCurrentSection(root);
            infoBook.setCurrentPage(0);
        }
        CyclopsCoreNeoForge._instance.getPacketHandler().sendToServer(new RequestPlayerNbtPacket());
    }

    protected abstract ResourceLocation constructGuiTexture();

    protected int getPages() {
        return this.infoBook.getPagesPerView();
    }

    protected abstract int getGuiWidth();

    protected abstract int getGuiHeight();

    protected abstract int getPageWidth();

    protected int getPageYOffset() {
        return 16;
    }

    protected int getFootnoteOffsetX() {
        return 10;
    }

    protected int getFootnoteOffsetY() {
        return 0;
    }

    protected int getPrevNextOffsetY() {
        return 0;
    }

    protected int getPrevNextOffsetX() {
        return 0;
    }

    public int getTitleColor() {
        return IModHelpers.get().getBaseHelpers().RGBAToInt(120, 20, 30, 255);
    }

    public void init() {
        int page;
        super.init();
        this.clearWidgets();
        this.left = (this.width - this.getGuiWidth()) / 2;
        this.top = (this.height - this.getGuiHeight()) / 2;
        this.imageWidth = this.getGuiWidth();
        this.imageHeight = this.getGuiHeight();
        this.buttonNextPage = new NextPageButton(this.left + this.getPageWidth() + 100 + this.getPrevNextOffsetX(), this.top + 156 + this.getPrevNextOffsetY(), 0, 180, 18, 10, button -> {
            InfoSection.Location location = this.infoBook.getCurrentSection().getNext(this.infoBook.getCurrentPage() + this.getPages() - 1, IModHelpers.get().getMinecraftClientHelpers().isShifted());
            this.goToLastPage = false;
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
            this.applyNavigation();
        }, this);
        this.addRenderableWidget((GuiEventListener)this.buttonNextPage);
        this.buttonPreviousPage = new NextPageButton(this.left + 23 - this.getPrevNextOffsetX(), this.top + 156 + this.getPrevNextOffsetY(), 0, 193, 18, 10, button -> {
            InfoSection.Location location = this.infoBook.getCurrentSection().getPrevious(this.infoBook.getCurrentPage(), IModHelpers.get().getMinecraftClientHelpers().isShifted());
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            this.goToLastPage = this.nextSection != this.infoBook.getCurrentSection() && !IModHelpers.get().getMinecraftClientHelpers().isShifted();
            this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
            this.applyNavigation();
        }, this);
        this.addRenderableWidget((GuiEventListener)this.buttonPreviousPage);
        this.buttonParent = new NextPageButton(this.left + 2, this.top + 2, 36, 180, 8, 8, button -> {
            this.goToLastPage = false;
            if (IModHelpers.get().getMinecraftClientHelpers().isShifted()) {
                this.nextSection = this.infoBook.getCurrentSection().getParent();
                while (this.nextSection.getParent() != null) {
                    this.nextSection = this.nextSection.getParent();
                }
            } else {
                this.nextSection = this.infoBook.getCurrentSection().getParent();
            }
            this.nextPage = 0;
            this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
            this.applyNavigation();
        }, this);
        this.addRenderableWidget((GuiEventListener)this.buttonParent);
        this.buttonBack = new NextPageButton(this.left + this.getPageWidth() + 127, this.top + 2, 0, 223, 13, 18, button -> {
            InfoSection.Location location = this.infoBook.getHistory().pop();
            this.goToLastPage = false;
            this.nextSection = location.getInfoSection();
            this.nextPage = location.getPage();
            this.applyNavigation();
        }, this);
        this.addRenderableWidget((GuiEventListener)this.buttonBack);
        this.buttonExternal = new NextPageButton(this.left + 130, this.top, 26, 203, 11, 11, button -> IModHelpers.get().getBaseHelpers().openUrl(this.infoBook.getBaseUrl() + this.infoBook.getCurrentSection().getRelativeWebPath()), this);
        this.addRenderableWidget((GuiEventListener)this.buttonExternal);
        this.updateGui();
        if (this.goToLastPage) {
            page = Math.max(0, this.infoBook.getCurrentSection().getPages() - this.getPages());
            page += page % this.getPages();
            this.infoBook.setCurrentPage(page);
        }
        for (int innerPage = page = this.infoBook.getCurrentPage(); innerPage <= page + this.getPages() - 1; ++innerPage) {
            for (HyperLink link : this.infoBook.getCurrentSection().getLinks(innerPage)) {
                if (link.getTranslationKey().equals(IModHelpers.get().getL10NHelpers().localize(link.getTranslationKey(), new Object[0]))) {
                    CyclopsCoreNeoForge.clog(Level.WARN, "Could not find hyperlink localization for " + link.getTranslationKey());
                }
                int xOffset = this.getOffsetXForPageWithWidths(innerPage % this.getPages());
                this.addRenderableWidget((GuiEventListener)new TextOverlayButton(link, this.left + xOffset + link.getX(), this.top + this.getPageYOffset() / 2 + link.getY(), InfoSection.getFontHeight(this.getFont()), this.getPageWidth() - this.getOffsetXTotal() - link.getX(), button -> {
                    this.goToLastPage = false;
                    this.nextSection = ((TextOverlayButton)button).getLink().getTarget();
                    this.nextPage = 0;
                    if (this.nextSection != this.infoBook.getCurrentSection()) {
                        this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
                    }
                    this.applyNavigation();
                }, this));
            }
            for (AdvancedButton advancedButton : this.infoBook.getCurrentSection().getAdvancedButtons(innerPage)) {
                advancedButton.setOnPress(button -> {
                    this.goToLastPage = false;
                    this.nextSection = ((AdvancedButton)button).getTarget();
                    this.nextPage = 0;
                    if (this.nextSection != this.infoBook.getCurrentSection()) {
                        this.infoBook.getHistory().push(new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection()));
                    }
                    this.applyNavigation();
                });
                this.addRenderableWidget((GuiEventListener)advancedButton);
            }
        }
    }

    protected abstract int getOffsetXForPageBase(int var1);

    protected int getOffsetXForPageWithWidths(int page) {
        return this.getOffsetXForPageBase(page) + page * this.getPageWidth();
    }

    protected int getOffsetXTotal() {
        int total = 0;
        for (int i = 0; i < this.getPages(); ++i) {
            total += this.getOffsetXForPageBase(i);
        }
        return total;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.left, this.top, 0.0f, 0.0f, this.getPageWidth(), this.getGuiHeight(), 256, 256);
        this.blitMirrored(guiGraphics, RenderPipelines.GUI_TEXTURED, this.texture, this.left + this.getPageWidth() - 1, this.top, 0, 0, this.getPageWidth(), this.getGuiHeight(), 256, 256, -1);
        int width = this.getPageWidth() - this.getOffsetXTotal();
        for (i = 0; i < this.getPages(); ++i) {
            this.infoBook.getCurrentSection().constructInfoSectionClient().drawScreen(this, guiGraphics, this.left + this.getOffsetXForPageWithWidths(i), this.top, this.getPageYOffset(), width, this.getGuiHeight(), this.infoBook.getCurrentPage() + i, mouseX, mouseY, this.getFootnoteOffsetX(), this.getFootnoteOffsetY());
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (i = 0; i < this.getPages(); ++i) {
            this.infoBook.getCurrentSection().constructInfoSectionClient().postDrawScreen(this, guiGraphics, this.left + this.getOffsetXForPageWithWidths(i), this.top + this.getPageYOffset(), width, this.getGuiHeight(), this.infoBook.getCurrentPage() + i, mouseX, mouseY);
        }
        if (this.buttonNextPage.visible && IModHelpers.get().getRenderHelpers().isPointInButton(this.buttonNextPage, mouseX, mouseY)) {
            this.drawTooltip(guiGraphics, mouseX, mouseY, (Component)Component.translatable((String)"infobook.cyclopscore.next_page"));
        }
        if (this.buttonPreviousPage.visible && IModHelpers.get().getRenderHelpers().isPointInButton(this.buttonPreviousPage, mouseX, mouseY)) {
            this.drawTooltip(guiGraphics, mouseX, mouseY, (Component)Component.translatable((String)"infobook.cyclopscore.previous_page"));
        }
        if (this.buttonBack.visible && IModHelpers.get().getRenderHelpers().isPointInButton(this.buttonBack, mouseX, mouseY)) {
            this.drawTooltip(guiGraphics, mouseX, mouseY, (Component)Component.translatable((String)"infobook.cyclopscore.last_page"));
        }
        if (this.buttonParent.visible && IModHelpers.get().getRenderHelpers().isPointInButton(this.buttonParent, mouseX, mouseY)) {
            this.drawTooltip(guiGraphics, mouseX, mouseY, (Component)Component.translatable((String)"infobook.cyclopscore.parent_section"));
        }
        if (this.buttonExternal.visible && IModHelpers.get().getRenderHelpers().isPointInButton(this.buttonExternal, mouseX, mouseY)) {
            this.drawTooltip(guiGraphics, mouseX, mouseY, (Component)Component.translatable((String)"infobook.cyclopscore.external"));
        }
    }

    protected void renderBackgroundSuper(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics p_295206_, int p_295457_, int p_294596_, float p_296351_) {
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
    }

    public void drawTooltip(GuiGraphics guiGraphics, int mx, int my, Component component) {
        ClientTooltipComponent clientTooltipComponent = ClientTooltipComponent.create((FormattedCharSequence)component.getVisualOrderText());
        guiGraphics.renderTooltip(this.getFont(), List.of(clientTooltipComponent), mx, my, DefaultTooltipPositioner.INSTANCE, null);
    }

    public void blitMirrored(GuiGraphics guiGraphics, RenderPipeline renderPipeline, ResourceLocation atlasLocation, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int color) {
        guiGraphics.innerBlit(renderPipeline, atlasLocation, x, x + width, y, y + height, (float)(u + width) / (float)textureWidth, (float)u / (float)textureWidth, (float)v / (float)textureHeight, (float)(v + height) / (float)textureHeight, color);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public Font getFont() {
        return this.font;
    }

    public int getBannerWidth() {
        return 91;
    }

    private void updateGui() {
        int width = this.getPageWidth() - this.getOffsetXTotal();
        int lineHeight = InfoSection.getFontHeight(this.getFont());
        int maxLines = (this.getGuiHeight() - 2 * this.getPageYOffset() - 5) / lineHeight;
        LinkedList infoSectionsToBake = Lists.newLinkedList();
        infoSectionsToBake.add(this.infoBook.getCurrentSection());
        this.getPreviousSections(infoSectionsToBake);
        this.getNextSections(infoSectionsToBake);
        for (InfoSection infoSection : infoSectionsToBake) {
            if (infoSection == null) continue;
            infoSection.bakeSection(this.getFont(), width, maxLines, lineHeight, this.getPageYOffset());
        }
        this.updateButtons();
    }

    protected void getPreviousSections(List<InfoSection> sections) {
        InfoSection.Location location = this.infoBook.getCurrentSection().getPrevious(this.infoBook.getCurrentPage(), false);
        if (location != null) {
            sections.add(location.getInfoSection());
        }
    }

    protected void getNextSections(List<InfoSection> sections) {
        InfoSection.Location location = this.infoBook.getCurrentSection().getNext(this.infoBook.getCurrentPage() + this.getPages() - 1, false);
        if (location != null) {
            sections.add(location.getInfoSection());
        }
    }

    private void updateButtons() {
        InfoSection.Location current1 = new InfoSection.Location(this.infoBook.getCurrentPage(), this.infoBook.getCurrentSection());
        InfoSection.Location current2 = new InfoSection.Location(this.infoBook.getCurrentPage() + this.getPages() - 1, this.infoBook.getCurrentSection());
        InfoSection.Location wouldBeNext = this.infoBook.getCurrentSection().getNext(this.infoBook.getCurrentPage() + this.getPages() - 1, false);
        this.buttonNextPage.visible = !current1.equals(wouldBeNext) && !current2.equals(wouldBeNext);
        this.buttonPreviousPage.visible = !current1.equals(this.infoBook.getCurrentSection().getPrevious(this.infoBook.getCurrentPage(), false));
        this.buttonParent.visible = this.infoBook.getCurrentSection() != null && this.infoBook.getCurrentSection().getParent() != null;
        this.buttonBack.visible = this.infoBook.getHistory().currentSize() > 0;
    }

    protected void applyNavigation() {
        if (this.nextSection != null && (this.nextSection != this.infoBook.getCurrentSection() || this.infoBook.getCurrentPage() != this.nextPage)) {
            this.infoBook.setCurrentSection(this.nextSection);
            this.nextSection = null;
            this.infoBook.setCurrentPage(this.nextPage);
            this.init();
        }
    }

    public void drawScaledCenteredString(GuiGraphics guiGraphics, String string, int x, int y, int width, float originalScale, int maxWidth, int color) {
        this.drawScaledCenteredString(guiGraphics, string, x, y, width, originalScale, maxWidth, color, false);
    }

    public void drawScaledCenteredString(GuiGraphics guiGraphics, String string, int x, int y, int width, float originalScale, int maxWidth, int color, boolean shadow) {
        float originalWidth = (float)this.getFont().width(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        this.drawScaledCenteredString(guiGraphics, string, x, y, width, scale, color, shadow);
    }

    public void drawScaledCenteredString(GuiGraphics guiGraphics, String string, int x, int y, int width, float scale, int color) {
        this.drawScaledCenteredString(guiGraphics, string, x, y, width, scale, color, false);
    }

    public void drawScaledCenteredString(GuiGraphics guiGraphics, String string, int x, int y, int width, float scale, int color, boolean shadow) {
        IModHelpers.get().getRenderHelpers().drawScaledCenteredString(guiGraphics, this.getFont(), string, x, y, width, scale, color, shadow, Font.DisplayMode.NORMAL);
    }

    public void drawHorizontalRule(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, x - 44, y - 5, 52.0f, 180.0f, 88, 10, 256, 256);
    }

    public void drawTextBanner(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, x - 45, y - 6, 52.0f, 191.0f, 91, 12, 256, 256);
    }

    public void drawArrowRight(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.texture, x, y, 0.0f, 210.0f, 22, 13, 256, 256);
    }

    public void drawOuterBorder(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        this.drawOuterBorder(guiGraphics, x, y, width, height, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void drawOuterBorder(GuiGraphics guiGraphics, int x, int y, int width, int height, float r, float g, float b, float alpha) {
        int i;
        boolean z = false;
        IModHelpers.get().getRenderHelpers().blitColored(guiGraphics, this.texture, x - 2, y - 2, 0.0f, 206.0f, 4, 4, r, g, b, alpha);
        IModHelpers.get().getRenderHelpers().blitColored(guiGraphics, this.texture, x + width - 2, y - 2, 4.0f, 206.0f, 4, 4, r, g, b, alpha);
        IModHelpers.get().getRenderHelpers().blitColored(guiGraphics, this.texture, x - 2, y + height - 2, 12.0f, 206.0f, 4, 4, r, g, b, alpha);
        IModHelpers.get().getRenderHelpers().blitColored(guiGraphics, this.texture, x + width - 2, y + height - 2, 8.0f, 206.0f, 4, 4, r, g, b, alpha);
        for (i = 2; i < width - 2; i += 2) {
            int drawWidth = 2;
            if (i + 2 >= width - 4) {
                drawWidth -= i - (width - 4);
            }
            IModHelpers.get().getRenderHelpers().blitColored(guiGraphics, this.texture, x + i, y - 2, 16.0f, 206.0f, drawWidth, 2, r, g, b, alpha);
            IModHelpers.get().getRenderHelpers().blitColored(guiGraphics, this.texture, x + i, y + height, 16.0f, 206.0f, drawWidth, 2, r, g, b, alpha);
        }
        for (i = 2; i < height - 2; i += 2) {
            int drawHeight = 2;
            if (i + 2 >= height - 4) {
                drawHeight -= i - (height - 4);
            }
            if (drawHeight <= 0) continue;
            IModHelpers.get().getRenderHelpers().blitColored(guiGraphics, this.texture, x - 2, y + i, 16.0f, 206.0f, 2, drawHeight, r, g, b, alpha);
            IModHelpers.get().getRenderHelpers().blitColored(guiGraphics, this.texture, x + width, y + i, 16.0f, 206.0f, 2, drawHeight, r, g, b, alpha);
        }
    }

    public void renderTooltip(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        guiGraphics.setTooltipForNextFrame(this.getFont(), itemStack, x, y);
    }

    public int getTick() {
        return (int)this.getMinecraft().level.getGameTime();
    }

    public void containerTick() {
        super.containerTick();
        if (!this.minecraft.player.isAlive()) {
            this.minecraft.player.closeContainer();
        }
    }

    public abstract void playPageFlipSound(SoundManager var1);

    public abstract void playPagesFlipSound(SoundManager var1);

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double scrollDelta) {
        if (scrollDelta < 0.0) {
            this.buttonNextPage.onClick(mouseX, mouseY);
            return true;
        }
        if (scrollDelta > 0.0) {
            this.buttonPreviousPage.onClick(mouseX, mouseY);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, mouseZ, scrollDelta);
    }

    static class NextPageButton
    extends Button {
        private final ScreenInfoBook guiInfoBook;
        private int textureX;
        private int textureY;

        public NextPageButton(int x, int y, int textureX, int textureY, int width, int height, Button.OnPress onPress, ScreenInfoBook guiInfoBook) {
            super(x, y, width, height, (Component)Component.literal((String)""), onPress, Button.DEFAULT_NARRATION);
            this.textureX = textureX;
            this.textureY = textureY;
            this.guiInfoBook = guiInfoBook;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                boolean isHover = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
                int k = this.textureX;
                int l = this.textureY;
                if (isHover) {
                    k += this.width;
                }
                guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.guiInfoBook.texture, this.getX(), this.getY(), (float)k, (float)l, this.width, this.height, 256, 256);
            }
        }

        public void playDownSound(SoundManager soundHandler) {
            this.guiInfoBook.playPageFlipSound(soundHandler);
        }
    }

    static class TextOverlayButton
    extends Button {
        private final ScreenInfoBook guiInfoBook;
        private HyperLink link;

        public TextOverlayButton(HyperLink link, int x, int y, int height, int maxWidth, Button.OnPress onPress, ScreenInfoBook guiInfoBook) {
            super(x, y, 0, height, (Component)Component.literal((String)InfoSection.formatString(IModHelpers.get().getL10NHelpers().localize(link.getTranslationKey(), new Object[0]))), onPress, Button.DEFAULT_NARRATION);
            this.guiInfoBook = guiInfoBook;
            this.link = link;
            Font fontRenderer = Minecraft.getInstance().font;
            this.width = fontRenderer.width(this.getMessage().getVisualOrderText());
            if (this.width > maxWidth) {
                Object originalMessage = this.getMessage().getString();
                originalMessage = ((String)originalMessage).substring(0, (int)((float)maxWidth / (float)this.width * (float)((String)originalMessage).length()) - 1);
                originalMessage = (String)originalMessage + "\u2026";
                this.setMessage((Component)Component.literal((String)originalMessage));
                this.width = maxWidth;
            }
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                boolean isHover = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
                Minecraft minecraft = Minecraft.getInstance();
                MutableComponent msg = (MutableComponent)this.getMessage();
                if (isHover) {
                    msg = msg.withStyle(ChatFormatting.UNDERLINE);
                }
                guiGraphics.drawString(minecraft.font, (Component)msg, this.getX(), this.getY(), IModHelpers.get().getBaseHelpers().RGBAToInt(isHover ? 100 : 0, isHover ? 100 : 0, isHover ? 150 : 125, 255), false);
            }
        }

        public void playDownSound(SoundManager soundHandler) {
            this.guiInfoBook.playPagesFlipSound(soundHandler);
        }

        public HyperLink getLink() {
            return this.link;
        }
    }
}

