/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.container;

import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;

public abstract class InventoryContainer
extends ContainerExtended {
    protected final Container inventory;

    public InventoryContainer(@Nullable MenuType<?> type, int id, Inventory playerInventory, Container inventory) {
        super(type, id, playerInventory);
        this.inventory = inventory;
        if (this.isAssertInventorySize()) {
            InventoryContainer.checkContainerSize((Container)inventory, (int)this.getSizeInventory());
        }
        this.inventory.startOpen(playerInventory.player);
    }

    protected boolean isAssertInventorySize() {
        return true;
    }

    public Container getContainerInventory() {
        return this.inventory;
    }

    @Override
    protected int getSizeInventory() {
        return this.inventory.getContainerSize();
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }
}

