/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import com.google.common.collect.Lists;
import io.netty.channel.ChannelHandler;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.client.network.event.RegisterClientPayloadHandlersEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.network.IPacketHandler;
import org.cyclops.cyclopscore.network.PacketBase;

@ChannelHandler.Sharable
public final class PacketHandlerNeoForge
implements IPacketHandler {
    private final ModBaseNeoForge mod;
    private final List<Pair<CustomPacketPayload.Type<?>, StreamCodec<? super RegistryFriendlyByteBuf, ? extends PacketBase>>> pendingPacketRegistrations;

    public PacketHandlerNeoForge(ModBaseNeoForge mod) {
        this.mod = mod;
        this.pendingPacketRegistrations = Lists.newArrayList();
        mod.getModEventBus().addListener(this::init);
        mod.getModEventBus().addListener(this::initClient);
    }

    protected void init(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(this.mod.getModId()).versioned("1.0.0").executesOn(HandlerThread.NETWORK).optional();
        for (Pair<CustomPacketPayload.Type<?>, StreamCodec<? super RegistryFriendlyByteBuf, ? extends PacketBase>> pair : this.pendingPacketRegistrations) {
            this.registerActual(registrar, (CustomPacketPayload.Type)pair.getLeft(), (StreamCodec)pair.getRight());
        }
    }

    protected void initClient(RegisterClientPayloadHandlersEvent event) {
        for (Pair<CustomPacketPayload.Type<?>, StreamCodec<? super RegistryFriendlyByteBuf, ? extends PacketBase>> pair : this.pendingPacketRegistrations) {
            this.registerActualClient(event, (CustomPacketPayload.Type)pair.getLeft(), (StreamCodec)pair.getRight());
        }
    }

    @Override
    public <P extends PacketBase> void register(Class<P> clazz, CustomPacketPayload.Type<P> type, StreamCodec<? super RegistryFriendlyByteBuf, P> codec) {
        this.pendingPacketRegistrations.add(Pair.of(type, codec));
    }

    protected <P extends PacketBase> void registerActual(PayloadRegistrar registrar, CustomPacketPayload.Type<P> type, StreamCodec<? super RegistryFriendlyByteBuf, P> codec) {
        registrar.playBidirectional(type, codec, (packet, ctx) -> {
            if (packet.isAsync()) {
                this.handlePacketServer(ctx, (PacketBase)packet);
            } else {
                ctx.enqueueWork(() -> this.handlePacketServer(ctx, (PacketBase)packet));
            }
        });
    }

    protected <P extends PacketBase> void registerActualClient(RegisterClientPayloadHandlersEvent event, CustomPacketPayload.Type<P> type, StreamCodec<? super RegistryFriendlyByteBuf, P> codec) {
        event.register(type, (packet, ctx) -> {
            if (packet.isAsync()) {
                this.handlePacketClient(ctx, (PacketBase)packet);
            } else {
                ctx.enqueueWork(() -> this.handlePacketClient(ctx, (PacketBase)packet));
            }
        });
    }

    public void handlePacketClient(IPayloadContext context, PacketBase packet) {
        packet.actionClient(context.player().level(), context.player());
    }

    public void handlePacketServer(IPayloadContext context, PacketBase packet) {
        packet.actionServer(context.player().level(), (ServerPlayer)context.player());
    }

    @Override
    public void sendToServer(PacketBase packet) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToPlayer(PacketBase packet, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToAllAroundPoint(PacketBase packet, IPacketHandler.TargetPoint point) {
        PacketDistributor.sendToPlayersNear((ServerLevel)point.level(), (ServerPlayer)point.excluded(), (double)point.x(), (double)point.y(), (double)point.z(), (double)point.radius(), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToDimension(PacketBase packet, ServerLevel dimension) {
        PacketDistributor.sendToPlayersInDimension((ServerLevel)dimension, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToAll(PacketBase packet) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

