/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.CyclopsCoreNeoForge;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.cyclopscore.network.packet.SendRecipeDisplayPacket;
import org.cyclops.cyclopscore.network.packet.SendRecipeDisplaysRegexDonePacket;

public class RequestRecipeDisplaysRegexPacket
extends PacketCodec<RequestRecipeDisplaysRegexPacket> {
    public static final CustomPacketPayload.Type<RequestRecipeDisplaysRegexPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cyclopscore", (String)"request_recipe_displays_regex_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestRecipeDisplaysRegexPacket> CODEC = RequestRecipeDisplaysRegexPacket.getCodec(RequestRecipeDisplaysRegexPacket::new);
    @CodecField
    private String recipeType;
    @CodecField
    private String recipeRegex;

    public RequestRecipeDisplaysRegexPacket() {
        super(TYPE);
    }

    public RequestRecipeDisplaysRegexPacket(RecipeType<?> recipeType, String recipeRegex) {
        this();
        this.recipeType = recipeType.toString();
        this.recipeRegex = recipeRegex;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public void actionClient(Level level, Player player) {
    }

    @Override
    public void actionServer(Level level, ServerPlayer player) {
        List<Pair<ResourceLocation, RecipeDisplayEntry>> recipeDisplays = IModHelpers.get().getCraftingHelpers().getRecipeDisplays((RecipeType)BuiltInRegistries.RECIPE_TYPE.getValue(ResourceLocation.parse((String)this.recipeType)), this.recipeRegex);
        for (Pair<ResourceLocation, RecipeDisplayEntry> entry : recipeDisplays) {
            CyclopsCoreNeoForge._instance.getPacketHandler().sendToPlayer(new SendRecipeDisplayPacket(this.recipeType, ((ResourceLocation)entry.getLeft()).toString(), (RecipeDisplayEntry)entry.getRight()), player);
        }
        CyclopsCoreNeoForge._instance.getPacketHandler().sendToPlayer(new SendRecipeDisplaysRegexDonePacket(this.recipeType, this.recipeRegex), player);
    }
}

