/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.cyclops.evilcraft.blockentity.BlockEntityColossalBloodChest;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityChestBase;

public class RenderBlockEntityColossalBloodChest
extends RenderBlockEntityChestBase<BlockEntityColossalBloodChest> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"model/colossal_blood_chest");

    public RenderBlockEntityColossalBloodChest(BlockEntityRendererProvider.Context p_i226008_1_) {
        super(p_i226008_1_);
    }

    public AABB getRenderBoundingBox(BlockEntityColossalBloodChest blockEntity) {
        return new AABB(Vec3.atLowerCornerOf((Vec3i)blockEntity.getBlockPos().subtract(new Vec3i(3, 3, 3))), Vec3.atLowerCornerOf((Vec3i)blockEntity.getBlockPos().offset(3, 6, 3)));
    }

    @Override
    protected Material getMaterial(BlockEntityColossalBloodChest tile) {
        return new Material(Sheets.CHEST_SHEET, TEXTURE);
    }

    public boolean shouldRenderOffScreen(BlockEntityColossalBloodChest tile) {
        return true;
    }

    @Override
    protected void handleRotation(BlockEntityColossalBloodChest tile, PoseStack matrixStack) {
        if (tile.isStructureComplete()) {
            Vec3i renderOffset = tile.getRenderOffset();
            matrixStack.translate((float)(-renderOffset.getX()), (float)(-renderOffset.getY()), (float)(-renderOffset.getZ()));
        }
        super.handleRotation(tile, matrixStack);
        matrixStack.translate(0.0f, (float)tile.getSizeSingular() * 0.0625f, 0.0f);
        float size = (float)tile.getSizeSingular() * 1.125f;
        matrixStack.scale(size, size, size);
    }

    @Override
    public void render(BlockEntityColossalBloodChest tile, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        if (tile.isStructureComplete()) {
            super.render(tile, partialTicks, matrixStack, renderTypeBuffer, combinedLightIn, combinedOverlayIn);
        }
    }

    @Override
    protected Direction getDirection(BlockEntityColossalBloodChest tileEntityIn) {
        return tileEntityIn.getRotation().getOpposite();
    }
}

