/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.client.gui.container;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.inventory.container.ContainerInventoryTickingTank;

public abstract class ContainerScreenContainerTankInventory<C extends ContainerInventoryTickingTank<T>, T extends BlockEntityTickingTankInventory<T>>
extends ContainerScreenExtended<C> {
    private boolean showTank = false;
    private int tankWidth;
    private int tankHeight;
    private int tankX;
    private int tankY;
    private int tankTargetX;
    private int tankTargetY;
    private boolean showProgress = false;
    private int progressWidth;
    private int progressHeight;
    private int progressX;
    private int progressY;
    private int progressTargetX;
    private int progressTargetY;

    public ContainerScreenContainerTankInventory(C container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
    }

    protected void setTank(int tankWidth, int tankHeight, int tankX, int tankY, int tankTargetX, int tankTargetY) {
        this.showTank = true;
        this.tankWidth = tankWidth;
        this.tankHeight = tankHeight;
        this.tankX = tankX;
        this.tankY = tankY;
        this.tankTargetX = tankTargetX + this.offsetX;
        this.tankTargetY = tankTargetY + this.offsetY;
    }

    protected void setProgress(int progressWidth, int progressHeight, int progressX, int progressY, int progressTargetX, int progressTargetY) {
        this.showProgress = true;
        this.progressWidth = progressWidth;
        this.progressHeight = progressHeight;
        this.progressX = progressX;
        this.progressY = progressY;
        this.progressTargetX = progressTargetX + this.offsetX;
        this.progressTargetY = progressTargetY + this.offsetY;
    }

    protected boolean isShowProgress() {
        return this.showProgress;
    }

    protected int getProgressXScaled(int width) {
        return width;
    }

    protected int getProgressYScaled(int height) {
        return height;
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int x, int y) {
        super.renderBg(guiGraphics, f, x, y);
        if (this.isShowProgress()) {
            guiGraphics.blit(this.getGuiTexture(), this.leftPos + this.progressTargetX, this.topPos + this.progressTargetY, this.progressX, this.progressY, this.getProgressXScaled(this.progressWidth), this.getProgressYScaled(this.progressHeight));
        }
    }

    protected abstract Component getName();

    protected void drawForgegroundString(GuiGraphics guiGraphics) {
        this.font.drawInBatch(this.getName(), (float)(8 + this.offsetX), (float)(4 + this.offsetY), 0x404040, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawForgegroundString(guiGraphics);
        RenderHelpers.bindTexture((ResourceLocation)this.texture);
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FluidStack fluidStack = ((ContainerInventoryTickingTank)this.getMenu()).getFluidStack();
        if (this.shouldRenderTank(fluidStack) && ((ContainerInventoryTickingTank)this.getMenu()).getFluidCapacity() > 0) {
            int tankSize = Math.min(((ContainerInventoryTickingTank)this.getMenu()).getFluidCapacity(), Math.min(((ContainerInventoryTickingTank)this.getMenu()).getFluidCapacity(), fluidStack.getAmount()) * this.tankHeight / ((ContainerInventoryTickingTank)this.getMenu()).getFluidCapacity());
            this.drawTank(guiGraphics, this.tankTargetX, this.tankTargetY, fluidStack.getFluid(), tankSize);
        }
        this.drawAdditionalForeground(guiGraphics, mouseX, mouseY);
        GlStateManager._disableBlend();
    }

    protected void drawAdditionalForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void drawCurrentScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float gameTicks) {
        super.drawCurrentScreen(guiGraphics, mouseX, mouseY, gameTicks);
        this.drawTooltips(guiGraphics, mouseX, mouseY);
    }

    protected boolean shouldRenderTank(FluidStack fluidStack) {
        if (!this.showTank) {
            return false;
        }
        return fluidStack.getAmount() > 0;
    }

    protected void drawTank(GuiGraphics guiGraphics, int xOffset, int yOffset, Fluid fluid, int level) {
        if (fluid != null) {
            FluidStack stack = new FluidStack(fluid, 1);
            TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)stack, (Direction)Direction.UP);
            int verticalOffset = 0;
            while (level > 0) {
                int textureHeight = 0;
                if (level > 16) {
                    textureHeight = 16;
                    level -= 16;
                } else {
                    textureHeight = level;
                    level = 0;
                }
                guiGraphics.blit(xOffset, yOffset - textureHeight - verticalOffset, 0, this.tankWidth, textureHeight, icon);
                verticalOffset += 16;
            }
            guiGraphics.blit(this.texture, xOffset, yOffset - this.tankHeight, this.tankX, this.tankY, this.tankWidth, this.tankHeight);
        }
    }

    protected void drawTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        FluidStack fluidStack = ((ContainerInventoryTickingTank)this.getMenu()).getFluidStack();
        if (this.isHovering(this.tankTargetX, this.tankTargetY - this.tankHeight, this.tankWidth, this.tankHeight, mouseX, mouseY) && this.shouldRenderTank(fluidStack)) {
            Component fluidName = fluidStack.getHoverName();
            this.drawBarTooltipTank(guiGraphics, fluidName, fluidStack, fluidStack.getAmount(), ((ContainerInventoryTickingTank)this.getMenu()).getFluidCapacity(), mouseX, mouseY);
        }
    }

    protected void drawBarTooltipTank(GuiGraphics guiGraphics, Component name, FluidStack fluidStack, int amount, int capacity, int x, int y) {
        ArrayList lines = Lists.newArrayList();
        lines.add(name);
        lines.add(DamageIndicatedItemComponent.getInfo((FluidStack)fluidStack, (int)amount, (int)capacity));
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        this.drawTooltip(lines, guiGraphics.pose(), x - this.leftPos, y - this.topPos);
        guiGraphics.pose().popPose();
    }
}

