/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;

public class WorldSharedTank
extends SingleUseTank {
    public static final String NBT_TANKID = "tankID";
    protected String tankID = "";
    private int previousAmount = 0;

    public WorldSharedTank(int capacity) {
        super(capacity);
    }

    public void resetPreviousFluid() {
        this.previousAmount = this.getFluidAmount();
    }

    public int getPreviousAmount() {
        return this.previousAmount;
    }

    public void writeTankToNBT(CompoundTag nbt) {
        super.writeTankToNBT(nbt);
        nbt.putString(NBT_TANKID, this.tankID);
    }

    public void readTankFromNBT(CompoundTag nbt) {
        super.readTankFromNBT(nbt);
        this.tankID = nbt.getString(NBT_TANKID);
    }

    protected void readWorldFluid() {
        this.fluid = WorldSharedTankCache.getInstance().getTankContent(this.tankID);
    }

    protected void writeWorldFluid() {
        if (!MinecraftHelpers.isClientSideThread()) {
            WorldSharedTankCache.getInstance().setTankContent(this.tankID, this.fluid);
        }
    }

    public void setFluid(FluidStack fluid) {
        super.setFluid(fluid);
        this.writeWorldFluid();
    }

    public FluidStack getFluid() {
        this.readWorldFluid();
        return super.getFluid();
    }

    public int getFluidAmount() {
        this.readWorldFluid();
        return super.getFluidAmount();
    }

    public int getSpace() {
        this.readWorldFluid();
        return super.getSpace();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        this.readWorldFluid();
        int ret = super.fill(resource, action);
        if (ret > 0 && action.execute()) {
            this.writeWorldFluid();
        }
        return ret;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        this.readWorldFluid();
        FluidStack ret = super.drain(maxDrain, action);
        if (!ret.isEmpty() && action.execute()) {
            this.writeWorldFluid();
        }
        return ret;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        this.readWorldFluid();
        FluidStack ret = super.drain(resource, action);
        if (!ret.isEmpty() && action.execute()) {
            this.writeWorldFluid();
        }
        return ret;
    }

    public String getTankID() {
        return this.tankID;
    }

    public void setTankID(String tankID) {
        this.tankID = tankID;
    }

    public Fluid getAcceptedFluid() {
        Fluid fluid = this.getFluidType();
        return fluid == null ? Fluids.EMPTY : fluid;
    }

    protected boolean replaceInnerFluid() {
        return false;
    }

    public static class TankData
    extends WorldStorage {
        public static final String KEY = "WorldSharedTanks";

        public TankData(ModBase mod) {
            super(mod);
        }

        public void reset() {
            WorldSharedTankCache.getInstance().reset();
        }

        protected String getDataId() {
            return KEY;
        }

        public void readFromNBT(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
            super.readFromNBT(tag, holderLookupProvider);
            WorldSharedTankCache.getInstance().readFromNBT(tag, holderLookupProvider);
        }

        public void writeToNBT(CompoundTag tag, HolderLookup.Provider holderLookupProvider) {
            super.writeToNBT(tag, holderLookupProvider);
            WorldSharedTankCache.getInstance().writeToNBT(tag, holderLookupProvider);
        }
    }
}

