/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.cyclops.evilcraft.RegistryEntries;

public class EntityWerewolf
extends Monster {
    private CompoundTag villagerNBTTagCompound = new CompoundTag();
    private boolean fromVillager = false;
    private static final int BARKCHANCE = 1000;
    private static final int BARKLENGTH = 40;
    private static int barkprogress;

    public EntityWerewolf(EntityType<? extends EntityWerewolf> type, Level world) {
        super(type, world);
    }

    public EntityWerewolf(Level world) {
        super((EntityType)RegistryEntries.ENTITY_WEREWOLF.get(), world);
        this.villagerNBTTagCompound.putString("ProfessionName", BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)((VillagerProfession)RegistryEntries.VILLAGER_PROFESSION_WEREWOLF.get())).toString());
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void transformWerewolfVillager(EntityTickEvent.Post event) {
        if (event.getEntity() instanceof Villager && !event.getEntity().level().isClientSide()) {
            Villager villager = (Villager)event.getEntity();
            if (EntityWerewolf.isWerewolfTime(event.getEntity().level()) && villager.getVillagerData().getProfession() == RegistryEntries.VILLAGER_PROFESSION_WEREWOLF.get() && villager.level().getBrightness(LightLayer.SKY, villager.blockPosition()) > 0) {
                EntityWerewolf.replaceVillager(villager);
            }
        }
    }

    public float getVoicePitch() {
        return super.getVoicePitch() * 0.75f;
    }

    public void addAdditionalSaveData(CompoundTag NBTTagCompound) {
        super.addAdditionalSaveData(NBTTagCompound);
        NBTTagCompound.put("villager", (Tag)this.villagerNBTTagCompound);
        NBTTagCompound.putBoolean("fromVillager", this.fromVillager);
    }

    public void readAdditionalSaveData(CompoundTag NBTTagCompound) {
        super.readAdditionalSaveData(NBTTagCompound);
        this.villagerNBTTagCompound = NBTTagCompound.getCompound("villager");
        this.fromVillager = NBTTagCompound.getBoolean("fromVillager");
    }

    public static boolean isWerewolfTime(Level world) {
        return (double)world.getMoonBrightness() == 1.0 && !world.isDay() && world.getDifficulty() != Difficulty.PEACEFUL;
    }

    private static void replaceEntity(Mob old, Mob neww, Level world) {
        neww.copyPosition((Entity)old);
        old.remove(Entity.RemovalReason.DISCARDED);
        world.addFreshEntity((Entity)neww);
        world.levelEvent(null, 1016, old.blockPosition(), 0);
    }

    public void replaceWithVillager() {
        Villager villager = new Villager(EntityType.VILLAGER, this.level(), VillagerType.byBiome((Holder)this.level().getBiome(this.blockPosition())));
        EntityWerewolf.initializeWerewolfVillagerData(villager);
        EntityWerewolf.replaceEntity((Mob)this, (Mob)villager, this.level());
        try {
            villager.readAdditionalSaveData(this.villagerNBTTagCompound);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public static void initializeWerewolfVillagerData(Villager villager) {
        villager.setVillagerData(villager.getVillagerData().setLevel(2).setProfession((VillagerProfession)RegistryEntries.VILLAGER_PROFESSION_WEREWOLF.get()));
    }

    public static void replaceVillager(Villager villager) {
        EntityWerewolf werewolf = new EntityWerewolf(villager.level());
        villager.addAdditionalSaveData(werewolf.getVillagerNBTTagCompound());
        werewolf.setFromVillager(true);
        EntityWerewolf.replaceEntity((Mob)villager, (Mob)werewolf, villager.level());
    }

    public void aiStep() {
        if (!(this.level().isClientSide() || EntityWerewolf.isWerewolfTime(this.level()) && this.level().getDifficulty() != Difficulty.PEACEFUL)) {
            this.replaceWithVillager();
        } else {
            super.aiStep();
        }
        RandomSource random = this.level().random;
        if (random.nextInt(1000) == 0 && barkprogress == -1) {
            ++barkprogress;
        } else if (barkprogress > -1) {
            this.playSound(SoundEvents.WOLF_GROWL, 0.15f, 1.0f);
            if (++barkprogress > 40) {
                barkprogress = -1;
            }
        }
    }

    public float getBarkProgressScaled(float scale) {
        if (barkprogress == -1) {
            return 0.0f;
        }
        return (float)barkprogress / 40.0f * scale;
    }

    public ResourceKey<LootTable> getDefaultLootTable() {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"evilcraft", (String)"entities/werewolf"));
    }

    public SoundEvent getAmbientSound() {
        return SoundEvents.WOLF_GROWL;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.WOLF_HURT;
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.WOLF_DEATH;
    }

    protected void playStepSound(BlockPos blockPos, BlockState block) {
        this.playSound(SoundEvents.ZOMBIE_STEP, 0.15f, 1.0f);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return super.removeWhenFarAway(distanceToClosestPlayer) && !this.isFromVillager();
    }

    public CompoundTag getVillagerNBTTagCompound() {
        return this.villagerNBTTagCompound;
    }

    public boolean isFromVillager() {
        return this.fromVillager;
    }

    public void setFromVillager(boolean fromVillager) {
        this.fromVillager = fromVillager;
    }

    static {
        NeoForge.EVENT_BUS.register(EntityWerewolf.class);
        barkprogress = -1;
    }
}

