/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemDarkenedApple
extends Item {
    private static final int POTION_DURATION = 30;
    private static final int POTION_AMPLIFIER = 4;

    public ItemDarkenedApple(Item.Properties properties) {
        super(properties.food(new FoodProperties.Builder().nutrition(0).saturationModifier(0.0f).alwaysEdible().effect(() -> new MobEffectInstance(RegistryEntries.POTION_PALING, 600, 4), 1.0f).build()));
        NeoForge.EVENT_BUS.addListener(this::onInteract);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity entity) {
        return 64;
    }

    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (event.getItemStack().getItem() == this && entity instanceof Animal) {
            Animal animal = (Animal)entity;
            animal.addEffect(new MobEffectInstance(RegistryEntries.POTION_PALING, 600, 4));
            event.getItemStack().shrink(1);
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.CONSUME);
        }
    }
}

