/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.loot.functions;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.cyclops.evilcraft.block.BlockDisplayStand;
import org.cyclops.evilcraft.blockentity.BlockEntityDisplayStand;

public class LootFunctionCopyDisplayStandData
extends LootItemConditionalFunction {
    public static final MapCodec<LootFunctionCopyDisplayStandData> CODEC = RecordCodecBuilder.mapCodec(builder -> LootFunctionCopyDisplayStandData.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, LootFunctionCopyDisplayStandData::new));
    public static final LootItemFunctionType TYPE = new LootItemFunctionType(CODEC);

    protected LootFunctionCopyDisplayStandData(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public ItemStack run(ItemStack itemStack, LootContext lootContext) {
        BlockEntity tile = (BlockEntity)lootContext.getParamOrNull(LootContextParams.BLOCK_ENTITY);
        if (tile instanceof BlockEntityDisplayStand) {
            ItemStack type = ((BlockEntityDisplayStand)tile).getDisplayStandType();
            BlockDisplayStand.setDisplayStandType(itemStack, type);
        }
        return itemStack;
    }

    public LootItemFunctionType getType() {
        return TYPE;
    }
}

