/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.evilcraft.RegistryEntries;

public class ParticleBubbleExtendedData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<ParticleBubbleExtendedData> DESERIALIZER = new ParticleOptions.Deserializer<ParticleBubbleExtendedData>(){

        public ParticleBubbleExtendedData fromCommand(ParticleType<ParticleBubbleExtendedData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float gravity = (float)reader.readDouble();
            return new ParticleBubbleExtendedData(gravity);
        }

        public ParticleBubbleExtendedData fromNetwork(ParticleType<ParticleBubbleExtendedData> particleTypeIn, FriendlyByteBuf buffer) {
            return new ParticleBubbleExtendedData(buffer.readFloat());
        }
    };
    public static final Codec<ParticleBubbleExtendedData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("gravity").forGetter(ParticleBubbleExtendedData::getGravity)).apply((Applicative)builder, ParticleBubbleExtendedData::new));
    private final float gravity;

    public ParticleBubbleExtendedData(float gravity) {
        this.gravity = gravity;
    }

    public float getGravity() {
        return this.gravity;
    }

    public ParticleType<?> m_6012_() {
        return RegistryEntries.PARTICLE_BUBBLE_EXTENDED;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.gravity);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.gravity));
    }
}

