/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.evilcraft.RegistryEntries;

public class RecipeFluidContainerCombination
extends CustomRecipe {
    private final Ingredient fluidContainer;
    private final int maxCapacity;

    public RecipeFluidContainerCombination(ResourceLocation id, CraftingBookCategory category, Ingredient fluidContainer, int maxCapacity) {
        super(id, category);
        this.fluidContainer = fluidContainer;
        this.maxCapacity = maxCapacity;
    }

    public Ingredient getFluidContainer() {
        return this.fluidContainer;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public boolean matches(CraftingContainer grid, Level world) {
        return !this.assemble(grid, world.m_9598_()).m_41619_();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.fluidContainer.m_43908_()[0];
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventory) {
        NonNullList aitemstack = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            aitemstack.set(i, (Object)ForgeHooks.getCraftingRemainingItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public RecipeSerializer<?> m_7707_() {
        return RegistryEntries.RECIPESERIALIZER_FLUIDCONTAINER_COMBINATION;
    }

    public ItemStack assemble(CraftingContainer grid, RegistryAccess registryAccess) {
        ItemStack output = this.m_8043_(registryAccess).m_41777_();
        IFluidHandlerItemCapacity fluidHandlerOutput = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)output).orElse(null);
        FluidStack commonFluid = null;
        int totalCapacity = 0;
        int totalContent = 0;
        int inputItems = 0;
        for (int j = 0; j < grid.m_6643_(); ++j) {
            ItemStack element = grid.m_8020_(j).m_41777_().m_41620_(1);
            if (element.m_41619_()) continue;
            if (this.fluidContainer.test(element)) {
                IFluidHandlerItemCapacity fluidHandler = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity((ItemStack)element).orElse(null);
                ++inputItems;
                FluidStack fluidStack = FluidHelpers.getFluid((IFluidHandler)fluidHandler);
                if (!fluidStack.isEmpty()) {
                    if (commonFluid == null) {
                        commonFluid = fluidStack;
                    } else if (!commonFluid.equals((Object)fluidStack)) {
                        return ItemStack.f_41583_;
                    }
                    totalContent = Helpers.addSafe((int)totalContent, (int)(fluidStack.getAmount() * element.m_41613_()));
                }
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)(fluidHandler.getCapacity() * element.m_41613_()));
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (inputItems < 2 || totalCapacity > this.maxCapacity) {
            return ItemStack.f_41583_;
        }
        fluidHandlerOutput.setCapacity(totalCapacity);
        if (commonFluid != null) {
            fluidHandlerOutput.fill(new FluidStack(commonFluid, totalContent), IFluidHandler.FluidAction.EXECUTE);
        }
        output = fluidHandlerOutput.getContainer();
        return output;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 1;
    }
}

