/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.evilcraft.entity.item.EntityBiomeExtract;
import org.cyclops.evilcraft.item.ItemBiomeExtractConfig;

public class ItemBiomeExtract
extends Item {
    private static final String NBT_BIOMEKEY = "biomeKey";

    public ItemBiomeExtract(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public static Registry<Biome> getBiomeRegistry() {
        Level level = WorldHelpers.getActiveLevel();
        if (level == null) {
            return null;
        }
        return level.m_9598_().m_175515_(Registries.f_256952_);
    }

    public String m_5671_(ItemStack itemStack) {
        Registry<Biome> biomeRegistry = ItemBiomeExtract.getBiomeRegistry();
        return super.m_5671_(itemStack) + (biomeRegistry == null || ItemBiomeExtract.getBiome(biomeRegistry, itemStack) == null ? ".empty" : "");
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Registry registry = (Registry)world.m_9598_().m_6632_(ForgeRegistries.Keys.BIOMES).get();
        if (!world.m_5776_() && ItemBiomeExtract.getBiome((Registry<Biome>)registry, itemStack) != null && !ItemBiomeExtractConfig.isUsageBlacklisted((Registry<Biome>)registry, ItemBiomeExtract.getBiome((Registry<Biome>)registry, itemStack))) {
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 0.5f, 0.4f / (world.f_46441_.m_188501_() * 0.4f + 0.8f));
            EntityBiomeExtract entity = new EntityBiomeExtract(world, (LivingEntity)player, itemStack.m_41777_());
            entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), -20.0f, 0.5f, 1.0f);
            world.m_7967_((Entity)entity);
            itemStack.m_41774_(1);
        }
        return MinecraftHelpers.successAction((Object)itemStack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        Biome biome;
        super.m_7373_(itemStack, world, list, flag);
        Registry<Biome> registry = ItemBiomeExtract.getBiomeRegistry();
        if (registry != null && (biome = ItemBiomeExtract.getBiome(registry, itemStack)) != null) {
            ResourceLocation key = registry.m_7981_((Object)biome);
            list.add((Component)Component.m_237110_((String)(this.m_5524_() + ".info.content"), (Object[])new Object[]{Component.m_237115_((String)("biome." + key.m_135827_() + "." + key.m_135815_()))}));
        }
    }

    public Iterable<Biome> getBiomes() {
        return ItemBiomeExtract.getBiomeRegistry();
    }

    public boolean isEmpty(Registry<Biome> registry, ItemStack itemStack) {
        return ItemBiomeExtract.getBiome(registry, itemStack) == null;
    }

    public static Biome getBiome(Registry<Biome> registry, ItemStack itemStack) {
        String biomeName;
        if (itemStack.m_41782_() && registry.m_7804_(new ResourceLocation(biomeName = itemStack.m_41783_().m_128461_(NBT_BIOMEKEY)))) {
            return (Biome)registry.m_7745_(new ResourceLocation(biomeName));
        }
        return null;
    }

    public ItemStack createItemStack(Function<Biome, ResourceLocation> biomeKeyFunction, Biome biome, int amount) {
        ItemStack itemStack = new ItemStack((ItemLike)this, amount);
        if (biome != null) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(NBT_BIOMEKEY, biomeKeyFunction.apply(biome).toString());
            itemStack.m_41751_(tag);
        }
        return itemStack;
    }

    public Rarity m_41460_(ItemStack itemStack) {
        Biome biome;
        Registry<Biome> biomeRegistry = ItemBiomeExtract.getBiomeRegistry();
        Biome biome2 = biome = biomeRegistry != null ? ItemBiomeExtract.getBiome(biomeRegistry, itemStack) : null;
        if (biome == null) {
            return Rarity.COMMON;
        }
        return biome.m_47518_().m_48344_() <= 0.05f ? Rarity.EPIC : (biome.m_47518_().m_48344_() <= 0.1f ? Rarity.RARE : Rarity.UNCOMMON);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    implements net.minecraft.client.color.item.ItemColor {
        public int m_92671_(ItemStack itemStack, int renderPass) {
            if (renderPass == 0) {
                Biome biome;
                Registry<Biome> biomeRegistry = ItemBiomeExtract.getBiomeRegistry();
                Biome biome2 = biomeRegistry != null ? ItemBiomeExtract.getBiome(biomeRegistry, itemStack) : (biome = null);
                if (biome != null) {
                    return biome.m_47542_();
                }
                return Helpers.RGBToInt((int)125, (int)125, (int)125);
            }
            return 0xFFFFFF;
        }
    }
}

