/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.blockentity.BlockEntityEntangledChalice;
import org.cyclops.evilcraft.core.fluid.FluidContainerItemWrapperWithSimulation;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;
import org.cyclops.evilcraft.core.helper.ItemHelpers;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;

public class ItemEntangledChalice
extends ItemBlockFluidContainer {
    public static String[] namePartsArray = "the elder scrolls klaatu berata niktu xyzzy bless curse light darkness fire air earth water hot dry cold wet ignite snuff embiggen twist shorten stretch fiddle destroy imbue galvanize enchant free limited range of towards inside sphere cube self other ball mental physical grow shrink demon elemental spirit animal creature beast humanoid undead fresh stale phnglui mglwnafh cthulhu rlyeh wgahnagl fhtagnbaguette".split(" ");

    public ItemEntangledChalice(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Override
    public boolean m_5812_(ItemStack itemStack) {
        return ItemHelpers.isActivated(itemStack);
    }

    @Override
    protected void autofill(int itemSlot, IFluidHandlerItem source, Level world, Entity entity) {
        if (entity instanceof Player && !world.m_5776_()) {
            FluidStack tickFluid;
            Player player = (Player)entity;
            PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
            do {
                ItemStack filled;
                tickFluid = FluidHelpers.getFluid((IFluidHandler)source);
                ItemStack toFill = it.next();
                if (tickFluid == null || toFill.m_41619_() || toFill.m_41613_() != 1 || (filled = ItemHelpers.tryFillContainerForPlayer(source, toFill, tickFluid, player)).m_41619_()) continue;
                it.replace(filled);
                player.m_150109_().m_6836_(itemSlot, source.getContainer());
            } while (tickFluid != null && tickFluid.getAmount() > 0 && it.hasNext());
        }
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new FluidHandler(stack, 4000);
    }

    @Override
    protected boolean itemStackDataToTile(ItemStack itemStack, BlockEntity tile) {
        super.itemStackDataToTile(itemStack, tile);
        FluidHandler fluidHandler = (FluidHandler)((Object)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null));
        String tankId = fluidHandler.getTankID();
        ((BlockEntityEntangledChalice)tile).setWorldTankId(tankId);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        super.m_7373_(itemStack, worldIn, list, flagIn);
        FluidHandler fluidHandler = (FluidHandler)((Object)FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null));
        String tankId = fluidHandler == null ? "null" : fluidHandler.getTankID();
        list.add((Component)Component.m_237110_((String)"block.evilcraft.entangled_chalice.info.id", (Object[])new Object[]{ItemEntangledChalice.tankIdToNameParts(tankId)}));
    }

    public static String tankIdToNameParts(String tankId) {
        try {
            int i = Integer.parseInt(tankId);
            String a = namePartsArray[(i + 3) % namePartsArray.length];
            String b = namePartsArray[(i * 3 + 5) % namePartsArray.length];
            String c = namePartsArray[(i * 13 + 7) % namePartsArray.length];
            return String.format("%s %s %s", a, b, c);
        }
        catch (NumberFormatException e) {
            return tankId;
        }
    }

    public static class FluidHandler
    extends FluidContainerItemWrapperWithSimulation {
        public FluidHandler(ItemStack container, int capacity) {
            super(container, capacity);
        }

        public FluidStack getFluid() {
            return WorldSharedTankCache.getInstance().getTankContent(this.getTankID());
        }

        protected void setFluid(FluidStack fluidStack) {
            WorldSharedTankCache.getInstance().setTankContent(this.getTankID(), fluidStack);
        }

        protected void setContainerToEmpty() {
            this.setFluid(FluidStack.EMPTY);
        }

        public String getTankID() {
            CompoundTag tag = this.getContainer().m_41783_();
            if (tag != null) {
                if (!tag.m_128441_("tankID")) {
                    tag.m_128359_("tankID", "");
                }
                return tag.m_128461_("tankID");
            }
            return "";
        }

        public void setTankID(String tankID) {
            CompoundTag tag = this.getContainer().m_41784_();
            tag.m_128359_("tankID", tankID);
        }

        public void setNextTankID() {
            this.setTankID(Integer.toString(EvilCraft.globalCounters.getNext("EntangledChalice")));
        }
    }
}

