/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.world.gen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.MonsterRoomFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.common.DungeonHooks;
import org.cyclops.evilcraft.RegistryEntries;

public class WorldFeatureEvilDungeon
extends MonsterRoomFeature {
    private static final int RADIUS_X = 3;
    private static final int RADIUS_X_RAND = 4;
    private static final int RADIUS_Z = 3;
    private static final int RADIUS_Z_RAND = 4;
    private static final int CHESTS = 2;
    private static final int CHESTS_RAND = 2;

    public WorldFeatureEvilDungeon(Codec<NoneFeatureConfiguration> config) {
        super(config);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos loopPos;
        int zr;
        int yr;
        int xr;
        WorldGenLevel world = context.m_159774_();
        BlockPos blockPos = context.m_159777_();
        RandomSource random = context.m_225041_();
        int height = 3;
        int radiusX = random.m_188503_(4) + 3;
        int radiusZ = random.m_188503_(4) + 3;
        int chests = random.m_188503_(2) + 2;
        int openingCounter = 0;
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        for (xr = x - radiusX - 1; xr <= x + radiusX + 1; ++xr) {
            for (yr = y - 1; yr <= y + height + 1; ++yr) {
                for (zr = z - radiusZ - 1; zr <= z + radiusZ + 1; ++zr) {
                    loopPos = new BlockPos(xr, yr, zr);
                    if (!world.m_7726_().m_5563_(xr / 16, yr / 16)) {
                        return false;
                    }
                    BlockState blockState = world.m_8055_(loopPos);
                    if (yr == y - 1 && !blockState.m_280296_()) {
                        return false;
                    }
                    if (yr == y + height + 1 && !blockState.m_280296_()) {
                        return false;
                    }
                    if (xr != x - radiusX - 1 && xr != x + radiusX + 1 && zr != z - radiusZ - 1 && zr != z + radiusZ + 1 || yr != y || !world.m_46859_(loopPos) || !world.m_46859_(loopPos.m_7918_(0, 1, 0))) continue;
                    ++openingCounter;
                }
            }
        }
        if (openingCounter >= 1 && openingCounter <= 15) {
            BlockPos loopPos2;
            for (xr = x - radiusX - 1; xr <= x + radiusX + 1; ++xr) {
                for (yr = y + height; yr >= y - 1; --yr) {
                    for (zr = z - radiusZ - 1; zr <= z + radiusZ + 1; ++zr) {
                        loopPos = new BlockPos(xr, yr, zr);
                        if (xr != x - radiusX - 1 && yr != y - 1 && zr != z - radiusZ - 1 && xr != x + radiusX + 1 && yr != y + height + 1 && zr != z + radiusZ + 1) {
                            world.m_7471_(loopPos, false);
                            continue;
                        }
                        if (yr >= 0 && !world.m_8055_(loopPos.m_7918_(0, -1, 0)).m_280296_()) {
                            world.m_7471_(loopPos, false);
                            continue;
                        }
                        if (!world.m_8055_(loopPos).m_280296_()) continue;
                        if (yr == y - 1 && random.m_188503_(4) != 0) {
                            world.m_7731_(loopPos, RegistryEntries.BLOCK_BLOODY_COBBLESTONE.m_49966_(), 2);
                            continue;
                        }
                        world.m_7731_(loopPos, Blocks.f_50652_.m_49966_(), 2);
                    }
                }
            }
            int attempts = 100;
            for (int xr2 = 0; xr2 < attempts && chests > 0; ++xr2) {
                int zrr;
                int xrr = x + random.m_188503_(radiusX * 2 + 1) - radiusX;
                loopPos2 = new BlockPos(xrr, y, zrr = z + random.m_188503_(radiusZ * 2 + 1) - radiusZ);
                if (!world.m_46859_(loopPos2)) continue;
                int wallCounter = 0;
                if (world.m_8055_(loopPos2.m_7918_(-1, 0, 0)).m_280296_()) {
                    ++wallCounter;
                }
                if (world.m_8055_(loopPos2.m_7918_(1, 0, 0)).m_280296_()) {
                    ++wallCounter;
                }
                if (world.m_8055_(loopPos2.m_7918_(0, 0, -1)).m_280296_()) {
                    ++wallCounter;
                }
                if (world.m_8055_(loopPos2.m_7918_(0, 0, 1)).m_280296_()) {
                    ++wallCounter;
                }
                if (wallCounter != 1) continue;
                world.m_7731_(loopPos2, Blocks.f_50087_.m_49966_(), 2);
                RandomizableContainerBlockEntity.m_222766_((BlockGetter)world, (RandomSource)random, (BlockPos)loopPos2, (ResourceLocation)BuiltInLootTables.f_78742_);
                --chests;
            }
            for (int xs = x - 1; xs <= x + 1; xs += 2) {
                for (int zs = z - 1; zs <= z + 1; zs += 2) {
                    loopPos2 = new BlockPos(xs, y, zs);
                    world.m_7731_(loopPos2, Blocks.f_50085_.m_49966_(), 2);
                    BlockEntity tile = world.m_7702_(loopPos2);
                    if (tile instanceof SpawnerBlockEntity) {
                        ((SpawnerBlockEntity)tile).m_59801_().m_253197_(DungeonHooks.getRandomDungeonMob((RandomSource)random), null, random, loopPos2);
                        continue;
                    }
                    System.err.println("Failed to fetch mob spawner entity at (" + xs + ", " + y + ", " + zs + ")");
                }
            }
            return true;
        }
        return false;
    }
}

