/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades;

import club.pisquad.minecraft.csgrenades.config.ModConfig;
import club.pisquad.minecraft.csgrenades.entity.SmokeGrenadeEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0006\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\u0016\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\b\u001a\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\b\u001a\u000e\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0006\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002\u001a\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0018\u001a,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018\u001a\u001e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b\u001a\n\u0010!\u001a\u00020\"*\u00020\"\u001a\u0012\u0010#\u001a\u00020\b*\u00020\u00022\u0006\u0010$\u001a\u00020\u0002\u001a\u0012\u0010%\u001a\u00020\b*\u00020\u00062\u0006\u0010$\u001a\u00020\u0006\u001a\u0012\u0010#\u001a\u00020\b*\u00020\u00062\u0006\u0010$\u001a\u00020\u0006\u00a8\u0006&"}, d2={"toVec3i", "Lnet/minecraft/core/Vec3i;", "Lnet/minecraft/world/phys/Vec3;", "snapToAxis", "Lnet/minecraft/core/Direction;", "toVec3", "Lnet/minecraft/core/BlockPos;", "getTimeFromTickCount", "", "tickCount", "getRandomLocationFromSphere", "center", "radius", "getRandomLocationFromCircle", "Lnet/minecraft/world/phys/Vec2;", "getRandomLocationFromBlockSurface", "position", "isPositionInSmoke", "", "level", "Lnet/minecraft/world/level/Level;", "pos", "getBlockPosAround2D", "", "", "getBlocksAround3D", "xRange", "yRange", "zRange", "linearInterpolate", "from", "to", "t", "millToTick", "", "horizontalDistanceTo", "other", "horizontalDistanceToSqr", "csgrenades"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nclub/pisquad/minecraft/csgrenades/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1755#2,2:153\n1755#2,3:155\n1757#2:158\n*S KotlinDebug\n*F\n+ 1 Utils.kt\nclub/pisquad/minecraft/csgrenades/UtilsKt\n*L\n91#1:153,2\n92#1:155,3\n91#1:158\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final Vec3i toVec3i(@NotNull Vec3 $this$toVec3i) {
        Intrinsics.checkNotNullParameter((Object)$this$toVec3i, (String)"<this>");
        return new Vec3i((int)$this$toVec3i.f_82479_, (int)$this$toVec3i.f_82480_, (int)$this$toVec3i.f_82481_);
    }

    @NotNull
    public static final Direction snapToAxis(@NotNull Vec3 $this$snapToAxis) {
        Intrinsics.checkNotNullParameter((Object)$this$snapToAxis, (String)"<this>");
        double absX = Math.abs($this$snapToAxis.f_82479_);
        double absY = Math.abs($this$snapToAxis.f_82480_);
        double absZ = Math.abs($this$snapToAxis.f_82481_);
        return absX >= absY && absX >= absZ ? ($this$snapToAxis.f_82479_ > 0.0 ? Direction.NORTH : Direction.SOUTH) : (absY >= absX && absY >= absZ ? ($this$snapToAxis.f_82480_ > 0.0 ? Direction.UP : Direction.DOWN) : ($this$snapToAxis.f_82481_ > 0.0 ? Direction.EAST : Direction.WEST));
    }

    @NotNull
    public static final Vec3 toVec3(@NotNull BlockPos $this$toVec3) {
        Intrinsics.checkNotNullParameter((Object)$this$toVec3, (String)"<this>");
        return new Vec3((double)$this$toVec3.m_123341_(), (double)$this$toVec3.m_123342_(), (double)$this$toVec3.m_123343_());
    }

    @NotNull
    public static final Vec3 toVec3(@NotNull Vec3i $this$toVec3) {
        Intrinsics.checkNotNullParameter((Object)$this$toVec3, (String)"<this>");
        return new Vec3((double)$this$toVec3.m_123341_(), (double)$this$toVec3.m_123342_(), (double)$this$toVec3.m_123343_());
    }

    public static final double getTimeFromTickCount(double tickCount) {
        return tickCount / 20.0;
    }

    @NotNull
    public static final Vec3 getRandomLocationFromSphere(@NotNull Vec3 center, double radius) {
        Vec3 posDelta;
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        RandomSource randomSource = RandomSource.m_216343_();
        while (!((posDelta = new Vec3(randomSource.m_188500_() * radius * (double)2 - radius, randomSource.m_188500_() * radius * (double)2 - radius, randomSource.m_188500_() * radius * (double)2 - radius)).m_82553_() < radius)) {
        }
        Vec3 vec3 = center.m_82549_(posDelta);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        return vec3;
    }

    @NotNull
    public static final Vec2 getRandomLocationFromCircle(@NotNull Vec2 center, double radius) {
        Vec2 posDelta;
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        RandomSource randomSource = RandomSource.m_216343_();
        while (!((double)(posDelta = new Vec2((float)(randomSource.m_188500_() * radius * (double)2 - radius), (float)(randomSource.m_188500_() * radius * (double)2 - radius))).m_165907_() < radius)) {
        }
        Vec2 vec2 = center.m_165910_(posDelta);
        Intrinsics.checkNotNullExpressionValue((Object)vec2, (String)"add(...)");
        return vec2;
    }

    @NotNull
    public static final Vec3 getRandomLocationFromBlockSurface(@NotNull BlockPos position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        double x = Random.Default.nextDouble();
        double z = Random.Default.nextDouble();
        return new Vec3((double)position.m_123341_() + x, (double)position.m_123342_() + 1.0, (double)position.m_123343_() + z);
    }

    public static final boolean isPositionInSmoke(@NotNull Level level, @NotNull Vec3 pos) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            BlockPos blockPos = BlockPos.m_274446_((Position)((Position)pos));
            List list = level.m_45976_(SmokeGrenadeEntity.class, new AABB(new BlockPos(UtilsKt.toVec3i(pos))).m_82377_(((Number)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_RADIUS().get()).doubleValue() * 2.0, ((Number)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_MAX_FALLING_HEIGHT().get()).doubleValue() + ((Number)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_RADIUS().get()).doubleValue() * 2.0, ((Number)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_RADIUS().get()).doubleValue() * 2.0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        SmokeGrenadeEntity it = (SmokeGrenadeEntity)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = it.getSpreadBlocks();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                BlockPos block = (BlockPos)element$iv2;
                                boolean bl4 = false;
                                if (!Intrinsics.areEqual((Object)block, (Object)blockPos)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final List<BlockPos> getBlockPosAround2D(@NotNull Vec3 pos, int radius) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos posVec3 = BlockPos.m_274446_((Position)((Position)pos));
        BlockPos begin = posVec3.m_7918_(-radius, 0, -radius);
        List result = new ArrayList();
        int n = radius * 2 + 1;
        for (int i = 0; i < n; ++i) {
            int xOffset = i;
            boolean bl = false;
            int n2 = radius * 2 + 1;
            int n3 = 0;
            while (n3 < n2) {
                int zOffset = n3++;
                boolean bl2 = false;
                result.add(new BlockPos((Vec3i)begin.m_7918_(xOffset, 0, zOffset)));
            }
        }
        return result;
    }

    @NotNull
    public static final List<BlockPos> getBlocksAround3D(@NotNull Vec3 pos, int xRange, int yRange, int zRange) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos posVec3 = BlockPos.m_274446_((Position)((Position)pos));
        BlockPos begin = posVec3.m_7918_(-xRange, -yRange, -zRange);
        List result = new ArrayList();
        int n = xRange * 2 + 1;
        for (int i = 0; i < n; ++i) {
            int xOffset = i;
            boolean bl = false;
            int n2 = yRange * 2 + 1;
            for (int j = 0; j < n2; ++j) {
                int yOffset = j;
                boolean bl2 = false;
                int n3 = zRange * 2 + 1;
                int n4 = 0;
                while (n4 < n3) {
                    int zOffset = n4++;
                    boolean bl3 = false;
                    result.add(new BlockPos((Vec3i)begin.m_7918_(xOffset, yOffset, zOffset)));
                }
            }
        }
        return result;
    }

    public static final double linearInterpolate(double from, double to, double t) {
        return from + (to - from) * t;
    }

    public static final long millToTick(long $this$millToTick) {
        return $this$millToTick / (long)50;
    }

    public static final double horizontalDistanceTo(@NotNull Vec3 $this$horizontalDistanceTo, @NotNull Vec3 other) {
        Intrinsics.checkNotNullParameter((Object)$this$horizontalDistanceTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Math.sqrt(new Vec2((float)$this$horizontalDistanceTo.f_82479_, (float)$this$horizontalDistanceTo.f_82481_).m_165914_(new Vec2((float)other.f_82479_, (float)other.f_82481_)));
    }

    public static final double horizontalDistanceToSqr(@NotNull BlockPos $this$horizontalDistanceToSqr, @NotNull BlockPos other) {
        Intrinsics.checkNotNullParameter((Object)$this$horizontalDistanceToSqr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vec2((float)$this$horizontalDistanceToSqr.m_123341_(), (float)$this$horizontalDistanceToSqr.m_123343_()).m_165914_(new Vec2((float)other.m_123341_(), (float)other.m_123343_()));
    }

    public static final double horizontalDistanceTo(@NotNull BlockPos $this$horizontalDistanceTo, @NotNull BlockPos other) {
        Intrinsics.checkNotNullParameter((Object)$this$horizontalDistanceTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Math.sqrt(UtilsKt.horizontalDistanceToSqr($this$horizontalDistanceTo, other));
    }
}

