/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.client.input;

import club.pisquad.minecraft.csgrenades.UtilsKt;
import club.pisquad.minecraft.csgrenades.client.input.ThrowActionHandlerKt;
import club.pisquad.minecraft.csgrenades.config.ModConfig;
import club.pisquad.minecraft.csgrenades.enums.GrenadeType;
import club.pisquad.minecraft.csgrenades.item.CounterStrikeGrenadeItem;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="csgrenades", bus=Mod.EventBusSubscriber.Bus.FORGE)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\b\u0010\u001b\u001a\u00020\u0018H\u0002J\u001f\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0018H\u0002J\u0014\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001e\u0010\r\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lclub/pisquad/minecraft/csgrenades/client/input/ThrowActionHandler;", "", "<init>", "()V", "grenadeLastThrow", "Ljava/time/Instant;", "primaryButtonPressed", "", "secondaryButtonPressed", "throwSpeedTransientTarget", "", "Ljava/lang/Double;", "throwSpeedTransientOrigin", "currentThrowSpeed", "getCurrentThrowSpeed", "()Ljava/lang/Double;", "setCurrentThrowSpeed", "(Ljava/lang/Double;)V", "transientBeginTime", "previousSlot", "", "screenOpened", "buttonPressedWhenScreenOpen", "onClientTick", "", "event", "Lnet/minecraftforge/event/TickEvent$ClientTickEvent;", "cleanProgress", "setNewTransientTarget", "speedTarget", "speedOrigin", "(DLjava/lang/Double;)V", "updateCurrentSpeed", "getButtonState", "Lkotlin/Pair;", "csgrenades"})
public final class ThrowActionHandler {
    @NotNull
    public static final ThrowActionHandler INSTANCE = new ThrowActionHandler();
    @NotNull
    private static Instant grenadeLastThrow;
    private static boolean primaryButtonPressed;
    private static boolean secondaryButtonPressed;
    @Nullable
    private static Double throwSpeedTransientTarget;
    @Nullable
    private static Double throwSpeedTransientOrigin;
    @Nullable
    private static Double currentThrowSpeed;
    @NotNull
    private static Instant transientBeginTime;
    private static int previousSlot;
    private static boolean screenOpened;
    private static boolean buttonPressedWhenScreenOpen;

    private ThrowActionHandler() {
    }

    @Nullable
    public final Double getCurrentThrowSpeed() {
        return currentThrowSpeed;
    }

    public final void setCurrentThrowSpeed(@Nullable Double d) {
        currentThrowSpeed = d;
    }

    @SubscribeEvent
    public final void onClientTick(@NotNull TickEvent.ClientTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Pair<Boolean, Boolean> pair = this.getButtonState();
        boolean primaryButtonPressed = (Boolean)pair.component1();
        boolean secondaryButtonPressed = (Boolean)pair.component2();
        if (Minecraft.m_91087_().f_91080_ != null) {
            screenOpened = true;
            if (ThrowActionHandler.primaryButtonPressed || ThrowActionHandler.secondaryButtonPressed) {
                this.cleanProgress();
                buttonPressedWhenScreenOpen = true;
            }
            return;
        }
        if (screenOpened) {
            buttonPressedWhenScreenOpen = primaryButtonPressed || secondaryButtonPressed;
            screenOpened = false;
            return;
        }
        if (buttonPressedWhenScreenOpen) {
            if (!primaryButtonPressed && !secondaryButtonPressed) {
                buttonPressedWhenScreenOpen = false;
                return;
            }
            return;
        }
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        int selectedSlot = player.m_150109_().f_35977_;
        ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemInHand.m_41720_() instanceof CounterStrikeGrenadeItem && previousSlot == selectedSlot) {
            if (Duration.between(grenadeLastThrow, Instant.now()).toMillis() > (long)((Number)ModConfig.INSTANCE.getGRENADE_THROW_COOLDOWN().get()).intValue()) {
                Pair pair2 = new Pair((Object)ThrowActionHandler.primaryButtonPressed, (Object)ThrowActionHandler.secondaryButtonPressed);
                if (Intrinsics.areEqual((Object)pair2, (Object)new Pair((Object)false, (Object)false))) {
                    Pair pair3 = new Pair((Object)primaryButtonPressed, (Object)secondaryButtonPressed);
                    if (Intrinsics.areEqual((Object)pair3, (Object)new Pair((Object)true, (Object)true))) {
                        Object object = ModConfig.INSTANCE.getTHROW_SPEED_MODERATE().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        this.setNewTransientTarget(((Number)object).doubleValue(), (Double)ModConfig.INSTANCE.getTHROW_SPEED_MODERATE().get());
                    } else if (Intrinsics.areEqual((Object)pair3, (Object)new Pair((Object)true, (Object)false))) {
                        Object object = ModConfig.INSTANCE.getTHROW_SPEED_STRONG().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        this.setNewTransientTarget(((Number)object).doubleValue(), (Double)ModConfig.INSTANCE.getTHROW_SPEED_STRONG().get());
                    } else if (Intrinsics.areEqual((Object)pair3, (Object)new Pair((Object)false, (Object)true))) {
                        Object object = ModConfig.INSTANCE.getTHROW_SPEED_WEAK().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        this.setNewTransientTarget(((Number)object).doubleValue(), (Double)ModConfig.INSTANCE.getTHROW_SPEED_WEAK().get());
                    }
                } else if (Intrinsics.areEqual((Object)pair2, (Object)new Pair((Object)true, (Object)false))) {
                    Pair pair4 = new Pair((Object)primaryButtonPressed, (Object)secondaryButtonPressed);
                    if (Intrinsics.areEqual((Object)pair4, (Object)new Pair((Object)true, (Object)true))) {
                        Object object = ModConfig.INSTANCE.getTHROW_SPEED_MODERATE().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        this.setNewTransientTarget(((Number)object).doubleValue(), null);
                    } else if (Intrinsics.areEqual((Object)pair4, (Object)new Pair((Object)false, (Object)true))) {
                        Object object = ModConfig.INSTANCE.getTHROW_SPEED_WEAK().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        this.setNewTransientTarget(((Number)object).doubleValue(), null);
                    }
                } else if (Intrinsics.areEqual((Object)pair2, (Object)new Pair((Object)false, (Object)true))) {
                    Pair pair5 = new Pair((Object)primaryButtonPressed, (Object)secondaryButtonPressed);
                    if (Intrinsics.areEqual((Object)pair5, (Object)new Pair((Object)true, (Object)true))) {
                        Object object = ModConfig.INSTANCE.getTHROW_SPEED_MODERATE().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        this.setNewTransientTarget(((Number)object).doubleValue(), null);
                    } else if (Intrinsics.areEqual((Object)pair5, (Object)new Pair((Object)true, (Object)false))) {
                        Object object = ModConfig.INSTANCE.getTHROW_SPEED_STRONG().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        this.setNewTransientTarget(((Number)object).doubleValue(), null);
                    }
                } else if (Intrinsics.areEqual((Object)pair2, (Object)new Pair((Object)true, (Object)true))) {
                    Pair pair6 = new Pair((Object)primaryButtonPressed, (Object)secondaryButtonPressed);
                    if (Intrinsics.areEqual((Object)pair6, (Object)new Pair((Object)true, (Object)false))) {
                        Object object = ModConfig.INSTANCE.getTHROW_SPEED_STRONG().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        this.setNewTransientTarget(((Number)object).doubleValue(), null);
                    } else if (Intrinsics.areEqual((Object)pair6, (Object)new Pair((Object)false, (Object)true))) {
                        Object object = ModConfig.INSTANCE.getTHROW_SPEED_WEAK().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        this.setNewTransientTarget(((Number)object).doubleValue(), null);
                    }
                }
                this.updateCurrentSpeed();
                if (!primaryButtonPressed && !secondaryButtonPressed && (ThrowActionHandler.primaryButtonPressed || ThrowActionHandler.secondaryButtonPressed)) {
                    Item item = itemInHand.m_41720_();
                    Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type club.pisquad.minecraft.csgrenades.item.CounterStrikeGrenadeItem");
                    GrenadeType grenadeType = ((CounterStrikeGrenadeItem)item).getGrenadeType();
                    Double d = currentThrowSpeed;
                    ThrowActionHandlerKt.throwAction(d != null ? d : 0.0, grenadeType);
                    ThrowActionHandlerKt.setItemCoolDown((Player)player);
                    this.cleanProgress();
                    grenadeLastThrow = Instant.now();
                }
                ThrowActionHandler.primaryButtonPressed = primaryButtonPressed;
                ThrowActionHandler.secondaryButtonPressed = secondaryButtonPressed;
            }
        } else {
            ThrowActionHandler.primaryButtonPressed = false;
            ThrowActionHandler.secondaryButtonPressed = false;
            this.cleanProgress();
        }
        previousSlot = selectedSlot;
    }

    private final void cleanProgress() {
        primaryButtonPressed = false;
        secondaryButtonPressed = false;
        currentThrowSpeed = null;
        throwSpeedTransientTarget = null;
        throwSpeedTransientOrigin = null;
    }

    private final void setNewTransientTarget(double speedTarget, Double speedOrigin) {
        Double d = speedOrigin;
        if (d == null) {
            d = currentThrowSpeed;
        }
        throwSpeedTransientOrigin = d;
        throwSpeedTransientTarget = speedTarget;
        transientBeginTime = Instant.now();
    }

    private final void updateCurrentSpeed() {
        if (throwSpeedTransientOrigin == null || throwSpeedTransientTarget == null) {
            return;
        }
        Double d = throwSpeedTransientOrigin;
        Intrinsics.checkNotNull((Object)d);
        double d2 = d;
        Double d3 = throwSpeedTransientTarget;
        Intrinsics.checkNotNull((Object)d3);
        double d4 = d3;
        double d5 = 1.0;
        double d6 = Duration.between(transientBeginTime, Instant.now()).toMillis();
        Object object = ModConfig.INSTANCE.getTHROW_TYPE_TRANSIENT_TIME().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        double d7 = d6 / ((Number)object).doubleValue();
        currentThrowSpeed = UtilsKt.linearInterpolate(d2, d4, Math.min(d5, d7));
    }

    private final Pair<Boolean, Boolean> getButtonState() {
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        return new Pair((Object)(GLFW.glfwGetMouseButton((long)window, (int)0) == 1 ? 1 : 0), (Object)(GLFW.glfwGetMouseButton((long)window, (int)1) == 1 ? 1 : 0));
    }

    static {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        grenadeLastThrow = instant;
        Instant instant2 = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now(...)");
        transientBeginTime = instant2;
        previousSlot = -1;
    }
}

