/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.client.input;

import club.pisquad.minecraft.csgrenades.UtilsKt;
import club.pisquad.minecraft.csgrenades.config.ModConfig;
import club.pisquad.minecraft.csgrenades.enums.GrenadeType;
import club.pisquad.minecraft.csgrenades.item.CounterStrikeGrenadeItem;
import club.pisquad.minecraft.csgrenades.network.CsGrenadePacketHandler;
import club.pisquad.minecraft.csgrenades.network.message.GrenadeThrownMessage;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"throwAction", "", "throwSpeed", "", "grenadeType", "Lclub/pisquad/minecraft/csgrenades/enums/GrenadeType;", "setItemCoolDown", "player", "Lnet/minecraft/world/entity/player/Player;", "csgrenades"})
@SourceDebugExtension(value={"SMAP\nThrowActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrowActionHandler.kt\nclub/pisquad/minecraft/csgrenades/client/input/ThrowActionHandlerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,254:1\n1863#2,2:255\n*S KotlinDebug\n*F\n+ 1 ThrowActionHandler.kt\nclub/pisquad/minecraft/csgrenades/client/input/ThrowActionHandlerKt\n*L\n248#1:255,2\n*E\n"})
public final class ThrowActionHandlerKt {
    public static final void throwAction(double throwSpeed, @NotNull GrenadeType grenadeType) {
        ItemStack itemInHand;
        CompoundTag tag;
        Intrinsics.checkNotNullParameter((Object)((Object)grenadeType), (String)"grenadeType");
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null) {
            return;
        }
        Player player = (Player)localPlayer;
        Object object = ModConfig.INSTANCE.getTHROW_SPEED_WEAK().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        double d = throwSpeed - ((Number)object).doubleValue();
        double d2 = ((Number)ModConfig.INSTANCE.getTHROW_SPEED_STRONG().get()).doubleValue();
        Object object2 = ModConfig.INSTANCE.getTHROW_SPEED_WEAK().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        double speedFactor = d / (d2 - ((Number)object2).doubleValue());
        Object object3 = ModConfig.INSTANCE.getPLAYER_SPEED_FACTOR_WEAK().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        double d3 = ((Number)object3).doubleValue();
        Object object4 = ModConfig.INSTANCE.getPLAYER_SPEED_FACTOR_STRONG().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        double playerSpeedFactor = UtilsKt.linearInterpolate(d3, ((Number)object4).doubleValue(), speedFactor);
        Vec3 vec3 = player.m_20184_().m_82490_(playerSpeedFactor);
        Vec3 vec32 = player.m_20154_().m_82541_();
        Object object5 = ModConfig.INSTANCE.getTHROW_SPEED_WEAK().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
        double d4 = ((Number)object5).doubleValue();
        Object object6 = ModConfig.INSTANCE.getTHROW_SPEED_STRONG().get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
        double speed = vec3.m_82549_(vec32.m_82490_(UtilsKt.linearInterpolate(d4, ((Number)object6).doubleValue(), speedFactor))).m_82553_();
        String customSound = null;
        if (grenadeType == GrenadeType.DECOY_GRENADE && (tag = (itemInHand = player.m_21120_(InteractionHand.MAIN_HAND)).m_41783_()) != null && tag.m_128425_("DecoySound", 8)) {
            customSound = tag.m_128461_("DecoySound");
        }
        SimpleChannel simpleChannel = CsGrenadePacketHandler.INSTANCE.getINSTANCE();
        UUID uUID = player.m_20148_();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        Vec3 vec33 = player.m_146892_();
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"getEyePosition(...)");
        simpleChannel.sendToServer((Object)new GrenadeThrownMessage(uUID, speed, grenadeType, vec33, new Rotations(player.m_146909_(), player.m_146908_(), 0.0f), customSound));
    }

    public static final void setItemCoolDown(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        NonNullList nonNullList = player.m_150109_().f_35974_;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"items");
        Iterable $this$forEach$iv = (Iterable)nonNullList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            if (!(it.m_41720_() instanceof CounterStrikeGrenadeItem)) continue;
            player.m_36335_().m_41524_(it.m_41720_(), ((Number)ModConfig.INSTANCE.getGRENADE_THROW_COOLDOWN().get()).intValue() / 1000 * 20);
        }
    }
}

