/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.client.render;

import club.pisquad.minecraft.csgrenades.entity.AbstractFireGrenade;
import club.pisquad.minecraft.csgrenades.entity.CounterStrikeGrenadeEntity;
import club.pisquad.minecraft.csgrenades.entity.GrenadeEntityInterface;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\f\b\u0000\u0010\u0001*\u00020\u0002*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ=\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lclub/pisquad/minecraft/csgrenades/client/render/GrenadeRenderer;", "T", "Lnet/minecraft/world/entity/Entity;", "Lclub/pisquad/minecraft/csgrenades/entity/GrenadeEntityInterface;", "Lnet/minecraft/client/renderer/entity/EntityRenderer;", "context", "Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;", "<init>", "(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;)V", "itemRenderer", "Lnet/minecraft/client/renderer/entity/ItemRenderer;", "render", "", "entity", "entityYaw", "", "partialTicks", "poseStack", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "packedLight", "", "(Lnet/minecraft/world/entity/Entity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", "getTextureLocation", "Lnet/minecraft/resources/ResourceLocation;", "(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/resources/ResourceLocation;", "csgrenades"})
public final class GrenadeRenderer<T extends Entity>
extends EntityRenderer<T> {
    @NotNull
    private final ItemRenderer itemRenderer;

    public GrenadeRenderer(@NotNull EntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        ItemRenderer itemRenderer = context.m_174025_();
        Intrinsics.checkNotNullExpressionValue((Object)itemRenderer, (String)"getItemRenderer(...)");
        this.itemRenderer = itemRenderer;
    }

    public void m_7392_(@NotNull T entity, float entityYaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (entity instanceof AbstractFireGrenade && ((Boolean)entity.m_20088_().m_135370_(CounterStrikeGrenadeEntity.Companion.isExplodedAccessor())).booleanValue()) {
            return;
        }
        poseStack.m_85836_();
        ItemStack itemStack = ((GrenadeEntityInterface)entity).m_7846_();
        if (!itemStack.m_41619_() && entity instanceof CounterStrikeGrenadeEntity) {
            float visualYRot = Mth.m_14179_((float)partialTicks, (float)((Entity)entity).f_19859_, (float)entity.m_146908_());
            float visualXRot = Mth.m_14179_((float)partialTicks, (float)((Entity)entity).f_19860_, (float)entity.m_146909_());
            float visualZRot = Mth.m_14179_((float)partialTicks, (float)((CounterStrikeGrenadeEntity)entity).getZRotO(), (float)((CounterStrikeGrenadeEntity)entity).getZRot());
            poseStack.m_85837_(0.0, 0.125, 0.0);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(visualYRot));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(visualZRot));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(visualXRot));
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            this.itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.f_118083_, poseStack, buffer, entity.m_9236_(), entity.m_19879_());
        }
        poseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation m_5478_(@NotNull T entity) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        ResourceLocation resourceLocation = TextureAtlas.f_118259_;
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"LOCATION_BLOCKS");
        return resourceLocation;
    }
}

