/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.client.renderer;

import club.pisquad.minecraft.csgrenades.UtilsKt;
import club.pisquad.minecraft.csgrenades.client.renderer.IncendiaryEffectRendererKt;
import club.pisquad.minecraft.csgrenades.config.ModConfig;
import club.pisquad.minecraft.csgrenades.entity.AbstractFireGrenade;
import club.pisquad.minecraft.csgrenades.entity.IncendiaryEntity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lclub/pisquad/minecraft/csgrenades/client/renderer/FireGrenadeRenderer;", "", "<init>", "()V", "randomSource", "Lnet/minecraft/util/RandomSource;", "kotlin.jvm.PlatformType", "Lnet/minecraft/util/RandomSource;", "renderOne", "", "grenade", "Lclub/pisquad/minecraft/csgrenades/entity/AbstractFireGrenade;", "csgrenades"})
public final class FireGrenadeRenderer {
    @NotNull
    public static final FireGrenadeRenderer INSTANCE = new FireGrenadeRenderer();
    private static final RandomSource randomSource = RandomSource.m_216343_();

    private FireGrenadeRenderer() {
    }

    public final void renderOne(@NotNull AbstractFireGrenade grenade) {
        Intrinsics.checkNotNullParameter((Object)grenade, (String)"grenade");
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        List<BlockPos> spreadBlocks = grenade.getSpreadBlocks();
        if (spreadBlocks.isEmpty()) {
            return;
        }
        Integer fireRange = (Integer)ModConfig.FireGrenade.INSTANCE.getFIRE_RANGE().get();
        int n = fireRange;
        Intrinsics.checkNotNull((Object)fireRange);
        int particlePerTick = n * fireRange * 1 * spreadBlocks.size() / (fireRange * fireRange);
        for (int i = 0; i < particlePerTick; ++i) {
            Vec3 position = grenade.m_20182_();
            Vec3 pos = UtilsKt.getRandomLocationFromBlockSurface((BlockPos)CollectionsKt.random((Collection)spreadBlocks, (Random)((Random)Random.Default)));
            Level level = grenade.m_9236_();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            Vec3 vec3 = pos.m_82549_(new Vec3(0.0, 0.5, 0.0));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            if (UtilsKt.isPositionInSmoke(level, vec3)) continue;
            double distance = new Vec2((float)(position.f_82479_ - pos.f_82479_), (float)(position.f_82481_ - pos.f_82481_)).m_165907_();
            SimpleParticleType flameParticleType = grenade instanceof IncendiaryEntity ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_;
            double random = randomSource.m_188500_();
            SimpleParticleType particleType = random < 0.2 ? ParticleTypes.f_123762_ : (random < 0.5 ? flameParticleType : ParticleTypes.f_175834_);
            Particle particle = particleEngine.m_107370_((ParticleOptions)particleType, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.1, 0.0);
            if (particle == null) continue;
            particle.m_107257_(IncendiaryEffectRendererKt.getLifetimeFromDistance(distance));
        }
    }
}

