/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.client.renderer;

import club.pisquad.minecraft.csgrenades.SoundTypes;
import club.pisquad.minecraft.csgrenades.SoundUtils;
import club.pisquad.minecraft.csgrenades.client.renderer.RenderState;
import club.pisquad.minecraft.csgrenades.network.message.FlashbangEffectData;
import club.pisquad.minecraft.csgrenades.registery.ModSoundEvents;
import club.pisquad.minecraft.csgrenades.sound.FlashbangRingSound;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="csgrenades", bus=Mod.EventBusSubscriber.Bus.FORGE)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0015H\u0007J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lclub/pisquad/minecraft/csgrenades/client/renderer/FlashbangBlindEffectRenderer;", "", "<init>", "()V", "effectAttack", "", "effectSustain", "effectDecay", "effectAmount", "renderStartTime", "Ljava/time/Instant;", "renderState", "Lclub/pisquad/minecraft/csgrenades/client/renderer/RenderState;", "render", "", "effectData", "Lclub/pisquad/minecraft/csgrenades/network/message/FlashbangEffectData;", "onPlaySound", "event", "Lnet/minecraftforge/client/event/sound/PlaySoundEvent;", "eventHandler", "Lnet/minecraftforge/client/event/RenderGuiOverlayEvent$Post;", "drawOverlay", "gui", "Lnet/minecraft/client/gui/GuiGraphics;", "opacity", "clean", "playRingSound", "csgrenades"})
public final class FlashbangBlindEffectRenderer {
    @NotNull
    public static final FlashbangBlindEffectRenderer INSTANCE = new FlashbangBlindEffectRenderer();
    private static int effectAttack;
    private static int effectSustain;
    private static int effectDecay;
    private static int effectAmount;
    @NotNull
    private static Instant renderStartTime;
    @NotNull
    private static RenderState renderState;

    private FlashbangBlindEffectRenderer() {
    }

    public final void render(@NotNull FlashbangEffectData effectData) {
        Intrinsics.checkNotNullParameter((Object)effectData, (String)"effectData");
        switch (WhenMappings.$EnumSwitchMapping$0[renderState.ordinal()]) {
            case 1: {
                renderStartTime = Instant.now();
                effectAttack = effectData.getEffectAttack();
                effectSustain = effectData.getEffectSustain();
                effectDecay = effectData.getEffectDecay();
                effectAmount = effectData.getEffectAmount();
                MinecraftForge.EVENT_BUS.register((Object)new Function1<RenderGuiOverlayEvent.Post, Unit>((Object)INSTANCE){

                    public final void invoke(RenderGuiOverlayEvent.Post p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((FlashbangBlindEffectRenderer)this.receiver).eventHandler(p0);
                    }
                });
                break;
            }
            case 2: 
            case 3: {
                effectAttack = Math.max(effectAttack, effectData.getEffectAttack());
                effectSustain = Math.max(effectSustain, effectData.getEffectSustain());
                effectDecay = Math.max(effectDecay, effectData.getEffectDecay());
                effectAmount = Math.max(effectAmount, effectData.getEffectAmount());
                break;
            }
            case 4: {
                renderStartTime = Instant.now().minus(Duration.ofMillis(effectData.getEffectAttack()));
                effectAttack = effectData.getEffectAttack();
                effectSustain = effectData.getEffectSustain();
                effectDecay = effectData.getEffectDecay();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.playRingSound(effectData);
    }

    @SubscribeEvent
    public final void onPlaySound(@NotNull PlaySoundEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (renderState == RenderState.IDLE) {
            return;
        }
        SoundInstance soundInstance = event.getSound();
        if (soundInstance == null) {
            return;
        }
        SoundInstance sound = soundInstance;
        if (sound instanceof FlashbangRingSound) {
            return;
        }
        if (Intrinsics.areEqual((Object)sound.m_7904_(), (Object)((SoundEvent)SoundEvents.f_12490_.get()).m_11660_())) {
            return;
        }
        Object object = ModSoundEvents.INSTANCE.getFLASHBANG_EXPLODE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        SoundEvent flashExplode = (SoundEvent)object;
        Object object2 = ModSoundEvents.INSTANCE.getFLASHBANG_EXPLODE_DISTANT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        SoundEvent flashExplodeDistant = (SoundEvent)object2;
        if (Intrinsics.areEqual((Object)sound.m_7904_(), (Object)flashExplode.m_11660_()) || Intrinsics.areEqual((Object)sound.m_7904_(), (Object)flashExplodeDistant.m_11660_())) {
            return;
        }
        event.setSound(null);
    }

    @SubscribeEvent
    public final void eventHandler(@NotNull RenderGuiOverlayEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        if (player.m_5833_()) {
            return;
        }
        Instant currentTime = Instant.now();
        double timeDelta = Duration.between(renderStartTime, currentTime).toMillis();
        if (timeDelta < (double)effectAttack) {
            int opacity = (int)(timeDelta / (double)effectAttack * (double)effectAmount);
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)guiGraphics, (String)"getGuiGraphics(...)");
            this.drawOverlay(guiGraphics, opacity);
            renderState = RenderState.AttackStage;
        } else if (timeDelta < (double)(effectSustain + effectAttack)) {
            int opacity = effectAmount;
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)guiGraphics, (String)"getGuiGraphics(...)");
            this.drawOverlay(guiGraphics, opacity);
            renderState = RenderState.SustainStage;
        } else if (timeDelta < (double)(effectDecay + effectSustain + effectAttack)) {
            int opacity = effectAmount - (int)((timeDelta - (double)effectAttack - (double)effectSustain) / (double)effectDecay * (double)effectAmount);
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)guiGraphics, (String)"getGuiGraphics(...)");
            this.drawOverlay(guiGraphics, opacity);
            renderState = RenderState.DecayStage;
        } else {
            this.clean();
        }
    }

    private final void drawOverlay(GuiGraphics gui, int opacity) {
        gui.m_280509_(0, 0, gui.m_280182_(), gui.m_280206_(), FastColor.ABGR32.m_266248_((int)opacity, (int)255, (int)255, (int)255));
    }

    private final void clean() {
        effectAttack = 0;
        effectDecay = 0;
        effectSustain = 0;
        effectAmount = 0;
        renderState = RenderState.IDLE;
        MinecraftForge.EVENT_BUS.unregister((Object)new Function1<RenderGuiOverlayEvent.Post, Unit>((Object)INSTANCE){

            public final void invoke(RenderGuiOverlayEvent.Post p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((FlashbangBlindEffectRenderer)this.receiver).eventHandler(p0);
            }
        });
    }

    private final void playRingSound(FlashbangEffectData effectData) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        Intrinsics.checkNotNull((Object)localPlayer);
        double distance = Math.sqrt(localPlayer.m_20238_(effectData.getPosition()));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new FlashbangRingSound(0, effectSustain, effectDecay + 300, (float)SoundUtils.INSTANCE.getVolumeFromDistance(distance, SoundTypes.FLASHBANG_RING), null, 16, null));
    }

    static {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        renderStartTime = instant;
        renderState = RenderState.IDLE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RenderState.values().length];
            try {
                nArray[RenderState.IDLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderState.AttackStage.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderState.SustainStage.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenderState.DecayStage.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

