/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.client.renderer;

import club.pisquad.minecraft.csgrenades.UtilsKt;
import club.pisquad.minecraft.csgrenades.config.ModConfig;
import club.pisquad.minecraft.csgrenades.entity.SmokeGrenadeEntity;
import club.pisquad.minecraft.csgrenades.particle.SmokeGrenadeParticle;
import club.pisquad.minecraft.csgrenades.registery.ModParticles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001d\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lclub/pisquad/minecraft/csgrenades/client/renderer/SmokeRenderer;", "", "particleEngine", "Lnet/minecraft/client/particle/ParticleEngine;", "center", "Lnet/minecraft/world/phys/Vec3;", "smokeEntity", "Lclub/pisquad/minecraft/csgrenades/entity/SmokeGrenadeEntity;", "<init>", "(Lnet/minecraft/client/particle/ParticleEngine;Lnet/minecraft/world/phys/Vec3;Lclub/pisquad/minecraft/csgrenades/entity/SmokeGrenadeEntity;)V", "done", "", "getDone", "()Z", "setDone", "(Z)V", "tickCount", "", "randomSource", "Lnet/minecraft/util/RandomSource;", "kotlin.jvm.PlatformType", "Lnet/minecraft/util/RandomSource;", "blockPerTickDistanceRatio", "", "particlePerBlock", "rendered", "renderBlockPos", "", "Lnet/minecraft/core/BlockPos;", "update", "", "csgrenades"})
@SourceDebugExtension(value={"SMAP\nSmokeRenderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmokeRenderManager.kt\nclub/pisquad/minecraft/csgrenades/client/renderer/SmokeRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1010#2,2:126\n*S KotlinDebug\n*F\n+ 1 SmokeRenderManager.kt\nclub/pisquad/minecraft/csgrenades/client/renderer/SmokeRenderer\n*L\n86#1:126,2\n*E\n"})
public final class SmokeRenderer {
    @NotNull
    private final ParticleEngine particleEngine;
    @NotNull
    private final Vec3 center;
    @NotNull
    private final SmokeGrenadeEntity smokeEntity;
    private boolean done;
    private int tickCount;
    private final RandomSource randomSource;
    private final double blockPerTickDistanceRatio;
    private final int particlePerBlock;
    private boolean rendered;
    @NotNull
    private List<BlockPos> renderBlockPos;

    public SmokeRenderer(@NotNull ParticleEngine particleEngine, @NotNull Vec3 center, @NotNull SmokeGrenadeEntity smokeEntity) {
        Intrinsics.checkNotNullParameter((Object)particleEngine, (String)"particleEngine");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)smokeEntity, (String)"smokeEntity");
        this.particleEngine = particleEngine;
        this.center = center;
        this.smokeEntity = smokeEntity;
        this.randomSource = RandomSource.m_216343_();
        this.blockPerTickDistanceRatio = 0.5;
        this.particlePerBlock = 5;
        this.renderBlockPos = new ArrayList();
    }

    public final boolean getDone() {
        return this.done;
    }

    public final void setDone(boolean bl) {
        this.done = bl;
    }

    public final void update() {
        int n = this.tickCount;
        this.tickCount = n + 1;
        long l = this.tickCount;
        Object object = ModConfig.SmokeGrenade.INSTANCE.getSMOKE_LIFETIME().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (l > UtilsKt.millToTick(((Number)object).longValue())) {
            this.done = true;
            return;
        }
        if (!this.rendered) {
            this.renderBlockPos = CollectionsKt.toMutableList((Collection)this.smokeEntity.getSpreadBlocks());
            if (!((Collection)this.renderBlockPos).isEmpty()) {
                List<BlockPos> $this$sortBy$iv = this.renderBlockPos;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(this){
                        final /* synthetic */ SmokeRenderer this$0;
                        {
                            this.this$0 = smokeRenderer;
                        }

                        public final int compare(T a, T b) {
                            BlockPos it = (BlockPos)a;
                            boolean bl = false;
                            Comparable comparable = Double.valueOf(it.m_123331_(UtilsKt.toVec3i(SmokeRenderer.access$getCenter$p(this.this$0))));
                            it = (BlockPos)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.m_123331_(UtilsKt.toVec3i(SmokeRenderer.access$getCenter$p(this.this$0)))));
                        }
                    });
                }
                this.rendered = true;
            } else {
                return;
            }
        }
        if (this.renderBlockPos.isEmpty()) {
            this.done = true;
            return;
        }
        int blockPerTick = (int)(this.renderBlockPos.get(0).m_123331_(UtilsKt.toVec3i(this.center)) * (1.0 + this.blockPerTickDistanceRatio)) + 1;
        for (int i = 0; i < blockPerTick; ++i) {
            int blockCount = i;
            boolean bl = false;
            if (this.renderBlockPos.isEmpty()) {
                this.done = true;
                return;
            }
            Vec3 position = UtilsKt.toVec3(this.renderBlockPos.get(0));
            int n2 = this.particlePerBlock;
            for (int j = 0; j < n2; ++j) {
                int particleCount = j;
                boolean bl2 = false;
                Vec3 shuffledPosition = position.m_272010_(this.randomSource, 1.0f);
                Particle particle = this.particleEngine.m_107370_((ParticleOptions)ModParticles.INSTANCE.getSMOKE_PARTICLE().get(), shuffledPosition.f_82479_, shuffledPosition.f_82480_, shuffledPosition.f_82481_, 0.0, 0.0, 0.0);
                if (particle == null) continue;
                this.smokeEntity.registerParticle((SmokeGrenadeParticle)particle);
            }
            this.renderBlockPos.remove(0);
        }
    }

    public static final /* synthetic */ Vec3 access$getCenter$p(SmokeRenderer $this) {
        return $this.center;
    }
}

