/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.command;

import club.pisquad.minecraft.csgrenades.config.ModConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lclub/pisquad/minecraft/csgrenades/command/SetConfigCommand;", "", "<init>", "()V", "register", "", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "setGlobalIgnoreBarrier", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "value", "", "setGrenadeSpecificConfig", "grenadeType", "", "csgrenades"})
@SourceDebugExtension(value={"SMAP\nSetConfigCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetConfigCommand.kt\nclub/pisquad/minecraft/csgrenades/command/SetConfigCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1863#2,2:97\n*S KotlinDebug\n*F\n+ 1 SetConfigCommand.kt\nclub/pisquad/minecraft/csgrenades/command/SetConfigCommand\n*L\n29#1:97,2\n*E\n"})
public final class SetConfigCommand {
    @NotNull
    public static final SetConfigCommand INSTANCE = new SetConfigCommand();

    private SetConfigCommand() {
    }

    public final void register(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        ArgumentBuilder argumentBuilder = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"csgrenades").requires(SetConfigCommand::register$lambda$0)).then(Commands.m_82129_((String)"grenadeType", (ArgumentType)((ArgumentType)StringArgumentType.string())).suggests(SetConfigCommand::register$lambda$1).then(Commands.m_82127_((String)"causeDamageToOwner").then(Commands.m_82129_((String)"value", (ArgumentType)((ArgumentType)StringArgumentType.string())).suggests(SetConfigCommand::register$lambda$3).executes(SetConfigCommand::register$lambda$4))))).then(Commands.m_82127_((String)"global").then(Commands.m_82127_((String)"ignoreBarrierBlock").then(Commands.m_82129_((String)"value", (ArgumentType)((ArgumentType)BoolArgumentType.bool())).executes(SetConfigCommand::register$lambda$5))));
        Intrinsics.checkNotNullExpressionValue((Object)argumentBuilder, (String)"then(...)");
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)argumentBuilder;
        dispatcher.register(command);
    }

    private final int setGlobalIgnoreBarrier(CommandContext<CommandSourceStack> context, boolean value) {
        ModConfig.INSTANCE.getIGNORE_BARRIER_BLOCK().set((Object)value);
        ModConfig.INSTANCE.getSPEC().save();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> SetConfigCommand.setGlobalIgnoreBarrier$lambda$6(value), true);
        return 1;
    }

    private final int setGrenadeSpecificConfig(CommandContext<CommandSourceStack> context, String grenadeType, String value) {
        ForgeConfigSpec.EnumValue<ModConfig.SelfDamageSetting> enumValue;
        ModConfig.SelfDamageSetting selfDamageSetting;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            String string = value.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            selfDamageSetting = ModConfig.SelfDamageSetting.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            source.m_81352_((Component)Component.m_237113_((String)("Invalid value '" + value + "'. Must be one of: never, not_in_team, always.")));
            return 0;
        }
        ModConfig.SelfDamageSetting configValue = selfDamageSetting;
        String string = grenadeType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = string;
        if (Intrinsics.areEqual((Object)string2, (Object)"hegrenade")) {
            enumValue = ModConfig.HEGrenade.INSTANCE.getCAUSE_DAMAGE_TO_OWNER();
        } else if (Intrinsics.areEqual((Object)string2, (Object)"firegrenade")) {
            enumValue = ModConfig.FireGrenade.INSTANCE.getCAUSE_DAMAGE_TO_OWNER();
        } else {
            source.m_81352_((Component)Component.m_237113_((String)("Invalid grenade type '" + grenadeType + "'. Must be 'hegrenade' or 'firegrenade'.")));
            return 0;
        }
        ForgeConfigSpec.EnumValue<ModConfig.SelfDamageSetting> configToChange = enumValue;
        configToChange.set((Object)configValue);
        ModConfig.INSTANCE.getSPEC().save();
        source.m_288197_(() -> SetConfigCommand.setGrenadeSpecificConfig$lambda$7(grenadeType, value), true);
        return 1;
    }

    private static final boolean register$lambda$0(CommandSourceStack source) {
        return source.m_6761_(2);
    }

    private static final CompletableFuture register$lambda$1(CommandContext commandContext, SuggestionsBuilder builder) {
        builder.suggest("hegrenade");
        builder.suggest("firegrenade");
        return builder.buildFuture();
    }

    private static final CompletableFuture register$lambda$3(CommandContext commandContext, SuggestionsBuilder builder) {
        Iterable $this$forEach$iv = (Iterable)ModConfig.SelfDamageSetting.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModConfig.SelfDamageSetting it = (ModConfig.SelfDamageSetting)((Object)element$iv);
            boolean bl = false;
            String string = it.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            builder.suggest(string);
        }
        return builder.buildFuture();
    }

    private static final int register$lambda$4(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        String string = StringArgumentType.getString((CommandContext)context, (String)"grenadeType");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = StringArgumentType.getString((CommandContext)context, (String)"value");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        return INSTANCE.setGrenadeSpecificConfig((CommandContext<CommandSourceStack>)context, string, string2);
    }

    private static final int register$lambda$5(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.setGlobalIgnoreBarrier((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"value"));
    }

    private static final Component setGlobalIgnoreBarrier$lambda$6(boolean $value) {
        return (Component)Component.m_237113_((String)("Set global ignoreBarrierBlock to " + $value));
    }

    private static final Component setGrenadeSpecificConfig$lambda$7(String $grenadeType, String $value) {
        Intrinsics.checkNotNullParameter((Object)$grenadeType, (String)"$grenadeType");
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        return (Component)Component.m_237113_((String)("Set " + $grenadeType + " causeDamageToOwner to " + $value));
    }
}

