/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.compatibility;

import club.pisquad.minecraft.csgrenades.compatibility.ModObjectives;
import com.mojang.brigadier.CommandDispatcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.scores.Scoreboard;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nJ&\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0002J4\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\u0012"}, d2={"Lclub/pisquad/minecraft/csgrenades/compatibility/ObjectiveManager;", "", "<init>", "()V", "initAllObjectives", "", "scoreboard", "Lnet/minecraft/world/scores/Scoreboard;", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "commandSource", "removeObjective", "objective", "Lclub/pisquad/minecraft/csgrenades/compatibility/ModObjectives;", "increaseObjective", "player", "", "csgrenades"})
public final class ObjectiveManager {
    @NotNull
    public static final ObjectiveManager INSTANCE = new ObjectiveManager();

    private ObjectiveManager() {
    }

    public final void initAllObjectives(@NotNull Scoreboard scoreboard, @NotNull CommandDispatcher<CommandSourceStack> dispatcher, @NotNull CommandSourceStack commandSource) {
        Intrinsics.checkNotNullParameter((Object)scoreboard, (String)"scoreboard");
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)commandSource, (String)"commandSource");
        for (ModObjectives objective : ModObjectives.getEntries()) {
            if (scoreboard.m_83477_(objective.getObjectiveName()) != null) {
                this.removeObjective(objective, dispatcher, commandSource);
            }
            dispatcher.execute("scoreboard objectives add " + objective.getObjectiveName() + " dummy", (Object)commandSource);
        }
    }

    private final void removeObjective(ModObjectives objective, CommandDispatcher<CommandSourceStack> dispatcher, CommandSourceStack commandSource) {
        dispatcher.execute("scoreboard objectives remove " + objective.getObjectiveName(), (Object)commandSource.m_81324_());
    }

    public final void increaseObjective(@NotNull String player, @NotNull Scoreboard scoreboard, @NotNull ModObjectives objective, @NotNull CommandDispatcher<CommandSourceStack> dispatcher, @NotNull CommandSourceStack commandSource) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scoreboard, (String)"scoreboard");
        Intrinsics.checkNotNullParameter((Object)((Object)objective), (String)"objective");
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)commandSource, (String)"commandSource");
        if (scoreboard.m_83477_(objective.getObjectiveName()) != null) {
            v0 = dispatcher.execute("scoreboard players add " + player + " " + objective.getObjectiveName() + " 1", (Object)commandSource.m_81324_());
        } else {
            dispatcher.execute("scoreboard objectives add " + objective.getObjectiveName() + " dummy", (Object)commandSource.m_81324_());
            v0 = dispatcher.execute("scoreboard players add " + player + " " + objective.getObjectiveName() + " 1", (Object)commandSource.m_81324_());
        }
    }
}

