/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.entity;

import club.pisquad.minecraft.csgrenades.UtilsKt;
import club.pisquad.minecraft.csgrenades.client.renderer.FireGrenadeRenderer;
import club.pisquad.minecraft.csgrenades.config.ModConfig;
import club.pisquad.minecraft.csgrenades.entity.CounterStrikeGrenadeEntity;
import club.pisquad.minecraft.csgrenades.entity.FireSpreadCalculator;
import club.pisquad.minecraft.csgrenades.entity.SmokeGrenadeEntity;
import club.pisquad.minecraft.csgrenades.enums.GrenadeType;
import club.pisquad.minecraft.csgrenades.network.CsGrenadePacketHandler;
import club.pisquad.minecraft.csgrenades.network.message.FireGrenadeMessage;
import club.pisquad.minecraft.csgrenades.registery.ModSerializers;
import club.pisquad.minecraft.csgrenades.registery.ModSoundEvents;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 02\u00020\u0001:\u00010B'\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u000eH\u0002J\u0006\u0010$\u001a\u00020\u001eJ\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H&J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020'0&H&J\b\u0010)\u001a\u00020\u001eH\u0002J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.H\u0002J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00120+R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lclub/pisquad/minecraft/csgrenades/entity/AbstractFireGrenade;", "Lclub/pisquad/minecraft/csgrenades/entity/CounterStrikeGrenadeEntity;", "pEntityType", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/projectile/ThrowableItemProjectile;", "pLevel", "Lnet/minecraft/world/level/Level;", "grenadeType", "Lclub/pisquad/minecraft/csgrenades/enums/GrenadeType;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Lclub/pisquad/minecraft/csgrenades/enums/GrenadeType;)V", "explosionTick", "", "extinguished", "", "poppedInAir", "spreadBlocks", "", "Lnet/minecraft/core/BlockPos;", "entitiesLastInRange", "", "Ljava/util/UUID;", "", "lastInWater", "hasSavedFinalRotation", "finalXRot", "", "finalYRot", "finalZRot", "defineSynchedData", "", "tick", "onHitBlock", "result", "Lnet/minecraft/world/phys/BlockHitResult;", "isCurrentInWater", "extinguish", "getFireDamageType", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/damagesource/DamageType;", "getSelfFireDamageType", "doDamage", "calculateSpreadBlocks", "", "level", "center", "Lnet/minecraft/world/phys/Vec3;", "getSpreadBlocks", "Companion", "csgrenades"})
@SourceDebugExtension(value={"SMAP\nAbstractFireGrenade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractFireGrenade.kt\nclub/pisquad/minecraft/csgrenades/entity/AbstractFireGrenade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,389:1\n1755#2,3:390\n774#2:393\n865#2:394\n1755#2,3:395\n866#2:398\n1755#2,3:402\n1863#2,2:409\n535#3:399\n520#3,2:400\n522#3,4:405\n*S KotlinDebug\n*F\n+ 1 AbstractFireGrenade.kt\nclub/pisquad/minecraft/csgrenades/entity/AbstractFireGrenade\n*L\n160#1:390,3\n213#1:393\n213#1:394\n214#1:395,3\n213#1:398\n224#1:402,3\n232#1:409,2\n224#1:399\n224#1:400,2\n224#1:405,4\n*E\n"})
public abstract class AbstractFireGrenade
extends CounterStrikeGrenadeEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int explosionTick;
    private boolean extinguished;
    private boolean poppedInAir;
    @NotNull
    private List<BlockPos> spreadBlocks;
    @NotNull
    private Map<UUID, Long> entitiesLastInRange;
    private boolean lastInWater;
    private boolean hasSavedFinalRotation;
    private float finalXRot;
    private float finalYRot;
    private float finalZRot;
    @NotNull
    private static final EntityDataAccessor<List<BlockPos>> spreadBlocksAccessor;

    public AbstractFireGrenade(@NotNull EntityType<? extends ThrowableItemProjectile> pEntityType, @NotNull Level pLevel, @NotNull GrenadeType grenadeType) {
        Intrinsics.checkNotNullParameter(pEntityType, (String)"pEntityType");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)((Object)grenadeType), (String)"grenadeType");
        super(pEntityType, pLevel, grenadeType);
        this.spreadBlocks = new ArrayList();
        this.entitiesLastInRange = new LinkedHashMap();
        this.setHitBlockSound((SoundEvent)ModSoundEvents.INSTANCE.getINCENDIARY_BOUNCE().get());
        this.setThrowSound((SoundEvent)ModSoundEvents.INSTANCE.getINCENDIARY_THROW().get());
        this.lastInWater = this.isCurrentInWater();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(spreadBlocksAccessor, (Object)CollectionsKt.emptyList());
    }

    @Override
    public void m_8119_() {
        Boolean isExploded = (Boolean)this.f_19804_.m_135370_(CounterStrikeGrenadeEntity.Companion.isExplodedAccessor());
        if (isExploded.booleanValue()) {
            if (this.m_9236_().f_46443_) {
                if (!this.hasSavedFinalRotation) {
                    this.finalXRot = this.m_146909_();
                    this.finalYRot = this.m_146908_();
                    this.finalZRot = this.getZRot();
                    this.hasSavedFinalRotation = true;
                }
                this.m_146926_(this.finalXRot);
                this.m_146922_(this.finalYRot);
                this.setZRot(this.finalZRot);
                this.f_19860_ = this.finalXRot;
                this.f_19859_ = this.finalYRot;
                this.setZRotO(this.finalZRot);
            }
        } else {
            super.m_8119_();
        }
        if (this.m_9236_().f_46443_) {
            if (!this.poppedInAir && isExploded.booleanValue()) {
                FireGrenadeRenderer.INSTANCE.renderOne(this);
            }
        } else if (isExploded.booleanValue()) {
            this.doDamage();
            long l = this.f_19797_ - this.explosionTick;
            Object object = ModConfig.FireGrenade.INSTANCE.getLIFETIME().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            if (l > UtilsKt.millToTick(((Number)object).longValue())) {
                this.m_6074_();
                return;
            }
        } else if ((long)this.f_19797_ > ((Number)ModConfig.FireGrenade.INSTANCE.getFUSE_TIME().get()).longValue() / (long)50) {
            this.f_19804_.m_135381_(CounterStrikeGrenadeEntity.Companion.isExplodedAccessor(), (Object)true);
            this.poppedInAir = true;
            SimpleChannel simpleChannel = CsGrenadePacketHandler.INSTANCE.getINSTANCE();
            PacketDistributor.PacketTarget packetTarget = PacketDistributor.ALL.noArg();
            Vec3 vec3 = this.m_20182_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            simpleChannel.send(packetTarget, (Object)new FireGrenadeMessage(FireGrenadeMessage.MessageType.AirExploded, vec3));
            this.m_6074_();
        }
        if (!isExploded.booleanValue()) {
            if (!this.lastInWater) {
                Vec3 vec3 = this.m_20184_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getDeltaMovement(...)");
                if (UtilsKt.snapToAxis(vec3) == Direction.DOWN) {
                    boolean isNextBlockPosInWater;
                    Vec3 nextPosition = this.m_20182_().m_82549_(this.m_20184_());
                    BlockPos nextBlockPos = BlockPos.m_274446_((Position)((Position)nextPosition));
                    boolean bl = isNextBlockPosInWater = !this.m_9236_().m_8055_(nextBlockPos).m_60819_().m_76178_();
                    if (isNextBlockPosInWater) {
                        this.m_8060_(new BlockHitResult(nextPosition, Direction.UP, nextBlockPos, false));
                        this.m_20256_(Vec3.f_82478_);
                    }
                }
            }
            this.lastInWater = this.isCurrentInWater();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void m_8060_(@NotNull BlockHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (((Boolean)this.f_19804_.m_135370_(CounterStrikeGrenadeEntity.Companion.isExplodedAccessor())).booleanValue() || ((Boolean)this.f_19804_.m_135370_(CounterStrikeGrenadeEntity.Companion.isLandedAccessor())).booleanValue()) {
            return;
        }
        if (this.extinguished) {
            return;
        }
        if (result.m_82434_() == Direction.UP) {
            this.m_20256_(Vec3.f_82478_);
            this.explosionTick = this.f_19797_;
            this.m_20242_(true);
            if (!this.m_9236_().f_46443_) {
                boolean bl;
                block9: {
                    void $this$any$iv;
                    this.f_19804_.m_135381_(CounterStrikeGrenadeEntity.Companion.isExplodedAccessor(), (Object)true);
                    this.f_19804_.m_135381_(CounterStrikeGrenadeEntity.Companion.isLandedAccessor(), (Object)true);
                    double smokeRadius = ((Number)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_RADIUS().get()).intValue();
                    AABB bb = new AABB(this.m_20183_()).m_82377_(smokeRadius, (double)((Number)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_MAX_FALLING_HEIGHT().get()).intValue(), smokeRadius);
                    double fireExtinguishRange = ((Number)ModConfig.FireGrenade.INSTANCE.getFIRE_EXTINGUISH_RANGE().get()).intValue();
                    List list = this.m_9236_().m_6443_(SmokeGrenadeEntity.class, bb, arg_0 -> AbstractFireGrenade.onHitBlock$lambda$1(arg_0 -> AbstractFireGrenade.onHitBlock$lambda$0(this, fireExtinguishRange, arg_0), arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
                    Iterable iterable = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            SmokeGrenadeEntity it = (SmokeGrenadeEntity)element$iv;
                            boolean bl2 = false;
                            Vec3 vec3 = this.m_20182_();
                            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                            if (!it.canDistinguishFire(vec3)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    this.extinguished = true;
                } else {
                    this.m_146884_(result.m_82425_().m_252807_().m_82549_(new Vec3(0.0, 0.75, 0.0)));
                    Level level = this.m_9236_();
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
                    Vec3 vec3 = this.m_20182_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                    this.f_19804_.m_135381_(spreadBlocksAccessor, this.calculateSpreadBlocks(level, vec3));
                    SimpleChannel simpleChannel = CsGrenadePacketHandler.INSTANCE.getINSTANCE();
                    PacketDistributor.PacketTarget packetTarget = PacketDistributor.ALL.noArg();
                    Vec3 vec32 = this.m_20182_();
                    Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"position(...)");
                    simpleChannel.send(packetTarget, (Object)new FireGrenadeMessage(FireGrenadeMessage.MessageType.GroundExploded, vec32));
                }
            }
            return;
        }
        super.m_8060_(result);
    }

    private final boolean isCurrentInWater() {
        return !this.m_9236_().m_8055_(this.m_20183_()).m_60819_().m_76178_();
    }

    public final void extinguish() {
        this.extinguished = true;
        SimpleChannel simpleChannel = CsGrenadePacketHandler.INSTANCE.getINSTANCE();
        PacketDistributor.PacketTarget packetTarget = PacketDistributor.ALL.noArg();
        Vec3 vec3 = this.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        simpleChannel.send(packetTarget, (Object)new FireGrenadeMessage(FireGrenadeMessage.MessageType.ExtinguishedBySmoke, vec3));
        this.m_6074_();
    }

    @NotNull
    public abstract ResourceKey<DamageType> getFireDamageType();

    @NotNull
    public abstract ResourceKey<DamageType> getSelfFireDamageType();

    /*
     * Unable to fully structure code
     */
    private final void doDamage() {
        v0 = this.m_9236_();
        Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        level = (ServerLevel)v0;
        v1 = (List)this.f_19804_.m_135370_(AbstractFireGrenade.spreadBlocksAccessor);
        if (v1 == null) {
            return;
        }
        spreadBlocks = v1;
        v2 = (Boolean)ModConfig.INSTANCE.getDAMAGE_NON_PLAYER_ENTITY().get() != false ? LivingEntity.class : Player.class;
        v3 = new AABB(this.m_20183_());
        v4 = ModConfig.HEGrenade.INSTANCE.getDAMAGE_RANGE().get();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"get(...)");
        entities = level.m_45976_(v2, v3.m_82400_(((Number)v4).doubleValue()));
        Intrinsics.checkNotNull((Object)entities);
        $this$filter$iv = entities;
        $i$f$filter = false;
        var7_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var10_11 = $this$filterTo$iv$iv.iterator();
        while (var10_11.hasNext()) {
            block18: {
                block20: {
                    element$iv$iv = var10_11.next();
                    entity = (LivingEntity)element$iv$iv;
                    $i$a$-filter-AbstractFireGrenade$doDamage$entitiesInRange$1 = false;
                    $this$any$iv = spreadBlocks;
                    $i$f$any = false;
                    if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block20;
                    v5 = false;
                    break block18;
                }
                for (T element$iv : $this$any$iv) {
                    blockPos = (BlockPos)element$iv;
                    $i$a$-any-AbstractFireGrenade$doDamage$entitiesInRange$1$1 = false;
                    v6 = blockPos.m_7494_().m_252807_();
                    Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getCenter(...)");
                    v7 = entity.m_20182_();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"position(...)");
                    if (!(UtilsKt.horizontalDistanceTo(v6, v7) < 1.0) || !(entity.m_20186_() < (double)blockPos.m_123342_() + 2.8) || !(entity.m_20186_() > (double)blockPos.m_123342_() - 2.8)) ** GOTO lbl-1000
                    v8 = this.m_9236_();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"level(...)");
                    v9 = entity.m_20182_();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"position(...)");
                    if (!UtilsKt.isPositionInSmoke(v8, v9)) {
                        v10 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v10 = false;
                    }
                    if (!v10) continue;
                    v5 = true;
                    break block18;
                }
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        entitiesInRange = (List)destination$iv$iv;
        $this$filter$iv = this.entitiesLastInRange;
        var20_28 = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var10_11 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var10_11.hasNext()) {
            block19: {
                dataPair = element$iv$iv = (Map.Entry)var10_11.next();
                $i$a$-filter-AbstractFireGrenade$doDamage$1 = false;
                $this$any$iv = entitiesInRange;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v11 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        entity = (LivingEntity)element$iv;
                        $i$a$-any-AbstractFireGrenade$doDamage$1$1 = false;
                        if (!Intrinsics.areEqual(dataPair.getKey(), (Object)entity.m_20148_())) continue;
                        v11 = true;
                        break block19;
                    }
                    v11 = false;
                }
            }
            if (!v11) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        var20_28.entitiesLastInRange = MapsKt.toMutableMap((Map)destination$iv$iv);
        timeNow = Instant.now().toEpochMilli();
        damageTypeHolder = level.m_9598_().m_255025_(Registries.f_268580_).m_255043_(this.getFireDamageType());
        selfDamageTypeHolder = level.m_9598_().m_255025_(Registries.f_268580_).m_255043_(this.getSelfFireDamageType());
        $this$forEach$iv = entitiesInRange;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block22: {
                block21: {
                    entity = (LivingEntity)element$iv;
                    $i$a$-forEach-AbstractFireGrenade$doDamage$2 = false;
                    if (!Intrinsics.areEqual((Object)entity, (Object)this.m_19749_())) break block21;
                    v12 = (ModConfig.SelfDamageSetting)ModConfig.FireGrenade.INSTANCE.getCAUSE_DAMAGE_TO_OWNER().get();
                    switch (v12 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v12.ordinal()]) {
                        case 1: {
                            v13 = null;
                            break block22;
                        }
                        case 2: {
                            v13 = new DamageSource((Holder)damageTypeHolder, (Entity)this, this.m_19749_());
                            break block22;
                        }
                        case 3: {
                            v13 = new DamageSource((Holder)selfDamageTypeHolder);
                            break block22;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                v13 = new DamageSource((Holder)damageTypeHolder, (Entity)this, this.m_19749_());
            }
            if ((finalDamageSource = v13) == null || entity.f_19802_ > 0) continue;
            damage = (float)((Number)ModConfig.FireGrenade.INSTANCE.getDAMAGE().get()).doubleValue();
            if (this.entitiesLastInRange.keySet().contains(entity.m_20148_())) {
                v14 = damage;
                v15 = this.entitiesLastInRange.get(entity.m_20148_());
                Intrinsics.checkNotNull((Object)v15);
                damage = Math.min(damage, (float)UtilsKt.linearInterpolate(0.0, v14, (double)(timeNow - ((Number)v15).longValue()) / (double)((Number)ModConfig.FireGrenade.INSTANCE.getDAMAGE_INCREASE_TIME().get()).longValue()));
            } else {
                damage = 0.1f;
                var17_23 = timeNow;
                this.entitiesLastInRange.put(entity.m_20148_(), var17_23);
            }
            v16 = entity.m_21051_(Attributes.f_22278_);
            originalKnockBackResistance = v16 != null ? v16.m_22115_() : 0.0;
            v17 = entity.m_21051_(Attributes.f_22278_);
            if (v17 != null) {
                v17.m_22100_(1.0);
            }
            entity.m_6469_(finalDamageSource, damage);
            entity.f_19802_ = 10;
            v18 = entity.m_21051_(Attributes.f_22278_);
            if (v18 == null) continue;
            v18.m_22100_(originalKnockBackResistance);
        }
    }

    private final List<BlockPos> calculateSpreadBlocks(Level level, Vec3 center) {
        BlockPos blockPos = BlockPos.m_274446_((Position)((Position)center)).m_7495_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"below(...)");
        return FireSpreadCalculator.INSTANCE.calculate(level, blockPos);
    }

    @NotNull
    public final List<BlockPos> getSpreadBlocks() {
        if (this.spreadBlocks.isEmpty()) {
            Object object = this.f_19804_.m_135370_(spreadBlocksAccessor);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this.spreadBlocks.addAll((Collection)object);
        }
        return this.spreadBlocks;
    }

    private static final boolean onHitBlock$lambda$0(AbstractFireGrenade this$0, double $fireExtinguishRange, SmokeGrenadeEntity it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.m_20182_().m_82554_(it.m_20182_()) < $fireExtinguishRange;
    }

    private static final boolean onHitBlock$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(AbstractFireGrenade.class, (EntityDataSerializer)ModSerializers.INSTANCE.getBlockPosListEntityDataSerializer());
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        spreadBlocksAccessor = entityDataAccessor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lclub/pisquad/minecraft/csgrenades/entity/AbstractFireGrenade$Companion;", "", "<init>", "()V", "spreadBlocksAccessor", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "Lnet/minecraft/core/BlockPos;", "getSpreadBlocksAccessor", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "csgrenades"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<List<BlockPos>> getSpreadBlocksAccessor() {
            return spreadBlocksAccessor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModConfig.SelfDamageSetting.values().length];
            try {
                nArray[ModConfig.SelfDamageSetting.NEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModConfig.SelfDamageSetting.NOT_IN_TEAM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModConfig.SelfDamageSetting.ALWAYS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

