/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.entity;

import club.pisquad.minecraft.csgrenades.SoundTypes;
import club.pisquad.minecraft.csgrenades.SoundUtils;
import club.pisquad.minecraft.csgrenades.UtilsKt;
import club.pisquad.minecraft.csgrenades.config.ModConfig;
import club.pisquad.minecraft.csgrenades.entity.GrenadeEntityInterface;
import club.pisquad.minecraft.csgrenades.enums.GrenadeType;
import club.pisquad.minecraft.csgrenades.registery.ModSoundEvents;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrierBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 F2\u00020\u00012\u00020\u0002:\u0001FB'\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010)\u001a\u00020*H\u0014J0\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\u001e2\u0006\u00101\u001a\u00020\u001eH\u0016J\u0010\u00102\u001a\u00020*2\u0006\u00103\u001a\u000204H\u0014J\b\u00105\u001a\u00020*H\u0016J\b\u00106\u001a\u00020*H\u0016J\u0010\u00107\u001a\u00020*2\u0006\u00103\u001a\u000208H\u0014J\b\u00109\u001a\u00020*H\u0002J \u0010:\u001a\u00020*2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\u001eH\u0002J\b\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020@H\u0016J\u0010\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH&R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001f\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001f\u0010\u0014\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%\u00a8\u0006G"}, d2={"Lclub/pisquad/minecraft/csgrenades/entity/CounterStrikeGrenadeEntity;", "Lnet/minecraft/world/entity/projectile/ThrowableItemProjectile;", "Lclub/pisquad/minecraft/csgrenades/entity/GrenadeEntityInterface;", "pEntityType", "Lnet/minecraft/world/entity/EntityType;", "pLevel", "Lnet/minecraft/world/level/Level;", "grenadeType", "Lclub/pisquad/minecraft/csgrenades/enums/GrenadeType;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Lclub/pisquad/minecraft/csgrenades/enums/GrenadeType;)V", "getGrenadeType", "()Lclub/pisquad/minecraft/csgrenades/enums/GrenadeType;", "hitBlockSound", "Lnet/minecraft/sounds/SoundEvent;", "Lorg/jetbrains/annotations/NotNull;", "getHitBlockSound", "()Lnet/minecraft/sounds/SoundEvent;", "setHitBlockSound", "(Lnet/minecraft/sounds/SoundEvent;)V", "throwSound", "getThrowSound", "setThrowSound", "lastHitEntity", "Ljava/util/UUID;", "getLastHitEntity", "()Ljava/util/UUID;", "setLastHitEntity", "(Ljava/util/UUID;)V", "xRotSpeed", "", "yRotSpeed", "zRotSpeed", "zRot", "getZRot", "()F", "setZRot", "(F)V", "zRotO", "getZRotO", "setZRotO", "defineSynchedData", "", "shoot", "x", "", "y", "z", "pVelocity", "pInaccuracy", "onHitEntity", "result", "Lnet/minecraft/world/phys/EntityHitResult;", "tick", "onAddedToWorld", "onHitBlock", "Lnet/minecraft/world/phys/BlockHitResult;", "randomizeRotation", "bounce", "direction", "Lnet/minecraft/core/Direction;", "speedCoefficient", "frictionFactor", "isOnFire", "", "shouldBeSaved", "getHitDamageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "hitEntity", "Lnet/minecraft/world/entity/LivingEntity;", "Companion", "csgrenades"})
public abstract class CounterStrikeGrenadeEntity
extends ThrowableItemProjectile
implements GrenadeEntityInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GrenadeType grenadeType;
    @NotNull
    private SoundEvent hitBlockSound;
    @NotNull
    private SoundEvent throwSound;
    @Nullable
    private UUID lastHitEntity;
    private float xRotSpeed;
    private float yRotSpeed;
    private float zRotSpeed;
    private float zRot;
    private float zRotO;
    @NotNull
    private static final EntityDataAccessor<Float> speedAccessor;
    @NotNull
    private static final EntityDataAccessor<Boolean> isLandedAccessor;
    @NotNull
    private static final EntityDataAccessor<Boolean> isExplodedAccessor;

    public CounterStrikeGrenadeEntity(@NotNull EntityType<? extends ThrowableItemProjectile> pEntityType, @NotNull Level pLevel, @NotNull GrenadeType grenadeType) {
        Intrinsics.checkNotNullParameter(pEntityType, (String)"pEntityType");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        Intrinsics.checkNotNullParameter((Object)((Object)grenadeType), (String)"grenadeType");
        super(pEntityType, pLevel);
        this.grenadeType = grenadeType;
        Object object = ModSoundEvents.INSTANCE.getGRENADE_HIT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        this.hitBlockSound = (SoundEvent)object;
        Object object2 = ModSoundEvents.INSTANCE.getGRENADE_THROW().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        this.throwSound = (SoundEvent)object2;
    }

    @NotNull
    public final GrenadeType getGrenadeType() {
        return this.grenadeType;
    }

    @NotNull
    public final SoundEvent getHitBlockSound() {
        return this.hitBlockSound;
    }

    public final void setHitBlockSound(@NotNull SoundEvent soundEvent) {
        Intrinsics.checkNotNullParameter((Object)soundEvent, (String)"<set-?>");
        this.hitBlockSound = soundEvent;
    }

    @NotNull
    public final SoundEvent getThrowSound() {
        return this.throwSound;
    }

    public final void setThrowSound(@NotNull SoundEvent soundEvent) {
        Intrinsics.checkNotNullParameter((Object)soundEvent, (String)"<set-?>");
        this.throwSound = soundEvent;
    }

    @Nullable
    public final UUID getLastHitEntity() {
        return this.lastHitEntity;
    }

    public final void setLastHitEntity(@Nullable UUID uUID) {
        this.lastHitEntity = uUID;
    }

    public final float getZRot() {
        return this.zRot;
    }

    public final void setZRot(float f) {
        this.zRot = f;
    }

    public final float getZRotO() {
        return this.zRotO;
    }

    public final void setZRotO(float f) {
        this.zRotO = f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(speedAccessor, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(isLandedAccessor, (Object)false);
        this.f_19804_.m_135372_(isExplodedAccessor, (Object)false);
    }

    public void m_6686_(double x, double y, double z, float pVelocity, float pInaccuracy) {
        super.m_6686_(x, y, z, pVelocity, pInaccuracy);
        if (this.m_9236_().f_46443_) {
            this.randomizeRotation();
        }
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (this.m_9236_().f_46443_) {
            this.randomizeRotation();
        }
        if (result.m_82443_() instanceof EndCrystal) {
            result.m_82443_().m_6469_(result.m_82443_().m_269291_().m_269264_(), 1.0f);
        }
        if (result.m_82443_() instanceof LivingEntity) {
            Entity entity = result.m_82443_();
            Intrinsics.checkNotNull((Object)entity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.LivingEntity");
            LivingEntity entity2 = (LivingEntity)entity;
            AttributeInstance attributeInstance = entity2.m_21051_(Attributes.f_22278_);
            double originalKnockBackResistance = attributeInstance != null ? attributeInstance.m_22115_() : 0.0;
            AttributeInstance attributeInstance2 = entity2.m_21051_(Attributes.f_22278_);
            if (attributeInstance2 != null) {
                attributeInstance2.m_22100_(1.0);
            }
            entity2.m_6469_(this.getHitDamageSource(entity2), 1.0f);
            AttributeInstance attributeInstance3 = entity2.m_21051_(Attributes.f_22278_);
            if (attributeInstance3 != null) {
                attributeInstance3.m_22100_(originalKnockBackResistance);
            }
        }
        if (this.lastHitEntity == null || !Intrinsics.areEqual((Object)this.lastHitEntity, (Object)result.m_82443_().m_20148_())) {
            Vec3 vec3 = this.m_20184_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getDeltaMovement(...)");
            Direction direction = UtilsKt.snapToAxis(vec3).m_122424_();
            Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getOpposite(...)");
            Direction direction2 = direction;
            this.bounce(direction2, 0.1f, 0.08f);
            this.lastHitEntity = result.m_82443_().m_20148_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (((Boolean)this.f_19804_.m_135370_(isLandedAccessor)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(isExplodedAccessor)).booleanValue()) {
            this.m_20256_(Vec3.f_82478_);
            this.m_20242_(true);
        }
        if (this.m_9236_().f_46443_) {
            Boolean isLanded = (Boolean)this.f_19804_.m_135370_(isLandedAccessor);
            if (!isLanded.booleanValue() && !((Boolean)this.f_19804_.m_135370_(isExplodedAccessor)).booleanValue()) {
                this.f_19860_ = this.m_146909_();
                this.f_19859_ = this.m_146908_();
                this.zRotO = this.zRot;
                this.m_146926_((this.m_146909_() + this.xRotSpeed) % (float)360);
                this.m_146922_((this.m_146908_() + this.yRotSpeed) % (float)360);
                this.zRot = (this.zRot + this.zRotSpeed) % (float)360;
                this.xRotSpeed *= 0.99f;
                this.yRotSpeed *= 0.99f;
                this.zRotSpeed *= 0.99f;
            } else {
                this.xRotSpeed = 0.0f;
                this.yRotSpeed = 0.0f;
                this.zRotSpeed = 0.0f;
            }
        }
    }

    public void onAddedToWorld() {
        this.m_5496_(this.throwSound, 0.2f, 1.0f);
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (this.m_9236_().f_46443_) {
            this.randomizeRotation();
        }
        if (((Boolean)ModConfig.INSTANCE.getIGNORE_BARRIER_BLOCK().get()).booleanValue() && this.m_9236_().m_8055_(result.m_82425_()).m_60734_() instanceof BarrierBlock) {
            return;
        }
        this.m_6034_(this.f_19790_, this.f_19791_, this.f_19792_);
        if (this.m_9236_().f_46443_ && !((Boolean)this.f_19804_.m_135370_(isExplodedAccessor)).booleanValue() && !((Boolean)this.f_19804_.m_135370_(isLandedAccessor)).booleanValue()) {
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            Intrinsics.checkNotNull((Object)localPlayer);
            LocalPlayer player = localPlayer;
            double distance = this.m_20182_().m_82549_(player.m_20182_().m_82548_()).m_82553_();
            EntityBoundSoundInstance soundInstance = new EntityBoundSoundInstance(this.hitBlockSound, SoundSource.AMBIENT, (float)SoundUtils.INSTANCE.getVolumeFromDistance(distance, SoundTypes.GRENADE_HIT), 1.0f, (Entity)this, 0L);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)soundInstance);
        }
        if (((Boolean)this.f_19804_.m_135370_(isLandedAccessor)).booleanValue() || ((Boolean)this.f_19804_.m_135370_(isExplodedAccessor)).booleanValue()) {
            return;
        }
        Direction direction = result.m_82434_();
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"getDirection(...)");
        this.bounce(direction, 0.7f, 0.9f);
        this.m_6034_(this.f_19790_, this.f_19791_, this.f_19792_);
        this.m_20256_(this.m_20184_().m_82490_(0.5));
        if (result.m_82434_() == Direction.UP && this.m_20184_().m_82553_() < 0.05) {
            this.m_6034_(this.m_20185_(), (double)result.m_82425_().m_123342_() + 1.0, this.m_20189_());
            this.m_20256_(Vec3.f_82478_);
            this.f_19804_.m_135381_(isLandedAccessor, (Object)true);
        }
    }

    private final void randomizeRotation() {
        this.xRotSpeed = (this.f_19796_.m_188501_() - 0.5f) * (float)40;
        this.yRotSpeed = (this.f_19796_.m_188501_() - 0.5f) * (float)40;
        this.zRotSpeed = (this.f_19796_.m_188501_() - 0.5f) * (float)40;
    }

    private final void bounce(Direction direction, float speedCoefficient, float frictionFactor) {
        this.m_20256_(switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1, 2 -> new Vec3(this.m_20184_().f_82479_ * (double)frictionFactor, -this.m_20184_().f_82480_ * (double)speedCoefficient, this.m_20184_().f_82481_ * (double)frictionFactor);
            case 3, 4 -> new Vec3(-this.m_20184_().f_82479_ * (double)speedCoefficient, this.m_20184_().f_82480_ * (double)frictionFactor, this.m_20184_().f_82481_ * (double)frictionFactor);
            case 5, 6 -> new Vec3(this.m_20184_().f_82479_ * (double)frictionFactor, this.m_20184_().f_82480_ * (double)frictionFactor, -this.m_20184_().f_82481_ * (double)speedCoefficient);
            default -> throw new NoWhenBranchMatchedException();
        });
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_142391_() {
        return false;
    }

    @NotNull
    public abstract DamageSource getHitDamageSource(@NotNull LivingEntity var1);

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(CounterStrikeGrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        speedAccessor = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.m_135353_(CounterStrikeGrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        isLandedAccessor = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.m_135353_(CounterStrikeGrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        isExplodedAccessor = entityDataAccessor3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lclub/pisquad/minecraft/csgrenades/entity/CounterStrikeGrenadeEntity$Companion;", "", "<init>", "()V", "speedAccessor", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getSpeedAccessor", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "isLandedAccessor", "", "isExplodedAccessor", "csgrenades"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Float> getSpeedAccessor() {
            return speedAccessor;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> isLandedAccessor() {
            return isLandedAccessor;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> isExplodedAccessor() {
            return isExplodedAccessor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

