/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.entity;

import club.pisquad.minecraft.csgrenades.compat.tacz.TaczApiHandler;
import club.pisquad.minecraft.csgrenades.entity.CounterStrikeGrenadeEntity;
import club.pisquad.minecraft.csgrenades.enums.GrenadeType;
import club.pisquad.minecraft.csgrenades.registery.ModDamageType;
import club.pisquad.minecraft.csgrenades.registery.ModItems;
import com.tacz.guns.api.item.IGun;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 %2\u00020\u0001:\u0001%B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u0015H\u0002J\b\u0010\"\u001a\u00020\u0015H\u0002J\b\u0010#\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u00020\u0015H\u0002R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lclub/pisquad/minecraft/csgrenades/entity/DecoyGrenadeEntity;", "Lclub/pisquad/minecraft/csgrenades/entity/CounterStrikeGrenadeEntity;", "pEntityType", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/projectile/ThrowableItemProjectile;", "pLevel", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "activationTick", "", "Ljava/lang/Integer;", "nextSoundTick", "lastSoundCounter", "hasSavedFinalRotation", "", "finalXRot", "", "finalYRot", "finalZRot", "defineSynchedData", "", "getDefaultItem", "Lnet/minecraft/world/item/Item;", "tick", "findAndSetTaczGunId", "getHitDamageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "hitEntity", "Lnet/minecraft/world/entity/LivingEntity;", "setCustomSound", "sound", "", "scheduleNextSound", "playSoundLogic", "playDefaultSound", "endOfLifeExplosion", "Companion", "csgrenades"})
public final class DecoyGrenadeEntity
extends CounterStrikeGrenadeEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Integer activationTick;
    private int nextSoundTick;
    private int lastSoundCounter;
    private boolean hasSavedFinalRotation;
    private float finalXRot;
    private float finalYRot;
    private float finalZRot;
    private static final int TOTAL_DURATION_TICKS = 300;
    private static final int SOUND_INTERVAL_BASE_TICKS = 20;
    private static final int SOUND_INTERVAL_RANDOM_TICKS = 40;
    @NotNull
    private static final EntityDataAccessor<String> CUSTOM_SOUND_ACCESSOR;
    @NotNull
    private static final EntityDataAccessor<Integer> SOUND_COUNTER_ACCESSOR;
    @NotNull
    private static final EntityDataAccessor<String> GUN_ID_TO_PLAY_ACCESSOR;

    public DecoyGrenadeEntity(@NotNull EntityType<? extends ThrowableItemProjectile> pEntityType, @NotNull Level pLevel) {
        Intrinsics.checkNotNullParameter(pEntityType, (String)"pEntityType");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        super(pEntityType, pLevel, GrenadeType.DECOY_GRENADE);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CUSTOM_SOUND_ACCESSOR, (Object)"");
        this.f_19804_.m_135372_(SOUND_COUNTER_ACCESSOR, (Object)0);
        this.f_19804_.m_135372_(GUN_ID_TO_PLAY_ACCESSOR, (Object)"");
    }

    @NotNull
    protected Item m_7881_() {
        Object object = ModItems.INSTANCE.getDECOY_GRENADE_ITEM().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Item)object;
    }

    @Override
    public void m_8119_() {
        Boolean isLanded = (Boolean)this.f_19804_.m_135370_(CounterStrikeGrenadeEntity.Companion.isLandedAccessor());
        if (isLanded.booleanValue()) {
            if (this.m_9236_().f_46443_) {
                if (!this.hasSavedFinalRotation) {
                    this.finalXRot = this.m_146909_();
                    this.finalYRot = this.m_146908_();
                    this.finalZRot = this.getZRot();
                    this.hasSavedFinalRotation = true;
                }
                this.m_146926_(this.finalXRot);
                this.m_146922_(this.finalYRot);
                this.setZRot(this.finalZRot);
                this.f_19860_ = this.finalXRot;
                this.f_19859_ = this.finalYRot;
                this.setZRotO(this.finalZRot);
                Integer currentCounter = (Integer)this.f_19804_.m_135370_(SOUND_COUNTER_ACCESSOR);
                if (currentCounter > this.lastSoundCounter) {
                    if (ModList.get().isLoaded("tacz")) {
                        String gunIdString = (String)this.f_19804_.m_135370_(GUN_ID_TO_PLAY_ACCESSOR);
                        Intrinsics.checkNotNull((Object)gunIdString);
                        if (!StringsKt.isBlank((CharSequence)gunIdString)) {
                            TaczApiHandler.INSTANCE.playGunSound((Entity)this, new ResourceLocation(gunIdString));
                        }
                    }
                    this.lastSoundCounter = currentCounter;
                }
            } else if (this.activationTick == null) {
                this.activationTick = this.f_19797_;
                if (ModList.get().isLoaded("tacz")) {
                    this.findAndSetTaczGunId();
                }
                this.scheduleNextSound();
            } else {
                Integer n = this.activationTick;
                Intrinsics.checkNotNull((Object)n);
                int currentActivationTick = this.f_19797_ - n;
                if (this.f_19797_ >= this.nextSoundTick) {
                    if (ModList.get().isLoaded("tacz")) {
                        String gunIdString = (String)this.f_19804_.m_135370_(GUN_ID_TO_PLAY_ACCESSOR);
                        Intrinsics.checkNotNull((Object)gunIdString);
                        if (!StringsKt.isBlank((CharSequence)gunIdString)) {
                            Integer currentCounter = (Integer)this.f_19804_.m_135370_(SOUND_COUNTER_ACCESSOR);
                            this.f_19804_.m_135381_(SOUND_COUNTER_ACCESSOR, (Object)(currentCounter + 1));
                        }
                    } else {
                        this.playSoundLogic();
                    }
                    this.scheduleNextSound();
                }
                if (currentActivationTick > 300) {
                    this.endOfLifeExplosion();
                }
            }
        } else {
            super.m_8119_();
        }
    }

    private final void findAndSetTaczGunId() {
        Entity owner = this.m_19749_();
        if (owner instanceof Player) {
            Iterator iterator = ((Player)owner).m_150109_().f_35974_.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                ItemStack itemStack = (ItemStack)iterator2.next();
                Item item = itemStack.m_41720_();
                if (!(item instanceof IGun)) continue;
                ResourceLocation resourceLocation = ((IGun)item).getGunId(itemStack);
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getGunId(...)");
                ResourceLocation gunId = resourceLocation;
                this.f_19804_.m_135381_(GUN_ID_TO_PLAY_ACCESSOR, (Object)gunId.toString());
                return;
            }
        }
    }

    @Override
    @NotNull
    public DamageSource getHitDamageSource(@NotNull LivingEntity hitEntity) {
        Intrinsics.checkNotNullParameter((Object)hitEntity, (String)"hitEntity");
        RegistryAccess registryAccess = this.m_9236_().m_9598_();
        Holder.Reference damageTypeHolder = registryAccess.m_255025_(Registries.f_268580_).m_255043_(ModDamageType.INSTANCE.getDECOY_GRENADE_HIT());
        return Intrinsics.areEqual((Object)hitEntity, (Object)this.m_19749_()) ? new DamageSource((Holder)damageTypeHolder, (Entity)this) : new DamageSource((Holder)damageTypeHolder, (Entity)this, this.m_19749_());
    }

    public final void setCustomSound(@NotNull String sound) {
        Intrinsics.checkNotNullParameter((Object)sound, (String)"sound");
        this.f_19804_.m_135381_(CUSTOM_SOUND_ACCESSOR, (Object)sound);
    }

    private final void scheduleNextSound() {
        this.nextSoundTick = this.f_19797_ + 20 + Random.Default.nextInt(40);
    }

    private final void playSoundLogic() {
        String customSound = (String)this.f_19804_.m_135370_(CUSTOM_SOUND_ACCESSOR);
        Intrinsics.checkNotNull((Object)customSound);
        if (!StringsKt.isBlank((CharSequence)customSound)) {
            try {
                SoundEvent soundEvent = SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(customSound));
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundEvent, SoundSource.PLAYERS, 4.0f, 1.0f);
            }
            catch (Exception e) {
                this.playDefaultSound();
            }
        } else {
            this.playDefaultSound();
        }
    }

    private final void playDefaultSound() {
        SoundEvent[] soundEventArray = new SoundEvent[]{SoundEvents.f_11836_, SoundEvents.f_11835_, SoundEvents.f_11837_, SoundEvents.f_11753_, SoundEvents.f_11750_};
        SoundEvent[] footstepSounds = soundEventArray;
        SoundEvent randomSoundHolder = footstepSounds[Random.Default.nextInt(footstepSounds.length)];
        this.m_9236_().m_5594_(null, this.m_20183_(), randomSoundHolder, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private final void endOfLifeExplosion() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.1f, false, Level.ExplosionInteraction.NONE);
        }
        this.m_146870_();
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(DecoyGrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        CUSTOM_SOUND_ACCESSOR = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.m_135353_(DecoyGrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        SOUND_COUNTER_ACCESSOR = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.m_135353_(DecoyGrenadeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        GUN_ID_TO_PLAY_ACCESSOR = entityDataAccessor3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lclub/pisquad/minecraft/csgrenades/entity/DecoyGrenadeEntity$Companion;", "", "<init>", "()V", "TOTAL_DURATION_TICKS", "", "SOUND_INTERVAL_BASE_TICKS", "SOUND_INTERVAL_RANDOM_TICKS", "CUSTOM_SOUND_ACCESSOR", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getCUSTOM_SOUND_ACCESSOR", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "SOUND_COUNTER_ACCESSOR", "getSOUND_COUNTER_ACCESSOR", "GUN_ID_TO_PLAY_ACCESSOR", "getGUN_ID_TO_PLAY_ACCESSOR", "csgrenades"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<String> getCUSTOM_SOUND_ACCESSOR() {
            return CUSTOM_SOUND_ACCESSOR;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getSOUND_COUNTER_ACCESSOR() {
            return SOUND_COUNTER_ACCESSOR;
        }

        @NotNull
        public final EntityDataAccessor<String> getGUN_ID_TO_PLAY_ACCESSOR() {
            return GUN_ID_TO_PLAY_ACCESSOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

