/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.entity;

import club.pisquad.minecraft.csgrenades.UtilsKt;
import club.pisquad.minecraft.csgrenades.client.renderer.HEGrenadeExplosionData;
import club.pisquad.minecraft.csgrenades.client.renderer.HEGrenadeRenderManager;
import club.pisquad.minecraft.csgrenades.config.ModConfig;
import club.pisquad.minecraft.csgrenades.entity.CounterStrikeGrenadeEntity;
import club.pisquad.minecraft.csgrenades.entity.HEGrenadeEntityKt;
import club.pisquad.minecraft.csgrenades.entity.SmokeGrenadeEntity;
import club.pisquad.minecraft.csgrenades.enums.GrenadeType;
import club.pisquad.minecraft.csgrenades.registery.ModDamageType;
import club.pisquad.minecraft.csgrenades.registery.ModItems;
import club.pisquad.minecraft.csgrenades.registery.ModSoundEvents;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Lclub/pisquad/minecraft/csgrenades/entity/HEGrenadeEntity;", "Lclub/pisquad/minecraft/csgrenades/entity/CounterStrikeGrenadeEntity;", "pEntityType", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/projectile/ThrowableItemProjectile;", "pLevel", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "getDefaultItem", "Lnet/minecraft/world/item/Item;", "tick", "", "doDamage", "getDamageBlockingState", "", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "getHitDamageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "hitEntity", "blowUpNearbySmokeGrenade", "csgrenades"})
@SourceDebugExtension(value={"SMAP\nHEGrenadeEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HEGrenadeEntity.kt\nclub/pisquad/minecraft/csgrenades/entity/HEGrenadeEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1863#2,2:175\n*S KotlinDebug\n*F\n+ 1 HEGrenadeEntity.kt\nclub/pisquad/minecraft/csgrenades/entity/HEGrenadeEntity\n*L\n158#1:175,2\n*E\n"})
public final class HEGrenadeEntity
extends CounterStrikeGrenadeEntity {
    public HEGrenadeEntity(@NotNull EntityType<? extends ThrowableItemProjectile> pEntityType, @NotNull Level pLevel) {
        Intrinsics.checkNotNullParameter(pEntityType, (String)"pEntityType");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        super(pEntityType, pLevel, GrenadeType.HEGRENADE);
        this.setHitBlockSound((SoundEvent)ModSoundEvents.INSTANCE.getHEGRENADE_BOUNCE().get());
    }

    @NotNull
    protected Item m_7881_() {
        Object object = ModItems.INSTANCE.getHEGRENADE_ITEM().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Item)object;
    }

    @Override
    public void m_8119_() {
        if (((Boolean)this.f_19804_.m_135370_(CounterStrikeGrenadeEntity.Companion.isExplodedAccessor())).booleanValue()) {
            if (!this.m_9236_().f_46443_) {
                this.m_146870_();
            }
            return;
        }
        super.m_8119_();
        if (UtilsKt.getTimeFromTickCount(this.f_19797_) > 2.5) {
            if (!this.m_9236_().f_46443_) {
                this.doDamage();
            } else {
                Vec3 vec3 = this.m_20182_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                HEGrenadeRenderManager.INSTANCE.render(new HEGrenadeExplosionData(vec3));
                this.blowUpNearbySmokeGrenade();
            }
            this.f_19804_.m_135381_(CounterStrikeGrenadeEntity.Companion.isExplodedAccessor(), (Object)true);
        }
    }

    private final void doDamage() {
        Level level = this.m_9236_();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel level2 = (ServerLevel)level;
        RegistryAccess registryAccess = this.m_9236_().m_9598_();
        Double damageRange = (Double)ModConfig.HEGrenade.INSTANCE.getDAMAGE_RANGE().get();
        DamageSource baseDamageSource = new DamageSource((Holder)registryAccess.m_255025_(Registries.f_268580_).m_255043_(ModDamageType.INSTANCE.getHEGRENADE_EXPLOSION()), this.m_19749_());
        DamageSource selfDamageSource = new DamageSource((Holder)registryAccess.m_255025_(Registries.f_268580_).m_255043_(ModDamageType.INSTANCE.getHEGRENADE_EXPLOSION_SELF()));
        Class clazz = (Boolean)ModConfig.INSTANCE.getDAMAGE_NON_PLAYER_ENTITY().get() != false ? LivingEntity.class : Player.class;
        AABB aABB = new AABB(this.m_20183_());
        Object object = ModConfig.HEGrenade.INSTANCE.getDAMAGE_RANGE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        List entities = level2.m_45976_(clazz, aABB.m_82400_(((Number)object).doubleValue()));
        for (LivingEntity entity : entities) {
            double originalKnockBackResistance;
            block8: {
                double damage;
                block7: {
                    double distance = entity.m_20270_((Entity)this);
                    if (!(distance < damageRange)) continue;
                    Intrinsics.checkNotNull((Object)entity);
                    damage = this.getDamageBlockingState(entity);
                    if (!(damage > 0.0)) continue;
                    AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22278_);
                    originalKnockBackResistance = attributeInstance != null ? attributeInstance.m_22115_() : 0.0;
                    AttributeInstance attributeInstance2 = entity.m_21051_(Attributes.f_22278_);
                    if (attributeInstance2 != null) {
                        attributeInstance2.m_22100_(1.0);
                    }
                    if (!Intrinsics.areEqual((Object)entity, (Object)this.m_19749_())) break block7;
                    ModConfig.SelfDamageSetting selfDamageSetting = (ModConfig.SelfDamageSetting)((Object)ModConfig.HEGrenade.INSTANCE.getCAUSE_DAMAGE_TO_OWNER().get());
                    switch (selfDamageSetting == null ? -1 : WhenMappings.$EnumSwitchMapping$0[selfDamageSetting.ordinal()]) {
                        case 1: {
                            break block8;
                        }
                        case 2: {
                            entity.m_6469_(baseDamageSource, (float)damage);
                            break block8;
                        }
                        case 3: {
                            entity.m_6469_(selfDamageSource, (float)damage);
                            break block8;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                entity.m_6469_(baseDamageSource, (float)damage);
            }
            AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22278_);
            if (attributeInstance == null) continue;
            attributeInstance.m_22100_(originalKnockBackResistance);
        }
    }

    private final double getDamageBlockingState(LivingEntity entity) {
        double distance;
        ClipContext it = new ClipContext(this.m_20182_(), entity.m_146892_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null);
        boolean bl = false;
        BlockHitResult clipResult = this.m_9236_().m_45547_(it);
        double headDamage = clipResult.m_6662_() == HitResult.Type.MISS ? ((distance = this.m_20182_().m_82554_(entity.m_146892_())) < 1.5 ? HEGrenadeEntityKt.access$calculateHEGrenadeDamage(distance, 0.0, true) : HEGrenadeEntityKt.calculateHEGrenadeDamage$default(distance, 0.0, false, 4, null)) : 0.0;
        ClipContext it2 = new ClipContext(this.m_20182_(), entity.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null);
        boolean bl2 = false;
        BlockHitResult clipResult2 = this.m_9236_().m_45547_(it2);
        double bodyDamage = clipResult2.m_6662_() == HitResult.Type.MISS ? HEGrenadeEntityKt.calculateHEGrenadeDamage$default(this.m_20182_().m_82554_(entity.m_20182_()), 0.0, false, 4, null) : 0.0;
        return Math.max(headDamage, bodyDamage);
    }

    @Override
    @NotNull
    public DamageSource getHitDamageSource(@NotNull LivingEntity hitEntity) {
        Intrinsics.checkNotNullParameter((Object)hitEntity, (String)"hitEntity");
        RegistryAccess registryAccess = this.m_9236_().m_9598_();
        Holder.Reference damageTypeHolder = registryAccess.m_255025_(Registries.f_268580_).m_255043_(ModDamageType.INSTANCE.getHEGRENADE_HIT());
        return Intrinsics.areEqual((Object)hitEntity, (Object)this.m_19749_()) ? new DamageSource((Holder)damageTypeHolder, (Entity)this) : new DamageSource((Holder)damageTypeHolder, (Entity)this, this.m_19749_());
    }

    /*
     * WARNING - void declaration
     */
    private final void blowUpNearbySmokeGrenade() {
        void $this$forEach$iv;
        Integer smokeRadius = (Integer)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_RADIUS().get();
        Double heDamageRange = (Double)ModConfig.HEGrenade.INSTANCE.getDAMAGE_RANGE().get();
        Integer smokeFallingHeight = (Integer)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_MAX_FALLING_HEIGHT().get();
        Level level = this.m_9236_();
        AABB aABB = this.m_20191_();
        double d = heDamageRange;
        Intrinsics.checkNotNull((Object)smokeRadius);
        Iterable iterable = level.m_45976_(SmokeGrenadeEntity.class, aABB.m_82400_(d + (double)smokeRadius.intValue()).m_82377_(0.0, (double)smokeFallingHeight.intValue(), 0.0));
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getEntitiesOfClass(...)");
        iterable = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SmokeGrenadeEntity it = (SmokeGrenadeEntity)element$iv;
            boolean bl = false;
            Vec3 vec3 = this.m_20182_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            it.clearSmokeWithinRange(vec3, heDamageRange + 2.5, true);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModConfig.SelfDamageSetting.values().length];
            try {
                nArray[ModConfig.SelfDamageSetting.NEVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModConfig.SelfDamageSetting.NOT_IN_TEAM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModConfig.SelfDamageSetting.ALWAYS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

