/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.entity;

import club.pisquad.minecraft.csgrenades.SoundTypes;
import club.pisquad.minecraft.csgrenades.SoundUtils;
import club.pisquad.minecraft.csgrenades.UtilsKt;
import club.pisquad.minecraft.csgrenades.client.renderer.SmokeRenderManager;
import club.pisquad.minecraft.csgrenades.config.ModConfig;
import club.pisquad.minecraft.csgrenades.entity.AbstractFireGrenade;
import club.pisquad.minecraft.csgrenades.entity.CounterStrikeGrenadeEntity;
import club.pisquad.minecraft.csgrenades.entity.SmokeGrenadeSpreadBlockCalculator;
import club.pisquad.minecraft.csgrenades.enums.GrenadeType;
import club.pisquad.minecraft.csgrenades.particle.SmokeGrenadeParticle;
import club.pisquad.minecraft.csgrenades.registery.ModDamageType;
import club.pisquad.minecraft.csgrenades.registery.ModItems;
import club.pisquad.minecraft.csgrenades.registery.ModSerializers;
import club.pisquad.minecraft.csgrenades.registery.ModSoundEvents;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ;2\u00020\u0001:\u0001;B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0014J\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u000eJ\u001e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020%H\u0002J\b\u0010+\u001a\u00020\u001eH\u0016J\b\u0010,\u001a\u00020\u001eH\u0002J\b\u0010-\u001a\u00020\u001eH\u0016J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u000200H\u0014J\b\u00101\u001a\u00020(H\u0002J\b\u00102\u001a\u00020\u001eH\u0002J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00130\rH\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\"\u001a\u00020\u0013H\u0002J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00130\rJ\u000e\u0010:\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\r\u0012\t\u0012\u00070\u0013\u00a2\u0006\u0002\b\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lclub/pisquad/minecraft/csgrenades/entity/SmokeGrenadeEntity;", "Lclub/pisquad/minecraft/csgrenades/entity/CounterStrikeGrenadeEntity;", "pEntityType", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/projectile/ThrowableItemProjectile;", "pLevel", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "lastPos", "Lnet/minecraft/core/Vec3i;", "particles", "", "", "Lclub/pisquad/minecraft/csgrenades/particle/SmokeGrenadeParticle;", "explosionTime", "Ljava/time/Instant;", "spreadBlocksCache", "", "Lnet/minecraft/core/BlockPos;", "Lkotlinx/serialization/Serializable;", "hasSavedFinalRotation", "", "finalXRot", "", "finalYRot", "finalZRot", "getDefaultItem", "Lnet/minecraft/world/item/Item;", "defineSynchedData", "", "registerParticle", "particle", "clearSmokeWithinRange", "position", "Lnet/minecraft/world/phys/Vec3;", "range", "", "printHeader", "getRegenerationTime", "", "distance", "radius", "tick", "disperseSmokeByProjectiles", "onAddedToWorld", "onHitBlock", "result", "Lnet/minecraft/world/phys/BlockHitResult;", "extinguishNearbyFires", "clientRenderEffect", "calculateSpreadBlocks", "getSpaceBelow", "getHitDamageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "hitEntity", "Lnet/minecraft/world/entity/LivingEntity;", "getSpreadBlocks", "canDistinguishFire", "Companion", "csgrenades"})
@SourceDebugExtension(value={"SMAP\nSmokeGrenadeEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmokeGrenadeEntity.kt\nclub/pisquad/minecraft/csgrenades/entity/SmokeGrenadeEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,457:1\n1#2:458\n1863#3:459\n1863#3,2:460\n1864#3:462\n1863#3,2:463\n1863#3,2:465\n1863#3,2:467\n1863#3,2:469\n1755#3,3:471\n1755#3,3:474\n*S KotlinDebug\n*F\n+ 1 SmokeGrenadeEntity.kt\nclub/pisquad/minecraft/csgrenades/entity/SmokeGrenadeEntity\n*L\n91#1:459\n93#1:460,2\n91#1:462\n200#1:463,2\n233#1:465,2\n311#1:467,2\n353#1:469,2\n396#1:471,3\n306#1:474,3\n*E\n"})
public final class SmokeGrenadeEntity
extends CounterStrikeGrenadeEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vec3i lastPos;
    @NotNull
    private final Map<Vec3i, List<SmokeGrenadeParticle>> particles;
    @Nullable
    private Instant explosionTime;
    @NotNull
    private final List<BlockPos> spreadBlocksCache;
    private boolean hasSavedFinalRotation;
    private float finalXRot;
    private float finalYRot;
    private float finalZRot;
    @NotNull
    private static final EntityDataAccessor<List<BlockPos>> spreadBlocksAccessor;

    public SmokeGrenadeEntity(@NotNull EntityType<? extends ThrowableItemProjectile> pEntityType, @NotNull Level pLevel) {
        Intrinsics.checkNotNullParameter(pEntityType, (String)"pEntityType");
        Intrinsics.checkNotNullParameter((Object)pLevel, (String)"pLevel");
        super(pEntityType, pLevel, GrenadeType.FLASH_BANG);
        this.lastPos = new Vec3i(0, 0, 0);
        this.particles = new LinkedHashMap();
        this.spreadBlocksCache = new ArrayList();
    }

    @NotNull
    protected Item m_7881_() {
        Object object = ModItems.INSTANCE.getSMOKE_GRENADE_ITEM().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Item)object;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(spreadBlocksAccessor, (Object)CollectionsKt.emptyList());
    }

    public final void registerParticle(@NotNull SmokeGrenadeParticle particle) {
        Intrinsics.checkNotNullParameter((Object)((Object)particle), (String)"particle");
        Vec3 vec3 = particle.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getPos(...)");
        Vec3i pos = UtilsKt.toVec3i(vec3);
        if (this.particles.containsKey(pos)) {
            List<SmokeGrenadeParticle> list = this.particles.get(pos);
            Intrinsics.checkNotNull(list);
            this.particles.put(pos, CollectionsKt.plus((Collection)list, (Object)((Object)particle)));
        } else {
            this.particles.put(pos, CollectionsKt.listOf((Object)((Object)particle)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clearSmokeWithinRange(@NotNull Vec3 position, double range, boolean printHeader) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (printHeader) {
            System.out.println((Object)("CS-GRENADES DEBUG: Clearing smoke at pos: " + position + " with range: " + range + ". Checking ALL particles."));
            Iterable iterable = this.particles.values();
            int n = 0;
            for (Iterator iterator : iterable) {
                void it;
                List list = (List)((Object)iterator);
                int n2 = n;
                boolean bl = false;
                int n3 = it.size();
                n = n2 + n3;
            }
            int totalParticles = n;
            System.out.println((Object)("CS-GRENADES DEBUG: Total particles in map: " + totalParticles));
            if (totalParticles == 0) {
                System.out.println((Object)"CS-GRENADES DEBUG: Cleared 0 particles because the map is empty.");
                return;
            }
        }
        int clearedCount = 0;
        int checkedCount = 0;
        Iterable $this$forEach$iv = this.particles.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List particleList = (List)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = particleList;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SmokeGrenadeParticle particle = (SmokeGrenadeParticle)((Object)element$iv2);
                boolean bl2 = false;
                if (printHeader && checkedCount < 5) {
                    double dist = particle.getPos().m_82554_(position);
                    System.out.println((Object)("CS-GRENADES DEBUG:   - Checking particle at " + particle.getPos() + ", distance to bullet: " + dist));
                }
                ++checkedCount;
                if (!(particle.getPos().m_82557_(position) < range * range)) continue;
                particle.setOpacityTime(this.getRegenerationTime(particle.getPos().m_82554_(position), range));
                ++clearedCount;
            }
        }
        if (clearedCount > 0) {
            System.out.println((Object)("CS-GRENADES DEBUG: Cleared " + clearedCount + " particles at interpolated position."));
        }
    }

    private final int getRegenerationTime(double distance, double radius) {
        Object object = ModConfig.SmokeGrenade.INSTANCE.getTIME_BEFORE_REGENERATE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        int n = (int)UtilsKt.millToTick(((Number)object).longValue());
        Object object2 = ModConfig.SmokeGrenade.INSTANCE.getREGENERATION_TIME().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        return n + (int)UtilsKt.linearInterpolate(UtilsKt.millToTick(((Number)object2).longValue()), 0.0, distance / radius);
    }

    @Override
    public void m_8119_() {
        if (((Boolean)this.f_19804_.m_135370_(CounterStrikeGrenadeEntity.Companion.isExplodedAccessor())).booleanValue()) {
            if (this.m_9236_().f_46443_) {
                if (!this.hasSavedFinalRotation) {
                    this.finalXRot = this.m_146909_();
                    this.finalYRot = this.m_146908_();
                    this.finalZRot = this.getZRot();
                    this.hasSavedFinalRotation = true;
                }
                this.m_146926_(this.finalXRot);
                this.m_146922_(this.finalYRot);
                this.setZRot(this.finalZRot);
                this.f_19860_ = this.finalXRot;
                this.f_19859_ = this.finalYRot;
                this.setZRotO(this.finalZRot);
            }
            if (this.m_9236_() instanceof ServerLevel) {
                if (this.explosionTime != null && Duration.between(this.explosionTime, Instant.now()).compareTo(Duration.ofMillis(((Number)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_LIFETIME().get()).longValue())) > 0) {
                    this.m_6074_();
                }
                this.extinguishNearbyFires();
            }
            if (this.m_9236_().f_46443_) {
                this.disperseSmokeByProjectiles();
            }
            return;
        }
        super.m_8119_();
        if (((Boolean)this.f_19804_.m_135370_(CounterStrikeGrenadeEntity.Companion.isLandedAccessor())).booleanValue()) {
            if (Intrinsics.areEqual((Object)this.m_20182_(), (Object)new Vec3(this.f_19790_, this.f_19791_, this.f_19792_))) {
                int n = this.f_19797_;
                this.f_19797_ = n + 1;
            } else {
                this.f_19797_ = 0;
            }
            long l = this.f_19797_;
            Object object = ModConfig.SmokeGrenade.INSTANCE.getFUSE_TIME_AFTER_LANDING().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            if (l > UtilsKt.millToTick(((Number)object).longValue()) && this.explosionTime == null) {
                if (this.m_9236_().f_46443_) {
                    this.clientRenderEffect();
                } else {
                    this.f_19804_.m_135381_(spreadBlocksAccessor, this.calculateSpreadBlocks());
                    this.m_37446_(ItemStack.f_41583_);
                }
                this.f_19804_.m_135381_(CounterStrikeGrenadeEntity.Companion.isExplodedAccessor(), (Object)true);
                this.explosionTime = Instant.now();
            }
        }
    }

    private final void disperseSmokeByProjectiles() {
        List<BlockPos> spreadBlocks = this.getSpreadBlocks();
        if (spreadBlocks.isEmpty()) {
            return;
        }
        AABB searchBB = this.m_20191_().m_82400_(64.0);
        List nearbyArrows = this.m_9236_().m_6443_(AbstractArrow.class, searchBB, arg_0 -> SmokeGrenadeEntity.disperseSmokeByProjectiles$lambda$4(SmokeGrenadeEntity::disperseSmokeByProjectiles$lambda$3, arg_0));
        AABB smokeCloudBoundingBox = new AABB(BlockPos.m_274446_((Position)((Position)this.m_20182_()))).m_82400_((double)((Number)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_RADIUS().get()).intValue());
        Intrinsics.checkNotNull((Object)nearbyArrows);
        Iterable $this$forEach$iv = nearbyArrows;
        boolean $i$f$forEach = false;
        block0: for (Object element$iv : $this$forEach$iv) {
            AABB oldBB;
            AbstractArrow arrow = (AbstractArrow)element$iv;
            boolean bl = false;
            Vec3 delta = arrow.m_20184_();
            AABB currentBB = arrow.m_20191_();
            AABB sweptBB = currentBB.m_82367_(oldBB = currentBB.m_82386_(-delta.f_82479_, -delta.f_82480_, -delta.f_82481_));
            if (!smokeCloudBoundingBox.m_82381_(sweptBB)) continue;
            System.out.println((Object)"CS-GRENADES DEBUG: Swept BB intersection SUCCESS for Arrow.");
            Vec3 posNow = arrow.m_20182_();
            Vec3 posOld = posNow.m_82546_(delta);
            int i = 0;
            int steps = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)((int)(delta.m_82553_() / 0.5)), (int)1), (int)30);
            if (i > steps) continue;
            while (true) {
                Vec3 interpolatedPos = posOld.m_165921_(posNow, (double)i / (double)steps);
                Intrinsics.checkNotNull((Object)interpolatedPos);
                Object object = ModConfig.SmokeGrenade.INSTANCE.getARROW_CLEAR_RANGE().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                this.clearSmokeWithinRange(interpolatedPos, ((Number)object).doubleValue(), i == 0);
                if (i == steps) continue block0;
                ++i;
            }
        }
        if (this.m_9236_().f_46443_ && ModList.get().isLoaded("tacz")) {
            Level level = this.m_9236_();
            ClientLevel clientLevel = level instanceof ClientLevel ? (ClientLevel)level : null;
            if (clientLevel == null) {
                return;
            }
            ClientLevel clientLevel2 = clientLevel;
            Iterable allRenderEntities = clientLevel2.m_104735_();
            Intrinsics.checkNotNull((Object)allRenderEntities);
            if (CollectionsKt.none((Iterable)allRenderEntities)) {
                return;
            }
            Vec3 smokeCenter = this.m_20182_();
            double smokeRadius = ((Number)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_RADIUS().get()).intValue();
            AABB smokeCloudBoundingBox2 = new AABB(BlockPos.m_274446_((Position)((Position)smokeCenter))).m_82400_(smokeRadius);
            Iterable $this$forEach$iv2 = allRenderEntities;
            boolean $i$f$forEach2 = false;
            block2: for (Object element$iv : $this$forEach$iv2) {
                AABB oldBB;
                AABB currentBB;
                AABB sweptBB;
                Entity entity = (Entity)element$iv;
                boolean bl = false;
                Vec3 delta = entity.m_20184_();
                if (delta.m_82556_() == 0.0 || !smokeCloudBoundingBox2.m_82381_(sweptBB = (currentBB = entity.m_20191_()).m_82367_(oldBB = currentBB.m_82386_(-delta.f_82479_, -delta.f_82480_, -delta.f_82481_))) || !Intrinsics.areEqual((Object)entity.getClass().getName(), (Object)"com.tacz.guns.entity.EntityKineticBullet")) continue;
                System.out.println((Object)"CS-GRENADES DEBUG: Swept BB intersection SUCCESS for Kinetic Bullet.");
                Vec3 posNow = entity.m_20182_();
                Double finalClearRange = (Double)ModConfig.SmokeGrenade.INSTANCE.getBULLET_CLEAR_RANGE().get();
                Vec3 posOld = posNow.m_82546_(delta);
                int i = 0;
                int steps = RangesKt.coerceAtMost((int)RangesKt.coerceAtLeast((int)((int)(delta.m_82553_() / 0.5)), (int)1), (int)30);
                if (i > steps) continue;
                while (true) {
                    Vec3 interpolatedPos = posOld.m_165921_(posNow, (double)i / (double)steps);
                    Intrinsics.checkNotNull((Object)interpolatedPos);
                    Intrinsics.checkNotNull((Object)finalClearRange);
                    this.clearSmokeWithinRange(interpolatedPos, finalClearRange, i == 0);
                    if (i == steps) continue block2;
                    ++i;
                }
            }
        }
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        Vec3 vec3 = this.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        this.lastPos = UtilsKt.toVec3i(vec3);
    }

    @Override
    protected void m_8060_(@NotNull BlockHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        super.m_8060_(result);
        if (result.m_82434_() == Direction.UP && this.extinguishNearbyFires() > 0) {
            this.f_19804_.m_135381_(CounterStrikeGrenadeEntity.Companion.isLandedAccessor(), (Object)true);
            if (this.m_9236_() instanceof ServerLevel && result.m_82436_()) {
                this.m_146884_(new Vec3(this.m_20182_().f_82479_, (double)result.m_82425_().m_123342_() + 1.0, this.m_20182_().f_82481_));
            }
        }
    }

    private final int extinguishNearbyFires() {
        List extinguishedFires = null;
        Integer smokeRadius = (Integer)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_RADIUS().get();
        Integer smokeFallingHeight = (Integer)ModConfig.SmokeGrenade.INSTANCE.getSMOKE_MAX_FALLING_HEIGHT().get();
        if (((Boolean)this.f_19804_.m_135370_(CounterStrikeGrenadeEntity.Companion.isExplodedAccessor())).booleanValue()) {
            bb = new AABB(this.m_20183_()).m_82377_((double)smokeRadius.intValue(), (double)smokeFallingHeight.intValue(), (double)smokeRadius.intValue());
            extinguishedFires = this.m_9236_().m_6443_(AbstractFireGrenade.class, bb, arg_0 -> SmokeGrenadeEntity.extinguishNearbyFires$lambda$8(arg_0 -> SmokeGrenadeEntity.extinguishNearbyFires$lambda$7(this, arg_0), arg_0));
        } else {
            bb = new AABB(this.m_20183_()).m_82400_((double)((Number)ModConfig.FireGrenade.INSTANCE.getFIRE_RANGE().get()).intValue());
            extinguishedFires = this.m_9236_().m_6443_(AbstractFireGrenade.class, bb, arg_0 -> SmokeGrenadeEntity.extinguishNearbyFires$lambda$11(arg_0 -> SmokeGrenadeEntity.extinguishNearbyFires$lambda$10(this, arg_0), arg_0));
        }
        if (this.m_9236_() instanceof ServerLevel) {
            Iterable $this$forEach$iv = extinguishedFires;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AbstractFireGrenade it = (AbstractFireGrenade)element$iv;
                boolean bl = false;
                it.extinguish();
            }
        }
        return extinguishedFires.size();
    }

    private final void clientRenderEffect() {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        double distance = this.m_20182_().m_82546_(player.m_20182_()).m_82553_();
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        SoundEvent soundEvent = distance > 30.0 ? (SoundEvent)ModSoundEvents.INSTANCE.getSMOKE_EXPLODE_DISTANT().get() : (SoundEvent)ModSoundEvents.INSTANCE.getSMOKE_EMIT().get();
        Intrinsics.checkNotNull((Object)soundEvent);
        SoundEvent soundEvent2 = soundEvent;
        SoundTypes soundType = distance > 30.0 ? SoundTypes.SMOKE_GRENADE_EXPLODE_DISTANT : SoundTypes.SMOKE_GRENADE_EMIT;
        EntityBoundSoundInstance soundInstance = new EntityBoundSoundInstance(soundEvent2, SoundSource.AMBIENT, (float)SoundUtils.INSTANCE.getVolumeFromDistance(distance, soundType), 1.0f, (Entity)this, 0L);
        soundManager.m_120367_((SoundInstance)soundInstance);
        ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
        Intrinsics.checkNotNullExpressionValue((Object)particleEngine, (String)"particleEngine");
        Vec3 vec3 = this.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        SmokeRenderManager.INSTANCE.render(particleEngine, vec3, this);
    }

    private final List<BlockPos> calculateSpreadBlocks() {
        BlockPos blockPos = this.m_20183_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
        SmokeGrenadeSpreadBlockCalculator smokeGrenadeSpreadBlockCalculator = new SmokeGrenadeSpreadBlockCalculator(5, 1500, 2, blockPos);
        Level level = this.m_9236_();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        Set<BlockPos> initialSmoke = smokeGrenadeSpreadBlockCalculator.calculate(level);
        List fallDownSmoke = new ArrayList();
        Iterable $this$forEach$iv = initialSmoke;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos it = (BlockPos)element$iv;
            boolean bl = false;
            fallDownSmoke.addAll((Collection)this.getSpaceBelow(it));
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.union((Iterable)initialSmoke, (Iterable)fallDownSmoke));
    }

    private final List<BlockPos> getSpaceBelow(BlockPos position) {
        List result = new ArrayList();
        BlockPos currentPos = null;
        currentPos = position;
        Object object = ModConfig.SmokeGrenade.INSTANCE.getSMOKE_MAX_FALLING_HEIGHT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        int n = ((Number)object).intValue();
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            if (this.m_9236_().m_8055_(currentPos.m_7495_()).m_60815_()) {
                return result;
            }
            result.add(currentPos);
            currentPos = currentPos.m_7495_();
        }
        return result;
    }

    @Override
    @NotNull
    public DamageSource getHitDamageSource(@NotNull LivingEntity hitEntity) {
        Intrinsics.checkNotNullParameter((Object)hitEntity, (String)"hitEntity");
        RegistryAccess registryAccess = this.m_9236_().m_9598_();
        Holder.Reference damageTypeHolder = registryAccess.m_255025_(Registries.f_268580_).m_255043_(ModDamageType.INSTANCE.getSMOKEGRENADE_HIT());
        return Intrinsics.areEqual((Object)hitEntity, (Object)this.m_19749_()) ? new DamageSource((Holder)damageTypeHolder, (Entity)this) : new DamageSource((Holder)damageTypeHolder, (Entity)this, this.m_19749_());
    }

    @NotNull
    public final List<BlockPos> getSpreadBlocks() {
        if (this.spreadBlocksCache.isEmpty()) {
            Object object = this.f_19804_.m_135370_(spreadBlocksAccessor);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            this.spreadBlocksCache.addAll((Collection)object);
        }
        return this.spreadBlocksCache;
    }

    public final boolean canDistinguishFire(@NotNull Vec3 position) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Iterable $this$any$iv = this.getSpreadBlocks();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BlockPos it = (BlockPos)element$iv;
                    boolean bl2 = false;
                    if (!(it.m_252807_().m_82557_(position) < 2.0)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean disperseSmokeByProjectiles$lambda$3(AbstractArrow arrow) {
        return arrow.m_20184_().m_82556_() > 0.01;
    }

    private static final boolean disperseSmokeByProjectiles$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean extinguishNearbyFires$lambda$7(SmokeGrenadeEntity this$0, AbstractFireGrenade it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ((Boolean)it.m_20088_().m_135370_(CounterStrikeGrenadeEntity.Companion.isExplodedAccessor()) == false) return false;
        Vec3 vec3 = it.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        if (!this$0.canDistinguishFire(vec3)) return false;
        return true;
    }

    private static final boolean extinguishNearbyFires$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean extinguishNearbyFires$lambda$10(SmokeGrenadeEntity this$0, AbstractFireGrenade it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ((Boolean)it.m_20088_().m_135370_(CounterStrikeGrenadeEntity.Companion.isExplodedAccessor()) == false) return false;
        Iterable $this$any$iv = it.getSpreadBlocks();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            BlockPos pos = (BlockPos)element$iv;
            boolean bl2 = false;
            if (pos.m_7494_().m_252807_().m_82557_(this$0.m_20182_()) < 2.0) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final boolean extinguishNearbyFires$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(SmokeGrenadeEntity.class, (EntityDataSerializer)ModSerializers.INSTANCE.getBlockPosListEntityDataSerializer());
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        spreadBlocksAccessor = entityDataAccessor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\u0013\u0012\u000f\u0012\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lclub/pisquad/minecraft/csgrenades/entity/SmokeGrenadeEntity$Companion;", "", "<init>", "()V", "spreadBlocksAccessor", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "Lnet/minecraft/core/BlockPos;", "Lkotlinx/serialization/Serializable;", "getSpreadBlocksAccessor", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "csgrenades"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<List<BlockPos>> getSpreadBlocksAccessor() {
            return spreadBlocksAccessor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

