/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.entity;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lclub/pisquad/minecraft/csgrenades/entity/SmokeGrenadeSpreadBlockCalculator;", "", "generateCycle", "", "blockPerCycle", "stepPerMove", "origin", "Lnet/minecraft/core/BlockPos;", "<init>", "(IIILnet/minecraft/core/BlockPos;)V", "getGenerateCycle", "()I", "getBlockPerCycle", "getStepPerMove", "getOrigin", "()Lnet/minecraft/core/BlockPos;", "calculate", "", "level", "Lnet/minecraft/world/level/Level;", "randomMoveOnce", "blockPos", "randomDirection", "Lnet/minecraft/core/Direction;", "csgrenades"})
final class SmokeGrenadeSpreadBlockCalculator {
    private final int generateCycle;
    private final int blockPerCycle;
    private final int stepPerMove;
    @NotNull
    private final BlockPos origin;

    public SmokeGrenadeSpreadBlockCalculator(int generateCycle, int blockPerCycle, int stepPerMove, @NotNull BlockPos origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        this.generateCycle = generateCycle;
        this.blockPerCycle = blockPerCycle;
        this.stepPerMove = stepPerMove;
        this.origin = origin;
    }

    public final int getGenerateCycle() {
        return this.generateCycle;
    }

    public final int getBlockPerCycle() {
        return this.blockPerCycle;
    }

    public final int getStepPerMove() {
        return this.stepPerMove;
    }

    @NotNull
    public final BlockPos getOrigin() {
        return this.origin;
    }

    @NotNull
    public final Set<BlockPos> calculate(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Set blocks = new LinkedHashSet();
        Set generatedInLastCycle = null;
        Object[] objectArray = new BlockPos[]{this.origin};
        generatedInLastCycle = SetsKt.mutableSetOf((Object[])objectArray);
        Set generatedInCurrentCycle = null;
        generatedInCurrentCycle = new LinkedHashSet();
        int n = this.generateCycle;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            int n2 = this.blockPerCycle;
            for (int j = 0; j < n2; ++j) {
                int it2 = j;
                boolean bl2 = false;
                BlockPos it3 = (BlockPos)CollectionsKt.random((Collection)generatedInLastCycle, (Random)((Random)Random.Default));
                boolean bl3 = false;
                BlockPos currentLocation = null;
                currentLocation = it3;
                int n3 = this.stepPerMove;
                int n4 = 0;
                while (n4 < n3) {
                    int it4 = n4++;
                    boolean bl4 = false;
                    currentLocation = this.randomMoveOnce(level, currentLocation);
                }
                generatedInCurrentCycle.add(currentLocation);
            }
            blocks.addAll(generatedInLastCycle);
            generatedInLastCycle = generatedInCurrentCycle;
            generatedInCurrentCycle = new LinkedHashSet();
        }
        return blocks;
    }

    private final BlockPos randomMoveOnce(Level level, BlockPos blockPos) {
        BlockPos newLocation = switch (WhenMappings.$EnumSwitchMapping$0[this.randomDirection().ordinal()]) {
            case 1 -> blockPos.m_7495_();
            case 2 -> blockPos.m_7494_();
            case 3 -> blockPos.m_122012_();
            case 4 -> blockPos.m_122019_();
            case 5 -> blockPos.m_122024_();
            case 6 -> blockPos.m_122029_();
            default -> throw new NoWhenBranchMatchedException();
        };
        BlockState blockState = level.m_8055_(newLocation);
        if (!blockState.m_60815_() && !blockState.m_60838_((BlockGetter)level, newLocation)) {
            Intrinsics.checkNotNull((Object)newLocation);
            return newLocation;
        }
        return blockPos;
    }

    private final Direction randomDirection() {
        return switch (Random.Default.nextInt(10)) {
            case 0 -> Direction.UP;
            case 1, 5 -> Direction.DOWN;
            case 2, 6 -> Direction.NORTH;
            case 3, 7 -> Direction.SOUTH;
            case 4, 8 -> Direction.WEST;
            default -> Direction.EAST;
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

