/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.entity;

import club.pisquad.minecraft.csgrenades.UtilsKt;
import club.pisquad.minecraft.csgrenades.config.ModConfig;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\nJ\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lclub/pisquad/minecraft/csgrenades/entity/SpreadPathData;", "", "visited", "", "Lnet/minecraft/core/BlockPos;", "center", "currentPos", "<init>", "(Ljava/util/List;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)V", "origin", "(Lnet/minecraft/core/BlockPos;)V", "getVisited", "()Ljava/util/List;", "jumpCount", "", "lastMoveDirection", "Lnet/minecraft/core/Direction;", "getRandomDirection", "tryMoveToDirection", "", "level", "Lnet/minecraft/world/level/Level;", "direction", "randomMoveOnce", "", "Companion", "csgrenades"})
public final class SpreadPathData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<BlockPos> visited;
    @NotNull
    private final BlockPos center;
    @NotNull
    private BlockPos currentPos;
    private int jumpCount;
    @Nullable
    private Direction lastMoveDirection;
    @NotNull
    private static final List<Direction> directions;

    public SpreadPathData(@NotNull List<BlockPos> visited, @NotNull BlockPos center, @NotNull BlockPos currentPos) {
        Intrinsics.checkNotNullParameter(visited, (String)"visited");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)currentPos, (String)"currentPos");
        this.visited = visited;
        this.center = center;
        this.currentPos = currentPos;
    }

    @NotNull
    public final List<BlockPos> getVisited() {
        return this.visited;
    }

    public SpreadPathData(@NotNull BlockPos origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Object[] objectArray = new BlockPos[]{origin};
        this(CollectionsKt.mutableListOf((Object[])objectArray), origin, origin);
    }

    private final Direction getRandomDirection() {
        Direction direction;
        if (this.lastMoveDirection != null) {
            Object object = CollectionsKt.random((Collection)CollectionsKt.minus((Iterable)directions, (Object)this.lastMoveDirection), (Random)((Random)Random.Default));
            Intrinsics.checkNotNull((Object)object);
            direction = (Direction)object;
        } else {
            direction = (Direction)CollectionsKt.random((Collection)directions, (Random)((Random)Random.Default));
        }
        return direction;
    }

    private final boolean tryMoveToDirection(Level level, Direction direction) {
        BlockPos horizontalShifted = this.currentPos.m_121945_(direction);
        Intrinsics.checkNotNull((Object)horizontalShifted);
        if (UtilsKt.horizontalDistanceTo(horizontalShifted, this.center) > (double)((Number)ModConfig.FireGrenade.INSTANCE.getFIRE_RANGE().get()).intValue()) {
            return false;
        }
        BlockPos blockPos = horizontalShifted.m_7494_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
        Pair pair = SpreadPathData.Companion.getGroundBelow(level, blockPos);
        if (pair == null) {
            return false;
        }
        Pair groundCalculateResult = pair;
        if (((Number)groundCalculateResult.getSecond()).intValue() == 0) {
            if (level.m_8055_(horizontalShifted.m_7494_().m_7494_()).m_60795_() && level.m_8055_(this.currentPos.m_7494_()).m_60795_() && this.jumpCount < 3) {
                int n = this.jumpCount;
                this.jumpCount = n + 1;
            } else {
                return false;
            }
        }
        if (this.visited.contains(groundCalculateResult.getFirst())) {
            return false;
        }
        this.visited.add((BlockPos)groundCalculateResult.getFirst());
        this.currentPos = (BlockPos)groundCalculateResult.getFirst();
        return true;
    }

    public final void randomMoveOnce(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        for (int i = 0; i < 5; ++i) {
            Direction direction = this.getRandomDirection();
            if (!this.tryMoveToDirection(level, direction)) continue;
            this.lastMoveDirection = direction;
        }
    }

    static {
        Object[] objectArray = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        directions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lclub/pisquad/minecraft/csgrenades/entity/SpreadPathData$Companion;", "", "<init>", "()V", "directions", "", "Lnet/minecraft/core/Direction;", "getDirections", "()Ljava/util/List;", "getGroundBelow", "Lkotlin/Pair;", "Lnet/minecraft/core/BlockPos;", "", "level", "Lnet/minecraft/world/level/Level;", "origin", "csgrenades"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Direction> getDirections() {
            return directions;
        }

        private final Pair<BlockPos, Integer> getGroundBelow(Level level, BlockPos origin) {
            ClipContext it = new ClipContext(origin.m_252807_(), origin.m_7918_(0, -((Number)ModConfig.FireGrenade.INSTANCE.getFIRE_MAX_SPREAD_DOWNWARD().get()).intValue(), 0).m_252807_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null);
            boolean bl = false;
            BlockHitResult clipResult = level.m_45547_(it);
            return clipResult.m_6662_() == HitResult.Type.MISS ? null : new Pair((Object)clipResult.m_82425_(), (Object)(origin.m_123342_() - clipResult.m_82425_().m_123342_()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

