/*
 * Decompiled with CFR 0.152.
 */
package club.pisquad.minecraft.csgrenades.sound;

import club.pisquad.minecraft.csgrenades.registery.ModSoundEvents;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lclub/pisquad/minecraft/csgrenades/sound/FlashbangRingSound;", "Lnet/minecraft/client/resources/sounds/AbstractTickableSoundInstance;", "attack", "", "sustain", "decay", "targetVolume", "", "startTime", "Ljava/time/Instant;", "<init>", "(IIIFLjava/time/Instant;)V", "getAttack", "()I", "getSustain", "getDecay", "getTargetVolume", "()F", "tick", "", "csgrenades"})
public final class FlashbangRingSound
extends AbstractTickableSoundInstance {
    private final int attack;
    private final int sustain;
    private final int decay;
    private final float targetVolume;
    @NotNull
    private final Instant startTime;

    public FlashbangRingSound(int attack, int sustain, int decay, float targetVolume, @NotNull Instant startTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        super((SoundEvent)ModSoundEvents.INSTANCE.getFLASHBANG_EXPLOSION_RING().get(), SoundSource.MASTER, RandomSource.m_216343_());
        this.attack = attack;
        this.sustain = sustain;
        this.decay = decay;
        this.targetVolume = targetVolume;
        this.startTime = startTime;
        this.f_119578_ = true;
        this.f_119574_ = 1.0f;
        this.f_119580_ = SoundInstance.Attenuation.NONE;
        this.f_119573_ = this.targetVolume;
    }

    public /* synthetic */ FlashbangRingSound(int n, int n2, int n3, float f, Instant instant, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 0x10) != 0) {
            instant = Instant.now();
        }
        this(n, n2, n3, f, instant);
    }

    public final int getAttack() {
        return this.attack;
    }

    public final int getSustain() {
        return this.sustain;
    }

    public final int getDecay() {
        return this.decay;
    }

    public final float getTargetVolume() {
        return this.targetVolume;
    }

    public void m_7788_() {
        Instant timeNow = Instant.now();
        double timeDelta = Duration.between(this.startTime, timeNow).toMillis();
        if (timeDelta < (double)this.attack) {
            this.f_119573_ = (float)(timeDelta / (double)this.attack) * this.targetVolume;
        } else if (timeDelta < (double)(this.attack + this.sustain)) {
            this.f_119573_ = this.targetVolume;
        } else if (timeDelta < (double)(this.attack + this.sustain + this.decay)) {
            this.f_119573_ = this.targetVolume * (float)(1.0 - (timeDelta - (double)this.attack - (double)this.sustain) / (double)this.decay);
        } else {
            this.m_119609_();
        }
    }
}

