/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thedeepvoid.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelgravekeeper<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("the_deep_void", "modelgravekeeper"), "main");
    public final ModelPart left_leg;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart right_leg;
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart tiny_head1;
    public final ModelPart tiny_head2;
    public final ModelPart tiny_head3;
    public final ModelPart tiny_head4;

    public Modelgravekeeper(ModelPart root) {
        this.left_leg = root.getChild("left_leg");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.right_leg = root.getChild("right_leg");
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.tiny_head1 = root.getChild("tiny_head1");
        this.tiny_head2 = root.getChild("tiny_head2");
        this.tiny_head3 = root.getChild("tiny_head3");
        this.tiny_head4 = root.getChild("tiny_head4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(50, 0).addBox(-1.0f, 0.0f, -1.0f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(42, 58).addBox(0.0f, 0.0f, -4.0f, 0.0f, 24.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(12, 45).addBox(0.0f, -1.0f, -1.0f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(22, 6).addBox(1.0f, -1.0f, -5.0f, 0.0f, 28.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-13.0f, (float)2.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(0, 45).addBox(-3.0f, -1.0f, -1.0f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 6).addBox(-1.0f, -1.0f, -5.0f, 0.0f, 28.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-13.0f, (float)2.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(24, 45).addBox(-2.0f, 0.0f, -1.0f, 3.0f, 24.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(36, 58).addBox(0.0f, 0.0f, -4.0f, 0.0f, 24.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(39, 40).addBox(-5.0f, -16.0f, -2.0f, 10.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-14.0f, (float)1.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -10.0f, -5.0f, 18.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tiny_head1 = partdefinition.addOrReplaceChild("tiny_head1", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)-9.0f, (float)0.0f));
        PartDefinition cube_r2 = tiny_head1.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(62, 0).addBox(-2.0f, -5.0f, -4.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)2.0f, (float)0.0f, (float)0.1309f, (float)-0.1745f, (float)0.0f));
        PartDefinition tiny_head2 = partdefinition.addOrReplaceChild("tiny_head2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.0f, (float)-4.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = tiny_head2.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(48, 61).addBox(-3.0f, -5.0f, -4.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)2.0f, (float)0.0f, (float)0.1309f, (float)0.1745f, (float)0.0f));
        PartDefinition tiny_head3 = partdefinition.addOrReplaceChild("tiny_head3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)1.0f, (float)-10.0f, (float)3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r4 = tiny_head3.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(59, 22).addBox(-3.0f, -5.0f, -1.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)2.0f, (float)0.0f, (float)-0.1309f, (float)-0.1745f, (float)0.0f));
        PartDefinition tiny_head4 = partdefinition.addOrReplaceChild("tiny_head4", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)-2.0f, (float)2.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r5 = tiny_head4.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(44, 27).addBox(-2.0f, -5.0f, -1.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)2.0f, (float)0.0f, (float)-0.1309f, (float)0.1745f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tiny_head1.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tiny_head2.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tiny_head3.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.tiny_head4.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.tiny_head2.yRot = netHeadYaw / 57.295776f;
        this.tiny_head2.xRot = headPitch / 57.295776f;
        this.tiny_head1.yRot = netHeadYaw / 57.295776f;
        this.tiny_head1.xRot = headPitch / 57.295776f;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.tiny_head4.yRot = netHeadYaw / 57.295776f;
        this.tiny_head4.xRot = headPitch / 57.295776f;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.tiny_head3.yRot = netHeadYaw / 57.295776f;
        this.tiny_head3.xRot = headPitch / 57.295776f;
    }
}

