/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thedeepvoid.network;

import java.util.function.Supplier;
import net.mcreator.thedeepvoid.TheDeepVoidMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TheDeepVoidModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        TheDeepVoidMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        TheDeepVoidMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.StalkerCount = message.data.StalkerCount;
                    variables.ForgottenValleyAmbientSound = message.data.ForgottenValleyAmbientSound;
                    variables.StalkerSpawn = message.data.StalkerSpawn;
                    variables.StalkerCountFinish = message.data.StalkerCountFinish;
                    variables.playerX = message.data.playerX;
                    variables.playerY = message.data.playerY;
                    variables.playerZ = message.data.playerZ;
                    variables.RottenArmorAbility = message.data.RottenArmorAbility;
                    variables.hallucinate = message.data.hallucinate;
                    variables.StalkerStalkCount = message.data.StalkerStalkCount;
                    variables.VoidCaveAmbientSound = message.data.VoidCaveAmbientSound;
                    variables.VoidCloakAbility = message.data.VoidCloakAbility;
                    variables.InCreative = message.data.InCreative;
                    variables.InAdventure = message.data.InAdventure;
                    variables.cave_tremble = message.data.cave_tremble;
                    variables.darkness_absorption = message.data.darkness_absorption;
                    variables.seek_light = message.data.seek_light;
                    variables.playerCallOfTheVoid = message.data.playerCallOfTheVoid;
                    variables.hallucinating = message.data.hallucinating;
                    variables.deathgrounds_ambience = message.data.deathgrounds_ambience;
                    variables.flesh_roar = message.data.flesh_roar;
                    variables.armorToggle = message.data.armorToggle;
                    variables.monolithAmbience = message.data.monolithAmbience;
                    variables.hasteAllSeeing = message.data.hasteAllSeeing;
                    variables.allseeingArmor = message.data.allseeingArmor;
                    variables.hallucinateX = message.data.hallucinateX;
                    variables.hallucinateY = message.data.hallucinateY;
                    variables.hallucinateZ = message.data.hallucinateZ;
                    variables.soundHallX = message.data.soundHallX;
                    variables.soundHallY = message.data.soundHallY;
                    variables.soundHallZ = message.data.soundHallZ;
                    variables.hallucinateHurt = message.data.hallucinateHurt;
                    variables.nestAmbience = message.data.nestAmbience;
                    variables.InSurvival = message.data.InSurvival;
                    variables.darknessDamageBuildUp = message.data.darknessDamageBuildUp;
                    variables.motherCallOutCooldown = message.data.motherCallOutCooldown;
                    variables.motherlyCallCooldown = message.data.motherlyCallCooldown;
                    variables.FallSound = message.data.FallSound;
                    variables.healthBoostLevel = message.data.healthBoostLevel;
                    variables.healthMask = message.data.healthMask;
                    variables.grimRottenArmorAttack = message.data.grimRottenArmorAttack;
                    variables.SendToHell = message.data.SendToHell;
                    variables.naturalTeleport = message.data.naturalTeleport;
                    variables.weaverBoots = message.data.weaverBoots;
                    variables.randomStalkerValue = message.data.randomStalkerValue;
                    variables.stalkingCount = message.data.stalkingCount;
                    variables.stalkWatcherCount = message.data.stalkWatcherCount;
                    variables.noGravity = message.data.noGravity;
                    variables.heartbeatIndicator = message.data.heartbeatIndicator;
                    variables.hasSoulOrb = message.data.hasSoulOrb;
                    variables.teleportToVoid = message.data.teleportToVoid;
                    variables.weaverRobeCooldown = message.data.weaverRobeCooldown;
                    variables.gatheringAmbience = message.data.gatheringAmbience;
                    variables.attackedByAnimosity = message.data.attackedByAnimosity;
                    variables.eyekinCooldown = message.data.eyekinCooldown;
                    variables.eyekinDash = message.data.eyekinDash;
                    variables.wingFlapSound = message.data.wingFlapSound;
                    variables.hookX = message.data.hookX;
                    variables.hookY = message.data.hookY;
                    variables.hookZ = message.data.hookZ;
                    variables.hooked = message.data.hooked;
                    variables.voidriumTeleport = message.data.voidriumTeleport;
                    variables.noEscape = message.data.noEscape;
                    variables.hiveCallX = message.data.hiveCallX;
                    variables.hiveCallY = message.data.hiveCallY;
                    variables.hiveCallZ = message.data.hiveCallZ;
                    variables.hunterArmorAbility = message.data.hunterArmorAbility;
                    variables.mistedRemnantAmbience = message.data.mistedRemnantAmbience;
                    variables.saveArmor3 = message.data.saveArmor3;
                    variables.saveArmor2 = message.data.saveArmor2;
                    variables.saveArmor1 = message.data.saveArmor1;
                    variables.saveArmor0 = message.data.saveArmor0;
                    variables.saveArmorPoint = message.data.saveArmorPoint;
                    variables.gaol_ambience = message.data.gaol_ambience;
                    variables.noHit = message.data.noHit;
                    variables.MusicTick = message.data.MusicTick;
                    variables.MusicWait = message.data.MusicWait;
                    variables.MusicLock = message.data.MusicLock;
                    variables.MusicReplace = message.data.MusicReplace;
                    variables.MusicPlay = message.data.MusicPlay;
                    variables.watcherFightCount = message.data.watcherFightCount;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double StalkerCount = 0.0;
        public double ForgottenValleyAmbientSound = 0.0;
        public boolean StalkerSpawn = false;
        public boolean StalkerCountFinish = false;
        public double playerX = 0.0;
        public double playerY = 0.0;
        public double playerZ = 0.0;
        public double RottenArmorAbility = 0.0;
        public double hallucinate = 0.0;
        public double StalkerStalkCount = 0.0;
        public double VoidCaveAmbientSound = 0.0;
        public double VoidCloakAbility = 0.0;
        public boolean InCreative = false;
        public boolean InAdventure = false;
        public double cave_tremble = 0.0;
        public double darkness_absorption = 0.0;
        public boolean seek_light = false;
        public boolean playerCallOfTheVoid = false;
        public boolean hallucinating = false;
        public double deathgrounds_ambience = 0.0;
        public double flesh_roar = 0.0;
        public boolean armorToggle = false;
        public double monolithAmbience = 0.0;
        public double hasteAllSeeing = 0.0;
        public double allseeingArmor = 0.0;
        public double hallucinateX = 0.0;
        public double hallucinateY = 0.0;
        public double hallucinateZ = 0.0;
        public double soundHallX = 0.0;
        public double soundHallY = 0.0;
        public double soundHallZ = 0.0;
        public double hallucinateHurt = 0.0;
        public double nestAmbience = 0.0;
        public boolean InSurvival = false;
        public double darknessDamageBuildUp = 0.0;
        public double motherCallOutCooldown = 0.0;
        public double motherlyCallCooldown = 0.0;
        public boolean FallSound = false;
        public double healthBoostLevel = 0.0;
        public double healthMask = 0.0;
        public boolean grimRottenArmorAttack = false;
        public boolean SendToHell = false;
        public boolean naturalTeleport = false;
        public double weaverBoots = 0.0;
        public double randomStalkerValue = 0.0;
        public double stalkingCount = 0.0;
        public double stalkWatcherCount = 0.0;
        public boolean noGravity = false;
        public double heartbeatIndicator = 0.0;
        public boolean hasSoulOrb = false;
        public boolean teleportToVoid = false;
        public double weaverRobeCooldown = 0.0;
        public double gatheringAmbience = 0.0;
        public boolean attackedByAnimosity = false;
        public double eyekinCooldown = 0.0;
        public double eyekinDash = 0.0;
        public double wingFlapSound = 0.0;
        public double hookX = 0.0;
        public double hookY = 0.0;
        public double hookZ = 0.0;
        public boolean hooked = false;
        public double voidriumTeleport = 0.0;
        public boolean noEscape = false;
        public double hiveCallX = 0.0;
        public double hiveCallY = 0.0;
        public double hiveCallZ = 0.0;
        public double hunterArmorAbility = 0.0;
        public double mistedRemnantAmbience = 0.0;
        public ItemStack saveArmor3 = ItemStack.f_41583_;
        public ItemStack saveArmor2 = ItemStack.f_41583_;
        public ItemStack saveArmor1 = ItemStack.f_41583_;
        public ItemStack saveArmor0 = ItemStack.f_41583_;
        public double saveArmorPoint = 0.0;
        public double gaol_ambience = 0.0;
        public boolean noHit = true;
        public double MusicTick = 0.0;
        public double MusicWait = 0.0;
        public boolean MusicLock = false;
        public boolean MusicReplace = false;
        public String MusicPlay = "\"\"";
        public double watcherFightCount = 0.0;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                TheDeepVoidMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("StalkerCount", this.StalkerCount);
            nbt.m_128347_("ForgottenValleyAmbientSound", this.ForgottenValleyAmbientSound);
            nbt.m_128379_("StalkerSpawn", this.StalkerSpawn);
            nbt.m_128379_("StalkerCountFinish", this.StalkerCountFinish);
            nbt.m_128347_("playerX", this.playerX);
            nbt.m_128347_("playerY", this.playerY);
            nbt.m_128347_("playerZ", this.playerZ);
            nbt.m_128347_("RottenArmorAbility", this.RottenArmorAbility);
            nbt.m_128347_("hallucinate", this.hallucinate);
            nbt.m_128347_("StalkerStalkCount", this.StalkerStalkCount);
            nbt.m_128347_("VoidCaveAmbientSound", this.VoidCaveAmbientSound);
            nbt.m_128347_("VoidCloakAbility", this.VoidCloakAbility);
            nbt.m_128379_("InCreative", this.InCreative);
            nbt.m_128379_("InAdventure", this.InAdventure);
            nbt.m_128347_("cave_tremble", this.cave_tremble);
            nbt.m_128347_("darkness_absorption", this.darkness_absorption);
            nbt.m_128379_("seek_light", this.seek_light);
            nbt.m_128379_("playerCallOfTheVoid", this.playerCallOfTheVoid);
            nbt.m_128379_("hallucinating", this.hallucinating);
            nbt.m_128347_("deathgrounds_ambience", this.deathgrounds_ambience);
            nbt.m_128347_("flesh_roar", this.flesh_roar);
            nbt.m_128379_("armorToggle", this.armorToggle);
            nbt.m_128347_("monolithAmbience", this.monolithAmbience);
            nbt.m_128347_("hasteAllSeeing", this.hasteAllSeeing);
            nbt.m_128347_("allseeingArmor", this.allseeingArmor);
            nbt.m_128347_("hallucinateX", this.hallucinateX);
            nbt.m_128347_("hallucinateY", this.hallucinateY);
            nbt.m_128347_("hallucinateZ", this.hallucinateZ);
            nbt.m_128347_("soundHallX", this.soundHallX);
            nbt.m_128347_("soundHallY", this.soundHallY);
            nbt.m_128347_("soundHallZ", this.soundHallZ);
            nbt.m_128347_("hallucinateHurt", this.hallucinateHurt);
            nbt.m_128347_("nestAmbience", this.nestAmbience);
            nbt.m_128379_("InSurvival", this.InSurvival);
            nbt.m_128347_("darknessDamageBuildUp", this.darknessDamageBuildUp);
            nbt.m_128347_("motherCallOutCooldown", this.motherCallOutCooldown);
            nbt.m_128347_("motherlyCallCooldown", this.motherlyCallCooldown);
            nbt.m_128379_("FallSound", this.FallSound);
            nbt.m_128347_("healthBoostLevel", this.healthBoostLevel);
            nbt.m_128347_("healthMask", this.healthMask);
            nbt.m_128379_("grimRottenArmorAttack", this.grimRottenArmorAttack);
            nbt.m_128379_("SendToHell", this.SendToHell);
            nbt.m_128379_("naturalTeleport", this.naturalTeleport);
            nbt.m_128347_("weaverBoots", this.weaverBoots);
            nbt.m_128347_("randomStalkerValue", this.randomStalkerValue);
            nbt.m_128347_("stalkingCount", this.stalkingCount);
            nbt.m_128347_("stalkWatcherCount", this.stalkWatcherCount);
            nbt.m_128379_("noGravity", this.noGravity);
            nbt.m_128347_("heartbeatIndicator", this.heartbeatIndicator);
            nbt.m_128379_("hasSoulOrb", this.hasSoulOrb);
            nbt.m_128379_("teleportToVoid", this.teleportToVoid);
            nbt.m_128347_("weaverRobeCooldown", this.weaverRobeCooldown);
            nbt.m_128347_("gatheringAmbience", this.gatheringAmbience);
            nbt.m_128379_("attackedByAnimosity", this.attackedByAnimosity);
            nbt.m_128347_("eyekinCooldown", this.eyekinCooldown);
            nbt.m_128347_("eyekinDash", this.eyekinDash);
            nbt.m_128347_("wingFlapSound", this.wingFlapSound);
            nbt.m_128347_("hookX", this.hookX);
            nbt.m_128347_("hookY", this.hookY);
            nbt.m_128347_("hookZ", this.hookZ);
            nbt.m_128379_("hooked", this.hooked);
            nbt.m_128347_("voidriumTeleport", this.voidriumTeleport);
            nbt.m_128379_("noEscape", this.noEscape);
            nbt.m_128347_("hiveCallX", this.hiveCallX);
            nbt.m_128347_("hiveCallY", this.hiveCallY);
            nbt.m_128347_("hiveCallZ", this.hiveCallZ);
            nbt.m_128347_("hunterArmorAbility", this.hunterArmorAbility);
            nbt.m_128347_("mistedRemnantAmbience", this.mistedRemnantAmbience);
            nbt.m_128365_("saveArmor3", (Tag)this.saveArmor3.m_41739_(new CompoundTag()));
            nbt.m_128365_("saveArmor2", (Tag)this.saveArmor2.m_41739_(new CompoundTag()));
            nbt.m_128365_("saveArmor1", (Tag)this.saveArmor1.m_41739_(new CompoundTag()));
            nbt.m_128365_("saveArmor0", (Tag)this.saveArmor0.m_41739_(new CompoundTag()));
            nbt.m_128347_("saveArmorPoint", this.saveArmorPoint);
            nbt.m_128347_("gaol_ambience", this.gaol_ambience);
            nbt.m_128379_("noHit", this.noHit);
            nbt.m_128347_("MusicTick", this.MusicTick);
            nbt.m_128347_("MusicWait", this.MusicWait);
            nbt.m_128379_("MusicLock", this.MusicLock);
            nbt.m_128379_("MusicReplace", this.MusicReplace);
            nbt.m_128359_("MusicPlay", this.MusicPlay);
            nbt.m_128347_("watcherFightCount", this.watcherFightCount);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.StalkerCount = nbt.m_128459_("StalkerCount");
            this.ForgottenValleyAmbientSound = nbt.m_128459_("ForgottenValleyAmbientSound");
            this.StalkerSpawn = nbt.m_128471_("StalkerSpawn");
            this.StalkerCountFinish = nbt.m_128471_("StalkerCountFinish");
            this.playerX = nbt.m_128459_("playerX");
            this.playerY = nbt.m_128459_("playerY");
            this.playerZ = nbt.m_128459_("playerZ");
            this.RottenArmorAbility = nbt.m_128459_("RottenArmorAbility");
            this.hallucinate = nbt.m_128459_("hallucinate");
            this.StalkerStalkCount = nbt.m_128459_("StalkerStalkCount");
            this.VoidCaveAmbientSound = nbt.m_128459_("VoidCaveAmbientSound");
            this.VoidCloakAbility = nbt.m_128459_("VoidCloakAbility");
            this.InCreative = nbt.m_128471_("InCreative");
            this.InAdventure = nbt.m_128471_("InAdventure");
            this.cave_tremble = nbt.m_128459_("cave_tremble");
            this.darkness_absorption = nbt.m_128459_("darkness_absorption");
            this.seek_light = nbt.m_128471_("seek_light");
            this.playerCallOfTheVoid = nbt.m_128471_("playerCallOfTheVoid");
            this.hallucinating = nbt.m_128471_("hallucinating");
            this.deathgrounds_ambience = nbt.m_128459_("deathgrounds_ambience");
            this.flesh_roar = nbt.m_128459_("flesh_roar");
            this.armorToggle = nbt.m_128471_("armorToggle");
            this.monolithAmbience = nbt.m_128459_("monolithAmbience");
            this.hasteAllSeeing = nbt.m_128459_("hasteAllSeeing");
            this.allseeingArmor = nbt.m_128459_("allseeingArmor");
            this.hallucinateX = nbt.m_128459_("hallucinateX");
            this.hallucinateY = nbt.m_128459_("hallucinateY");
            this.hallucinateZ = nbt.m_128459_("hallucinateZ");
            this.soundHallX = nbt.m_128459_("soundHallX");
            this.soundHallY = nbt.m_128459_("soundHallY");
            this.soundHallZ = nbt.m_128459_("soundHallZ");
            this.hallucinateHurt = nbt.m_128459_("hallucinateHurt");
            this.nestAmbience = nbt.m_128459_("nestAmbience");
            this.InSurvival = nbt.m_128471_("InSurvival");
            this.darknessDamageBuildUp = nbt.m_128459_("darknessDamageBuildUp");
            this.motherCallOutCooldown = nbt.m_128459_("motherCallOutCooldown");
            this.motherlyCallCooldown = nbt.m_128459_("motherlyCallCooldown");
            this.FallSound = nbt.m_128471_("FallSound");
            this.healthBoostLevel = nbt.m_128459_("healthBoostLevel");
            this.healthMask = nbt.m_128459_("healthMask");
            this.grimRottenArmorAttack = nbt.m_128471_("grimRottenArmorAttack");
            this.SendToHell = nbt.m_128471_("SendToHell");
            this.naturalTeleport = nbt.m_128471_("naturalTeleport");
            this.weaverBoots = nbt.m_128459_("weaverBoots");
            this.randomStalkerValue = nbt.m_128459_("randomStalkerValue");
            this.stalkingCount = nbt.m_128459_("stalkingCount");
            this.stalkWatcherCount = nbt.m_128459_("stalkWatcherCount");
            this.noGravity = nbt.m_128471_("noGravity");
            this.heartbeatIndicator = nbt.m_128459_("heartbeatIndicator");
            this.hasSoulOrb = nbt.m_128471_("hasSoulOrb");
            this.teleportToVoid = nbt.m_128471_("teleportToVoid");
            this.weaverRobeCooldown = nbt.m_128459_("weaverRobeCooldown");
            this.gatheringAmbience = nbt.m_128459_("gatheringAmbience");
            this.attackedByAnimosity = nbt.m_128471_("attackedByAnimosity");
            this.eyekinCooldown = nbt.m_128459_("eyekinCooldown");
            this.eyekinDash = nbt.m_128459_("eyekinDash");
            this.wingFlapSound = nbt.m_128459_("wingFlapSound");
            this.hookX = nbt.m_128459_("hookX");
            this.hookY = nbt.m_128459_("hookY");
            this.hookZ = nbt.m_128459_("hookZ");
            this.hooked = nbt.m_128471_("hooked");
            this.voidriumTeleport = nbt.m_128459_("voidriumTeleport");
            this.noEscape = nbt.m_128471_("noEscape");
            this.hiveCallX = nbt.m_128459_("hiveCallX");
            this.hiveCallY = nbt.m_128459_("hiveCallY");
            this.hiveCallZ = nbt.m_128459_("hiveCallZ");
            this.hunterArmorAbility = nbt.m_128459_("hunterArmorAbility");
            this.mistedRemnantAmbience = nbt.m_128459_("mistedRemnantAmbience");
            this.saveArmor3 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("saveArmor3"));
            this.saveArmor2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("saveArmor2"));
            this.saveArmor1 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("saveArmor1"));
            this.saveArmor0 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("saveArmor0"));
            this.saveArmorPoint = nbt.m_128459_("saveArmorPoint");
            this.gaol_ambience = nbt.m_128459_("gaol_ambience");
            this.noHit = nbt.m_128471_("noHit");
            this.MusicTick = nbt.m_128459_("MusicTick");
            this.MusicWait = nbt.m_128459_("MusicWait");
            this.MusicLock = nbt.m_128471_("MusicLock");
            this.MusicReplace = nbt.m_128471_("MusicReplace");
            this.MusicPlay = nbt.m_128461_("MusicPlay");
            this.watcherFightCount = nbt.m_128459_("watcherFightCount");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("the_deep_void", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "the_deep_void_mapvars";
        public boolean CultTemplePlaced = false;
        public boolean StalkerDespawned = false;
        public double breathingHillsAmbience = 0.0;
        public double breathingHillsHeart = 0.0;
        public boolean WeaverTemplePlaced = false;
        public double stalkerSpawnX = 0.0;
        public double stalkerSpawnZ = 0.0;
        public double weaverFightCount = 0.0;
        public boolean overwritten = false;
        public boolean surfaceOverwritten = false;
        public double apostleFightCount = 0.0;
        public double hivemindFightCount = 0.0;
        public double primordialcrawlerFightCount = 0.0;
        public double hunterSpawnCooldown = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.CultTemplePlaced = nbt.m_128471_("CultTemplePlaced");
            this.StalkerDespawned = nbt.m_128471_("StalkerDespawned");
            this.breathingHillsAmbience = nbt.m_128459_("breathingHillsAmbience");
            this.breathingHillsHeart = nbt.m_128459_("breathingHillsHeart");
            this.WeaverTemplePlaced = nbt.m_128471_("WeaverTemplePlaced");
            this.stalkerSpawnX = nbt.m_128459_("stalkerSpawnX");
            this.stalkerSpawnZ = nbt.m_128459_("stalkerSpawnZ");
            this.weaverFightCount = nbt.m_128459_("weaverFightCount");
            this.overwritten = nbt.m_128471_("overwritten");
            this.surfaceOverwritten = nbt.m_128471_("surfaceOverwritten");
            this.apostleFightCount = nbt.m_128459_("apostleFightCount");
            this.hivemindFightCount = nbt.m_128459_("hivemindFightCount");
            this.primordialcrawlerFightCount = nbt.m_128459_("primordialcrawlerFightCount");
            this.hunterSpawnCooldown = nbt.m_128459_("hunterSpawnCooldown");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("CultTemplePlaced", this.CultTemplePlaced);
            nbt.m_128379_("StalkerDespawned", this.StalkerDespawned);
            nbt.m_128347_("breathingHillsAmbience", this.breathingHillsAmbience);
            nbt.m_128347_("breathingHillsHeart", this.breathingHillsHeart);
            nbt.m_128379_("WeaverTemplePlaced", this.WeaverTemplePlaced);
            nbt.m_128347_("stalkerSpawnX", this.stalkerSpawnX);
            nbt.m_128347_("stalkerSpawnZ", this.stalkerSpawnZ);
            nbt.m_128347_("weaverFightCount", this.weaverFightCount);
            nbt.m_128379_("overwritten", this.overwritten);
            nbt.m_128379_("surfaceOverwritten", this.surfaceOverwritten);
            nbt.m_128347_("apostleFightCount", this.apostleFightCount);
            nbt.m_128347_("hivemindFightCount", this.hivemindFightCount);
            nbt.m_128347_("primordialcrawlerFightCount", this.primordialcrawlerFightCount);
            nbt.m_128347_("hunterSpawnCooldown", this.hunterSpawnCooldown);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                TheDeepVoidMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "the_deep_void_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                TheDeepVoidMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.StalkerCount = original.StalkerCount;
            clone.ForgottenValleyAmbientSound = original.ForgottenValleyAmbientSound;
            clone.StalkerSpawn = original.StalkerSpawn;
            clone.StalkerCountFinish = original.StalkerCountFinish;
            clone.hallucinate = original.hallucinate;
            clone.StalkerStalkCount = original.StalkerStalkCount;
            clone.VoidCaveAmbientSound = original.VoidCaveAmbientSound;
            clone.InCreative = original.InCreative;
            clone.InAdventure = original.InAdventure;
            clone.cave_tremble = original.cave_tremble;
            clone.seek_light = original.seek_light;
            clone.playerCallOfTheVoid = original.playerCallOfTheVoid;
            clone.InSurvival = original.InSurvival;
            clone.SendToHell = original.SendToHell;
            clone.randomStalkerValue = original.randomStalkerValue;
            clone.stalkingCount = original.stalkingCount;
            clone.stalkWatcherCount = original.stalkWatcherCount;
            clone.noGravity = original.noGravity;
            clone.teleportToVoid = original.teleportToVoid;
            clone.hiveCallX = original.hiveCallX;
            clone.hiveCallY = original.hiveCallY;
            clone.hiveCallZ = original.hiveCallZ;
            clone.saveArmor3 = original.saveArmor3;
            clone.saveArmor2 = original.saveArmor2;
            clone.saveArmor1 = original.saveArmor1;
            clone.saveArmor0 = original.saveArmor0;
            clone.saveArmorPoint = original.saveArmorPoint;
            clone.MusicTick = original.MusicTick;
            clone.MusicWait = original.MusicWait;
            clone.MusicLock = original.MusicLock;
            clone.MusicReplace = original.MusicReplace;
            clone.MusicPlay = original.MusicPlay;
            clone.watcherFightCount = original.watcherFightCount;
            if (!event.isWasDeath()) {
                clone.playerX = original.playerX;
                clone.playerY = original.playerY;
                clone.playerZ = original.playerZ;
                clone.RottenArmorAbility = original.RottenArmorAbility;
                clone.VoidCloakAbility = original.VoidCloakAbility;
                clone.darkness_absorption = original.darkness_absorption;
                clone.hallucinating = original.hallucinating;
                clone.deathgrounds_ambience = original.deathgrounds_ambience;
                clone.flesh_roar = original.flesh_roar;
                clone.armorToggle = original.armorToggle;
                clone.monolithAmbience = original.monolithAmbience;
                clone.hasteAllSeeing = original.hasteAllSeeing;
                clone.allseeingArmor = original.allseeingArmor;
                clone.hallucinateX = original.hallucinateX;
                clone.hallucinateY = original.hallucinateY;
                clone.hallucinateZ = original.hallucinateZ;
                clone.soundHallX = original.soundHallX;
                clone.soundHallY = original.soundHallY;
                clone.soundHallZ = original.soundHallZ;
                clone.hallucinateHurt = original.hallucinateHurt;
                clone.nestAmbience = original.nestAmbience;
                clone.darknessDamageBuildUp = original.darknessDamageBuildUp;
                clone.motherCallOutCooldown = original.motherCallOutCooldown;
                clone.motherlyCallCooldown = original.motherlyCallCooldown;
                clone.FallSound = original.FallSound;
                clone.healthBoostLevel = original.healthBoostLevel;
                clone.healthMask = original.healthMask;
                clone.grimRottenArmorAttack = original.grimRottenArmorAttack;
                clone.naturalTeleport = original.naturalTeleport;
                clone.weaverBoots = original.weaverBoots;
                clone.heartbeatIndicator = original.heartbeatIndicator;
                clone.hasSoulOrb = original.hasSoulOrb;
                clone.weaverRobeCooldown = original.weaverRobeCooldown;
                clone.gatheringAmbience = original.gatheringAmbience;
                clone.attackedByAnimosity = original.attackedByAnimosity;
                clone.eyekinCooldown = original.eyekinCooldown;
                clone.eyekinDash = original.eyekinDash;
                clone.wingFlapSound = original.wingFlapSound;
                clone.hookX = original.hookX;
                clone.hookY = original.hookY;
                clone.hookZ = original.hookZ;
                clone.hooked = original.hooked;
                clone.voidriumTeleport = original.voidriumTeleport;
                clone.noEscape = original.noEscape;
                clone.hunterArmorAbility = original.hunterArmorAbility;
                clone.mistedRemnantAmbience = original.mistedRemnantAmbience;
                clone.gaol_ambience = original.gaol_ambience;
                clone.noHit = original.noHit;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    TheDeepVoidMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    TheDeepVoidMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                TheDeepVoidMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

