/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import java.util.HashMap;
import java.util.Map;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.IDimensionInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;

public class BiomeInfo {
    private static final Map<ChunkCoord, BiomeInfo> BIOME_INFO_MAP = new HashMap<ChunkCoord, BiomeInfo>();
    private Holder<Biome> mainBiome;
    private static int cleanCacheCounter = 2000;

    public static void cleanCache() {
        BIOME_INFO_MAP.clear();
    }

    private static void cleanCacheUnloaded(WorldGenLevel level, ResourceKey<Level> dimension) {
        Tools.cleanCacheMap(level, dimension, BIOME_INFO_MAP);
    }

    public static BiomeInfo getBiomeInfo(IDimensionInfo provider, ChunkCoord coord) {
        if (--cleanCacheCounter < 0) {
            cleanCacheCounter = 2000;
            BiomeInfo.cleanCacheUnloaded(provider.getWorld(), provider.dimension());
        }
        if (!BIOME_INFO_MAP.containsKey(coord)) {
            BiomeInfo info = new BiomeInfo();
            ChunkHeightmap heightmap = provider.getHeightmap(coord);
            int chunkX = coord.chunkX();
            int chunkZ = coord.chunkZ();
            info.mainBiome = provider.getBiome(new BlockPos((chunkX << 4) + 8, heightmap.getHeight(), (chunkZ << 4) + 8));
            BIOME_INFO_MAP.put(coord, info);
        }
        return BIOME_INFO_MAP.get(coord);
    }

    public Holder<Biome> getMainBiome() {
        return this.mainBiome;
    }
}

