/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.gen;

import mcjty.lostcities.api.RailChunkType;
import mcjty.lostcities.worldgen.ChunkDriver;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.Railway;
import mcjty.lostcities.worldgen.lost.Transform;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.BuildingPart;
import mcjty.lostcities.worldgen.lost.regassets.data.RailwayParts;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Railways {
    public static void generateRailwayDungeons(LostCityTerrainFeature feature, BuildingInfo info) {
        if (info.railDungeon == null) {
            return;
        }
        if (info.getZmin().getRailInfo().getType() == RailChunkType.HORIZONTAL || info.getZmax().getRailInfo().getType() == RailChunkType.HORIZONTAL) {
            int height = info.groundLevel + -18;
            feature.generatePart(info, info.railDungeon, Transform.ROTATE_NONE, 0, height, 0, LostCityTerrainFeature.HardAirSetting.AIR);
        }
    }

    public static void generateRailways(LostCityTerrainFeature feature, BuildingInfo info, Railway.RailChunkInfo railInfo, ChunkHeightmap heightmap) {
        int z;
        int maxh;
        BuildingPart part;
        IDimensionInfo provider = feature.provider;
        ChunkDriver driver = feature.driver;
        BlockState liquid = feature.liquid;
        BlockState air = Blocks.f_50016_.m_49966_();
        RailwayParts railwayParts = provider.getWorldStyle().getPartSelector().railwayParts();
        int height = info.groundLevel + railInfo.getLevel() * 6;
        RailChunkType type = railInfo.getType();
        Transform transform = Transform.ROTATE_NONE;
        boolean needsStaircase = false;
        boolean clearUpper = false;
        switch (type) {
            case NONE: {
                return;
            }
            case STATION_SURFACE: 
            case STATION_EXTENSION_SURFACE: {
                part = railInfo.getLevel() < info.cityLevel ? AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.stationUnderground())) : (railInfo.getPart() != null ? AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railInfo.getPart())) : AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.stationOpen())));
                clearUpper = true;
                break;
            }
            case STATION_UNDERGROUND: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.stationUndergroundStairs()));
                needsStaircase = true;
                break;
            }
            case STATION_EXTENSION_UNDERGROUND: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.stationUnderground()));
                break;
            }
            case RAILS_END_HERE: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.railsHorizontalEnd()));
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case HORIZONTAL: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.railsHorizontal()));
                RailChunkType type1 = info.getXmin().getRailInfo().getType();
                RailChunkType type2 = info.getXmax().getRailInfo().getType();
                if (type1.isStation() || type2.isStation() || driver.getBlock(3, height + 2, 3) != liquid || driver.getBlock(12, height + 2, 3) != liquid || driver.getBlock(3, height + 2, 12) != liquid || driver.getBlock(12, height + 2, 12) != liquid || driver.getBlock(3, height + 4, 7) != liquid || driver.getBlock(12, height + 4, 8) != liquid) break;
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.railsHorizontalWater()));
                break;
            }
            case VERTICAL: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.railsVertical()));
                if (driver.getBlock(3, height + 2, 3) == liquid && driver.getBlock(12, height + 2, 3) == liquid && driver.getBlock(3, height + 2, 12) == liquid && driver.getBlock(12, height + 2, 12) == liquid && driver.getBlock(3, height + 4, 7) == liquid && driver.getBlock(12, height + 4, 8) == liquid) {
                    part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.railsVerticalWater()));
                }
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case THREE_SPLIT: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.rails3Split()));
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case GOING_DOWN_TWO_FROM_SURFACE: 
            case GOING_DOWN_FURTHER: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.railsDown2()));
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case GOING_DOWN_ONE_FROM_SURFACE: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.railsDown1()));
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            case DOUBLE_BEND: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.railsBend()));
                if (railInfo.getDirection() != Railway.RailDirection.EAST) break;
                transform = Transform.MIRROR_X;
                break;
            }
            default: {
                part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.railsFlat()));
            }
        }
        int h = feature.generatePart(info, part, transform, 0, height, 0, LostCityTerrainFeature.HardAirSetting.AIR);
        if (clearUpper && h < (maxh = heightmap.getHeight() + 4)) {
            for (int x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    feature.clearRange(info, x, z, h, maxh, false);
                }
            }
        }
        Character railMainBlock = info.getCityStyle().getRailMainBlock();
        BlockState rail = info.getCompiledPalette().get(railMainBlock.charValue());
        if (rail == null) {
            throw new RuntimeException("Cannot find rail block '" + railMainBlock + "' for type '" + String.valueOf((Object)type) + "'!");
        }
        if (type == RailChunkType.HORIZONTAL) {
            if (info.getZmin().railDungeon != null) {
                for (z = 0; z < 4; ++z) {
                    driver.current(6, height + 1, z).add(rail).add(air).add(air);
                    driver.current(7, height + 1, z).add(rail).add(air).add(air);
                }
                for (z = 0; z < 3; ++z) {
                    driver.current(5, height + 2, z).add(rail).add(rail).add(rail);
                    driver.current(6, height + 4, z).block(rail);
                    driver.current(7, height + 4, z).block(rail);
                    driver.current(8, height + 2, z).add(rail).add(rail).add(rail);
                }
            }
            if (info.getZmax().railDungeon != null) {
                for (z = 0; z < 5; ++z) {
                    driver.current(6, height + 1, 15 - z).add(rail).add(air).add(air);
                    driver.current(7, height + 1, 15 - z).add(rail).add(air).add(air);
                }
                for (z = 0; z < 4; ++z) {
                    driver.current(5, height + 2, 15 - z).add(rail).add(rail).add(rail);
                    driver.current(6, height + 4, 15 - z).block(rail);
                    driver.current(7, height + 4, 15 - z).block(rail);
                    driver.current(8, height + 2, 15 - z).add(rail).add(rail).add(rail);
                }
            }
        }
        if (railInfo.getRails() < 3) {
            switch (railInfo.getType()) {
                case NONE: {
                    break;
                }
                case STATION_SURFACE: 
                case STATION_EXTENSION_SURFACE: 
                case STATION_UNDERGROUND: 
                case STATION_EXTENSION_UNDERGROUND: 
                case HORIZONTAL: {
                    int x;
                    if (railInfo.getRails() == 1) {
                        driver.current(0, height + 1, 5);
                        for (x = 0; x < 16; ++x) {
                            driver.block(rail).incX();
                        }
                        driver.current(0, height + 1, 9);
                        for (x = 0; x < 16; ++x) {
                            driver.block(rail).incX();
                        }
                    } else {
                        driver.current(0, height + 1, 7);
                        for (x = 0; x < 16; ++x) {
                            driver.block(rail).incX();
                        }
                    }
                    break;
                }
                case GOING_DOWN_TWO_FROM_SURFACE: 
                case GOING_DOWN_FURTHER: 
                case GOING_DOWN_ONE_FROM_SURFACE: {
                    int x;
                    if (railInfo.getRails() == 1) {
                        for (x = 0; x < 16; ++x) {
                            for (y = height + 1; y < height + part.getSliceCount(); ++y) {
                                driver.current(x, y, 5);
                                if (feature.getRailStates().contains(driver.getBlock())) {
                                    driver.block(rail);
                                }
                                driver.current(x, y, 9);
                                if (!feature.getRailStates().contains(driver.getBlock())) continue;
                                driver.block(rail);
                            }
                        }
                    } else {
                        for (x = 0; x < 16; ++x) {
                            for (y = height + 1; y < height + part.getSliceCount(); ++y) {
                                driver.current(x, y, 7);
                                if (!feature.getRailStates().contains(driver.getBlock())) continue;
                                driver.block(rail);
                            }
                        }
                    }
                    break;
                }
            }
        }
        if (needsStaircase) {
            part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.stationStaircase()));
            for (int i = railInfo.getLevel() + 1; i < info.cityLevel; ++i) {
                height = info.groundLevel + i * 6;
                feature.generatePart(info, part, transform, 0, height, 0, LostCityTerrainFeature.HardAirSetting.AIR);
            }
            height = info.groundLevel + info.cityLevel * 6;
            part = AssetRegistries.PARTS.getOrThrow((CommonLevelAccessor)provider.getWorld(), feature.getRandomPart(railwayParts.stationStaircaseSurface()));
            feature.generatePart(info, part, transform, 0, height, 0, LostCityTerrainFeature.HardAirSetting.AIR);
        }
    }
}

