/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.api.ILostCityAssetRegistry;
import mcjty.lostcities.worldgen.lost.regassets.IAsset;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.CommonLevelAccessor;

public class RegistryAssetRegistry<T extends ILostCityAsset, R>
implements ILostCityAssetRegistry<T> {
    private final Map<ResourceLocation, T> assets = new HashMap<ResourceLocation, T>();
    private final ResourceKey<Registry<R>> registryKey;
    private final Function<R, T> assetConstructor;

    public <S extends ILostCityAsset> ILostCityAssetRegistry<S> cast() {
        return this;
    }

    public RegistryAssetRegistry(ResourceKey<Registry<R>> registryKey, Function<R, T> assetConstructor) {
        this.registryKey = registryKey;
        this.assetConstructor = assetConstructor;
    }

    @Override
    public T get(CommonLevelAccessor level, String name) {
        if (name == null) {
            return null;
        }
        return this.get(level, DataTools.fromName(name));
    }

    @Nonnull
    public T getOrThrow(CommonLevelAccessor level, String name) {
        if (name == null) {
            throw new RuntimeException("Invalid name given to " + String.valueOf(this.registryKey.m_211136_()) + " getOrThrow!");
        }
        T result = this.get(level, DataTools.fromName(name));
        if (result == null) {
            throw new RuntimeException("Can't find '" + name + "' in " + String.valueOf(this.registryKey.m_211136_()) + "!");
        }
        return result;
    }

    @Nullable
    public T getOrWarn(CommonLevelAccessor level, String name) {
        if (name == null || name.trim().isEmpty()) {
            return null;
        }
        T rc = this.get(level, DataTools.fromName(name));
        if (rc == null) {
            LostCities.LOGGER.warn("Cannot find '" + name + "' in " + String.valueOf(this.registryKey.m_211136_()) + "!");
        }
        return rc;
    }

    @Override
    public T get(CommonLevelAccessor level, ResourceLocation name) {
        if (name == null) {
            return null;
        }
        ILostCityAsset t = (ILostCityAsset)this.assets.get(name);
        if (t == null) {
            try {
                Registry registry = level.m_9598_().m_175515_(this.registryKey);
                Object value = registry.m_6246_(ResourceKey.m_135785_(this.registryKey, (ResourceLocation)name));
                if (value instanceof IAsset) {
                    IAsset asset = (IAsset)value;
                    asset.setRegistryName(name);
                }
                t = (ILostCityAsset)this.assetConstructor.apply(value);
            }
            catch (Exception e) {
                throw new RuntimeException("Error getting resource " + String.valueOf(name) + "!", e);
            }
            this.assets.put(name, t);
        }
        if (t != null) {
            t.init(level);
        }
        return (T)t;
    }

    public void loadAll(CommonLevelAccessor level) {
        if (level == null) {
            return;
        }
        Registry registry = level.m_9598_().m_175515_(this.registryKey);
        for (Object r : registry) {
            ResourceLocation name = registry.m_7981_(r);
            if (this.assets.containsKey(name)) continue;
            if (r instanceof IAsset) {
                IAsset asset = (IAsset)r;
                asset.setRegistryName(name);
            }
            ILostCityAsset t = (ILostCityAsset)this.assetConstructor.apply(r);
            this.assets.put(name, t);
        }
    }

    @Override
    public Iterable<T> getIterable() {
        return this.assets.values();
    }

    public int getNumAssets(CommonLevelAccessor level) {
        return level.m_9598_().m_175515_(this.registryKey).m_13562_();
    }

    public void reset() {
        this.assets.clear();
    }
}

