/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scpfr.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.scpfr.ScpfrMod;
import net.mcreator.scpfr.procedures.AdtoallProcedure;
import net.mcreator.scpfr.procedures.AdventureProcedure;
import net.mcreator.scpfr.procedures.BackProcedure;
import net.mcreator.scpfr.procedures.CreativeProcedure;
import net.mcreator.scpfr.procedures.CrtoallProcedure;
import net.mcreator.scpfr.procedures.SUtoallProcedure;
import net.mcreator.scpfr.procedures.SpctoallProcedure;
import net.mcreator.scpfr.procedures.SpectatorProcedure;
import net.mcreator.scpfr.procedures.SurvivalProcedure;
import net.mcreator.scpfr.world.inventory.GamemodeMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GamemodeButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GamemodeButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GamemodeButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GamemodeButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GamemodeButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GamemodeButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GamemodeMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            AdventureProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SpectatorProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            AdtoallProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            SpctoallProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            CreativeProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SurvivalProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            CrtoallProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            SUtoallProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            BackProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ScpfrMod.addNetworkMessage(GamemodeButtonMessage.class, GamemodeButtonMessage::buffer, GamemodeButtonMessage::new, GamemodeButtonMessage::handler);
    }
}

