/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scpfr.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.scpfr.ScpfrMod;
import net.mcreator.scpfr.procedures.AdtoallProcedure;
import net.mcreator.scpfr.procedures.BackProcedure;
import net.mcreator.scpfr.procedures.CleartoallProcedure;
import net.mcreator.scpfr.procedures.CrtoallProcedure;
import net.mcreator.scpfr.procedures.KillEProcedure;
import net.mcreator.scpfr.procedures.KillProcedure;
import net.mcreator.scpfr.procedures.KillRProcedure;
import net.mcreator.scpfr.procedures.SSPTAProcedure;
import net.mcreator.scpfr.procedures.SUtoallProcedure;
import net.mcreator.scpfr.procedures.SpctoallProcedure;
import net.mcreator.scpfr.procedures.TPProcedure;
import net.mcreator.scpfr.world.inventory.PCGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class PCGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public PCGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public PCGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(PCGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(PCGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            PCGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = PCGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            AdtoallProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            CrtoallProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            SpctoallProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            SUtoallProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            TPProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            SSPTAProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            KillEProcedure.execute((Entity)entity);
        }
        if (buttonID == 7) {
            KillProcedure.execute((Entity)entity);
        }
        if (buttonID == 8) {
            CleartoallProcedure.execute((Entity)entity);
        }
        if (buttonID == 9) {
            BackProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 10) {
            KillRProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ScpfrMod.addNetworkMessage(PCGUIButtonMessage.class, PCGUIButtonMessage::buffer, PCGUIButtonMessage::new, PCGUIButtonMessage::handler);
    }
}

