/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scpfr.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.scpfr.ScpfrMod;
import net.mcreator.scpfr.procedures.ArrowThrowProcedure;
import net.mcreator.scpfr.procedures.BackProcedure;
import net.mcreator.scpfr.procedures.DFThrowProcedure;
import net.mcreator.scpfr.procedures.LFThrowProcedure;
import net.mcreator.scpfr.procedures.PjRemoveProcedure;
import net.mcreator.scpfr.procedures.SFThrowProcedure;
import net.mcreator.scpfr.procedures.WSThrowProcedure;
import net.mcreator.scpfr.world.inventory.ProjectilesGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ProjectilesGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ProjectilesGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ProjectilesGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ProjectilesGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ProjectilesGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ProjectilesGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ProjectilesGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SFThrowProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 1) {
            LFThrowProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 2) {
            DFThrowProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 3) {
            WSThrowProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 4) {
            BackProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 5) {
            PjRemoveProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            ArrowThrowProcedure.execute((Entity)entity, guistate);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ScpfrMod.addNetworkMessage(ProjectilesGUIButtonMessage.class, ProjectilesGUIButtonMessage::buffer, ProjectilesGUIButtonMessage::new, ProjectilesGUIButtonMessage::handler);
    }
}

