/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;

public class PlacementStateBuilder<T extends PlacementStateBuilder<T>> {
    protected final Block block;
    protected final BlockPlaceContext ctx;
    @Nullable
    protected BlockState state;

    protected PlacementStateBuilder(Block block, BlockPlaceContext ctx) {
        this.block = block;
        this.ctx = ctx;
        this.state = block.m_49966_();
    }

    public static PlacementStateBuilder<?> of(Block block, BlockPlaceContext ctx) {
        return new PlacementStateBuilder(block, ctx);
    }

    public final T withHorizontalFacing() {
        return this.withHorizontalFacing(false);
    }

    public final T withHorizontalFacing(boolean opposite) {
        if (this.state == null) {
            return this.self();
        }
        Direction dir = this.ctx.m_8125_();
        if (opposite) {
            dir = dir.m_122424_();
        }
        this.state = (BlockState)this.state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        return this.self();
    }

    public final T withTargetOrHorizontalFacing() {
        return this.withTargetOrHorizontalFacing(false);
    }

    public final T withTargetOrHorizontalFacing(boolean opposite) {
        if (this.state == null) {
            return this.self();
        }
        Direction face = this.ctx.m_43719_();
        if (!Utils.isY(face)) {
            if (!opposite) {
                face = face.m_122424_();
            }
            this.state = (BlockState)this.state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)face);
            return this.self();
        }
        return this.withHorizontalFacing(opposite);
    }

    public final T withHorizontalTargetFacing() {
        return this.withHorizontalTargetFacing(false);
    }

    public final T withHorizontalTargetFacing(boolean opposite) {
        if (this.state == null) {
            return this.self();
        }
        Direction face = this.ctx.m_43719_();
        if (Utils.isY(face)) {
            this.state = null;
            return this.self();
        }
        if (!opposite) {
            face = face.m_122424_();
        }
        this.state = (BlockState)this.state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)face);
        return this.self();
    }

    public final T withTargetFacing() {
        return this.withTargetFacing(false);
    }

    public final T withTargetFacing(boolean opposite) {
        if (this.state == null) {
            return this.self();
        }
        Direction face = this.ctx.m_43719_();
        if (!opposite) {
            face = face.m_122424_();
        }
        this.state = (BlockState)this.state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)face);
        return this.self();
    }

    public final T withHalfOrHorizontalFacing() {
        if (this.state == null) {
            return this.self();
        }
        Direction side = this.ctx.m_43719_();
        this.state = Utils.isY(side) ? (BlockState)this.state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)this.ctx.m_8125_()) : (Utils.fractionInDir(this.ctx.m_43720_(), side.m_122428_()) > 0.5 ? (BlockState)this.state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)side.m_122424_().m_122427_()) : (BlockState)this.state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)side.m_122424_()));
        return this.self();
    }

    public final T withHalfOrQuarterFacing() {
        if (this.state == null) {
            return this.self();
        }
        Direction side = this.ctx.m_43719_();
        if (Utils.isY(side)) {
            double z;
            Direction dir;
            Vec3 hitVec = this.ctx.m_43720_();
            double x = Utils.fractionInDir(hitVec, Direction.EAST);
            if (x > 0.5 != Utils.isPositive(dir = (z = Utils.fractionInDir(hitVec, Direction.SOUTH)) > 0.5 ? Direction.SOUTH : Direction.NORTH)) {
                dir = dir.m_122427_();
            }
            this.state = (BlockState)this.state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
            return this.self();
        }
        return this.withHalfOrHorizontalFacing();
    }

    public final T withHalfFacing() {
        if (this.state == null) {
            return this.self();
        }
        Direction side = this.ctx.m_43719_();
        if (Utils.isY(side)) {
            Direction dir = this.ctx.m_8125_();
            double xz = Utils.fractionInDir(this.ctx.m_43720_(), dir.m_122427_());
            if (xz > 0.5) {
                dir = dir.m_122427_();
            }
            this.state = (BlockState)this.state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir);
            return this.self();
        }
        return this.withHalfOrHorizontalFacing();
    }

    public final T withClickedAxis() {
        if (this.state != null) {
            this.state = (BlockState)this.state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)this.ctx.m_43719_().m_122434_());
        }
        return this.self();
    }

    public final T withTop() {
        return this.withTop(FramedProperties.TOP);
    }

    public final T withTop(BooleanProperty prop) {
        double y;
        if (this.state == null) {
            return this.self();
        }
        Direction side = this.ctx.m_43719_();
        this.state = side == Direction.DOWN ? (BlockState)this.state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(true)) : (side == Direction.UP ? (BlockState)this.state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(false)) : (BlockState)this.state.m_61124_((Property)prop, (Comparable)Boolean.valueOf((y = Utils.fractionInDir(this.ctx.m_43720_(), Direction.UP)) >= 0.5)));
        return this.self();
    }

    public final T tryWithWater() {
        if (this.state != null && this.state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            return this.withWater();
        }
        return this.self();
    }

    public final T withWater() {
        if (this.state == null) {
            return this.self();
        }
        FluidState fluidState = this.ctx.m_43725_().m_6425_(this.ctx.m_8083_());
        this.state = (BlockState)this.state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return this.self();
    }

    public final T withYSlope(boolean ySlope) {
        if (this.state == null) {
            return this.self();
        }
        this.state = (BlockState)this.state.m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope));
        return this.self();
    }

    public final T withCustom(BiFunction<BlockState, BlockPlaceContext, @Nullable BlockState> modifier) {
        if (this.state == null) {
            return this.self();
        }
        this.state = modifier.apply(this.state, this.ctx);
        return this.self();
    }

    public final T validate(BiPredicate<BlockState, BlockPlaceContext> validator) {
        if (!validator.test(this.state, this.ctx)) {
            this.state = null;
        }
        return this.self();
    }

    @Nullable
    public final BlockState build() {
        return this.state;
    }

    protected final T self() {
        return (T)this;
    }
}

