/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block.update;

import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.ApiStatus;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.update.CullingUpdatePacket;

public final class CullingUpdateTracker {
    private static final Map<ResourceKey<Level>, LongSet> UPDATED_POSITIONS = new IdentityHashMap<ResourceKey<Level>, LongSet>();

    @ApiStatus.Internal
    public static void onServerLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.level.m_5776_()) {
            return;
        }
        ResourceKey dim = event.level.m_46472_();
        LongSet positions = UPDATED_POSITIONS.get(dim);
        if (positions != null && !positions.isEmpty()) {
            FramedBlocks.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> dim), (Object)new CullingUpdatePacket(positions));
            positions.clear();
        }
    }

    public static void enqueueCullingUpdate(Level level, BlockPos pos) {
        UPDATED_POSITIONS.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), $ -> new LongArraySet()).add(pos.m_121878_());
    }

    private CullingUpdateTracker() {
    }
}

