/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanelcorner;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelModel;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedSmallInnerCornerSlopePanelWallModel
extends FramedBlockModel {
    private final Direction dir;
    private final Direction horRotDir;
    private final Direction vertRotDir;
    private final boolean ySlope;

    public FramedSmallInnerCornerSlopePanelWallModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rot.withFacing(this.dir);
        Direction perpRotDir = rot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(this.dir);
        this.horRotDir = Utils.isY(rotDir) ? perpRotDir : rotDir;
        this.vertRotDir = Utils.isY(rotDir) ? rotDir : perpRotDir;
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        boolean up;
        Direction quadDir = quad.m_111306_();
        boolean cw = this.horRotDir == this.dir.m_122427_();
        boolean bl = up = this.vertRotDir == Direction.UP;
        if (quadDir == this.dir) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.horRotDir.m_122424_(), 0.5f)).apply(Modifiers.cutSideUpDown(this.vertRotDir == Direction.UP, 0.5f)).export(quadMap.get(quadDir));
        } else if (quadDir == this.horRotDir.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(up, 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        } else if (quadDir == this.vertRotDir.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.horRotDir.m_122424_(), 0.5f)).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        } else if (quadDir == this.horRotDir) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(up, 0.5f)).apply(Modifiers.cutSideUpDown(!up, cw ? 0.5f : 1.0f, cw ? 1.0f : 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(up, cw ? 0.5f : 0.0f, cw ? 0.0f : 0.5f)).apply(Modifiers.makeHorizontalSlope(cw, FramedSlopePanelModel.SLOPE_ANGLE)).export(quadMap.get(null));
        } else if (!this.ySlope && quadDir == this.dir.m_122424_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.horRotDir.m_122424_(), up ? 0.0f : 0.5f, up ? 0.5f : 0.0f)).apply(Modifiers.makeVerticalSlope(up, FramedSlopePanelModel.SLOPE_ANGLE_VERT)).apply(Modifiers.offset(this.vertRotDir, 0.5f)).export(quadMap.get(null));
        } else if (quadDir == this.vertRotDir) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.horRotDir.m_122424_(), 0.5f)).apply(Modifiers.cutTopBottom(this.horRotDir, cw ? 0.5f : 1.0f, cw ? 1.0f : 0.5f)).export(quadMap.get(quadDir));
            if (this.ySlope) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.horRotDir.m_122424_(), cw ? 0.0f : 0.5f, cw ? 0.5f : 0.0f)).apply(Modifiers.makeVerticalSlope(this.dir.m_122424_(), FramedSlopePanelModel.SLOPE_ANGLE)).export(quadMap.get(null));
            }
        }
    }
}

