/*
 * Decompiled with CFR 0.152.
 */
package christmas_decorations.renderer;

import christmas_decorations.entity.RopeSegmentEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10017;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_897;

@Environment(value=EnvType.CLIENT)
public class RopeSegmentEntityRenderer
extends class_897<RopeSegmentEntity, RopeRenderState> {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"christmas_decorations", (String)"textures/entity/rope.png");
    private static final class_1921 RENDER_LAYER = class_1921.method_23580((class_2960)TEXTURE);

    public RopeSegmentEntityRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    public RopeRenderState createRenderState() {
        return new RopeRenderState();
    }

    public void updateRenderState(RopeSegmentEntity entity, RopeRenderState state, float tickDelta) {
        super.method_62354((class_1297)entity, (class_10017)state, tickDelta);
        state.start = entity.getStart();
        state.end = entity.getEnd();
        state.entityPos = entity.method_73189();
        state.segmentIndex = entity.getSegmentIndex();
        state.totalSegments = entity.getTotalSegments();
        state.light = this.method_24088(entity, tickDelta);
    }

    public void render(RopeRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        matrices.method_22903();
        class_243 start = state.start;
        class_243 end = state.end;
        class_243 entityPos = state.entityPos;
        int segmentIndex = state.segmentIndex;
        int totalSegments = state.totalSegments;
        if (segmentIndex < totalSegments) {
            double t = (double)segmentIndex / (double)totalSegments;
            double nextT = (double)(segmentIndex + 1) / (double)totalSegments;
            class_243 currentPos = start.method_35590(end, t);
            class_243 nextPos = start.method_35590(end, nextT);
            double distance = start.method_1022(end);
            double currentSag = this.calculateSag(t, distance);
            double nextSag = this.calculateSag(nextT, distance);
            currentPos = currentPos.method_1031(0.0, -currentSag, 0.0);
            nextPos = nextPos.method_1031(0.0, -nextSag, 0.0);
            class_243 relCurrent = currentPos.method_1020(entityPos);
            class_243 relNext = nextPos.method_1020(entityPos);
            class_4597.class_4598 vertexConsumers = class_310.method_1551().method_22940().method_23000();
            class_4588 buffer = vertexConsumers.method_73477(RENDER_LAYER);
            class_4587.class_4665 entry = matrices.method_23760();
            float width = 0.03f;
            this.drawRopeLine(buffer, entry, relCurrent, relNext, width, state.light);
        }
        matrices.method_22909();
    }

    private void drawRopeLine(class_4588 buffer, class_4587.class_4665 entry, class_243 from, class_243 to, float width, int light) {
        class_243 direction = to.method_1020(from).method_1029();
        class_243 perpendicular = new class_243(-direction.field_1350, 0.0, direction.field_1352).method_1029();
        if (perpendicular.method_1027() < 0.01) {
            perpendicular = new class_243(1.0, 0.0, 0.0);
        }
        class_243 offset = perpendicular.method_1021((double)width);
        class_243 p1 = from.method_1019(offset);
        class_243 p2 = from.method_1020(offset);
        class_243 p3 = to.method_1020(offset);
        class_243 p4 = to.method_1019(offset);
        float nx = 0.0f;
        float ny = 1.0f;
        float nz = 0.0f;
        this.addVertex(buffer, entry, p1, 0.0f, 0.0f, nx, ny, nz, light);
        this.addVertex(buffer, entry, p2, 1.0f, 0.0f, nx, ny, nz, light);
        this.addVertex(buffer, entry, p3, 1.0f, 1.0f, nx, ny, nz, light);
        this.addVertex(buffer, entry, p4, 0.0f, 1.0f, nx, ny, nz, light);
    }

    private void addVertex(class_4588 buffer, class_4587.class_4665 entry, class_243 pos, float u, float v, float nx, float ny, float nz, int light) {
        buffer.method_22918(entry.method_23761(), (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350).method_1336(255, 255, 255, 255).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_60831(entry, nx, ny, nz);
    }

    private double calculateSag(double t, double distance) {
        double maxSag = Math.min(distance * 0.15, 2.0);
        return 4.0 * maxSag * t * (1.0 - t);
    }

    @Environment(value=EnvType.CLIENT)
    public static class RopeRenderState
    extends class_10017 {
        public class_243 start;
        public class_243 end;
        public class_243 entityPos;
        public int segmentIndex;
        public int totalSegments;
        public int light;
    }
}

